/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.math.BigDecimal;
import org.hsqldb.map.ValuePoolHashMap;

public final class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static final int SPACE_STRING_SIZE = 64;
    static final int DEFAULT_VALUE_POOL_SIZE = 4096;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    public static final String spaceString;
    public static final Integer INTEGER_0;
    public static final Integer INTEGER_1;
    public static final Integer INTEGER_2;
    public static final Integer INTEGER_MAX;
    public static final BigDecimal BIG_DECIMAL_0;
    public static final BigDecimal BIG_DECIMAL_1;
    public static final String[] emptyStringArray;
    public static final Object[] emptyObjectArray;
    public static final int[] emptyIntArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] sizeArray = defaultPoolLookupSize;
        int sizeFactor = 2;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int size = sizeArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(size, size * sizeFactor, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static int getMaxStringLength() {
        return maxStringLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int val) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long val) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long val) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String val) {
        if (val == null || val.length() > maxStringLength) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubString(String val, int start, int limit) {
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(val.substring(start, limit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal val) {
        if (val == null) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(val);
        }
    }

    public static Boolean getBoolean(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        defaultPoolLookupSize = new int[]{4096, 4096, 4096, 4096, 4096};
        POOLS_COUNT = defaultPoolLookupSize.length;
        char[] c = new char[64];
        for (int i = 0; i < 64; ++i) {
            c[i] = 32;
        }
        spaceString = new String(c);
        ValuePool.initPool();
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
        INTEGER_2 = ValuePool.getInt(2);
        INTEGER_MAX = ValuePool.getInt(Integer.MAX_VALUE);
        BIG_DECIMAL_0 = ValuePool.getBigDecimal(BigDecimal.valueOf(0L));
        BIG_DECIMAL_1 = ValuePool.getBigDecimal(new BigDecimal(1));
        emptyStringArray = new String[0];
        emptyObjectArray = new Object[0];
        emptyIntArray = new int[0];
    }
}

