/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import org.hsqldb.map.BaseHashMap;
import org.hsqldb.types.TimestampData;

public class ValuePoolHashMap
extends BaseHashMap {
    long hits;

    public ValuePoolHashMap(int initialCapacity, int maxCapacity, int purgePolicy) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, true);
        this.maxCapacity = maxCapacity;
        this.purgePolicy = purgePolicy;
    }

    protected Integer getOrAddInteger(int intKey) {
        Integer testValue;
        int index = this.hashIndex.getHashIndex(intKey);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Integer)this.objectKeyTable[lookup];
            int keyValue = testValue;
            if (keyValue == intKey) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            if (keyValue > intKey) break;
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(intKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = intKey;
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected Long getOrAddLong(long longKey) {
        Long testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Long)this.objectKeyTable[lookup];
            long keyValue = testValue;
            if (keyValue == longKey) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            if (keyValue > longKey) break;
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = longKey;
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected String getOrAddString(Object key) {
        String testValue;
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (String)this.objectKeyTable[lookup];
            if (key.equals(testValue)) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(key);
        }
        testValue = key.toString();
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected String getOrAddSubString(String key, int from, int limit) {
        String testValue;
        key = key.substring(from, limit);
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (String)this.objectKeyTable[lookup];
            if (key.equals(testValue)) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(key);
        }
        testValue = new String(key.toCharArray());
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected TimestampData getOrAddDate(long longKey) {
        TimestampData testValue;
        int hash = (int)longKey ^ (int)(longKey >>> 32);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (TimestampData)this.objectKeyTable[lookup];
            if (testValue.getSeconds() == longKey) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new TimestampData(longKey);
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected Double getOrAddDouble(long longKey) {
        Double testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Double)this.objectKeyTable[lookup];
            if (Double.doubleToLongBits(testValue) == longKey) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = Double.longBitsToDouble(longKey);
        this.objectKeyTable[lookup] = testValue;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return testValue;
    }

    protected Object getOrAddObject(Object key) {
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            Object testValue = this.objectKeyTable[lookup];
            if (testValue.equals(key)) {
                int count = this.accessCount.incrementAndGet();
                if (count < 0) {
                    this.resetAccessCount();
                    count = this.accessCount.incrementAndGet();
                }
                this.accessTable[lookup] = count;
                ++this.hits;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(key);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = key;
        int count = this.accessCount.incrementAndGet();
        if (count < 0) {
            this.resetAccessCount();
            count = this.accessCount.incrementAndGet();
        }
        this.accessTable[lookup] = count;
        return key;
    }
}

