/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.util.Comparator;
import java.util.TreeMap;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorData
extends RowSetNavigator
implements Comparator<Object[]> {
    public static final Object[][] emptyTable = new Object[0][];
    private Object[][] dataTable = emptyTable;
    int visibleColumnCount;
    boolean isAggregate;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    boolean reindexTable;
    Index mainIndex;
    Index fullIndex;
    Index orderIndex;
    Index groupIndex;
    Index idIndex;
    final SortAndSlice sortAndSlice;
    TreeMap<Object[], Integer> groupMap;
    LongKeyHashMap idMap;

    RowSetNavigatorData(Session session, SortAndSlice sortAndSlice) {
        this.session = session;
        this.sortAndSlice = sortAndSlice;
    }

    public RowSetNavigatorData(Session session, QuerySpecification select) {
        this.session = session;
        this.rangePosition = select.resultRangePosition;
        this.visibleColumnCount = select.getColumnCount();
        this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        this.mainIndex = select.mainIndex;
        this.fullIndex = select.fullIndex;
        this.orderIndex = select.orderIndex;
        this.sortAndSlice = select.sortAndSlice;
        if (select.isGrouped) {
            this.mainIndex = select.groupIndex;
            this.groupMap = new TreeMap(this);
        }
        if (select.idIndex != null) {
            this.idMap = new LongKeyHashMap();
        }
    }

    public RowSetNavigatorData(Session session, QueryExpression queryExpression) {
        this.session = session;
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
        this.orderIndex = queryExpression.orderIndex;
        this.visibleColumnCount = queryExpression.getColumnCount();
        this.sortAndSlice = queryExpression.sortAndSlice;
    }

    public RowSetNavigatorData(Session session, RowSetNavigator navigator) {
        this.session = session;
        this.sortAndSlice = SortAndSlice.noSort;
        this.setCapacity(navigator.size);
        while (navigator.next()) {
            this.add(navigator.getCurrent());
        }
    }

    public void sortFull() {
        this.mainIndex = this.fullIndex;
        ArraySort.sort((Object[])this.dataTable, this.size, this);
        this.reset();
    }

    public void sortOrder() {
        if (this.orderIndex != null) {
            this.mainIndex = this.orderIndex;
            ArraySort.sort((Object[])this.dataTable, this.size, this);
        }
        this.reset();
    }

    public void sortOrderUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            ArraySort.sort((Object[])this.dataTable, this.size, this);
            this.reset();
        }
    }

    @Override
    public void add(Object[] data) {
        this.ensureCapacity();
        this.dataTable[this.size] = data;
        if (this.groupMap != null) {
            this.groupMap.put(data, this.size);
        }
        if (this.idMap != null) {
            Long id = (Long)data[this.visibleColumnCount];
            this.idMap.put((long)id, data);
        }
        ++this.size;
    }

    public void setPosition(Object[] data) {
        int pos;
        Integer mapPos = this.groupMap.get(data);
        if (mapPos == null) {
            return;
        }
        this.currentPos = pos = mapPos.intValue();
    }

    @Override
    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorData");
    }

    public void update(Object[] oldData, Object[] newData) {
    }

    void addAdjusted(Object[] data, int[] columnMap) {
        data = this.projectData(data, columnMap);
        this.add(data);
    }

    void insertAdjusted(Object[] data, int[] columnMap) {
        data = this.projectData(data, columnMap);
        this.insert(data);
    }

    Object[] projectData(Object[] data, int[] columnMap) {
        if (columnMap == null) {
            data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.visibleColumnCount);
        } else {
            Object[] newData = new Object[this.visibleColumnCount];
            ArrayUtil.projectRow(data, columnMap, newData);
            data = newData;
        }
        return data;
    }

    void insert(Object[] data) {
        this.ensureCapacity();
        System.arraycopy(this.dataTable, this.currentPos, this.dataTable, this.currentPos + 1, this.size - this.currentPos);
        this.dataTable[this.currentPos] = data;
        ++this.size;
    }

    public Object[][] getDataTable() {
        return this.dataTable;
    }

    @Override
    public void release() {
        this.dataTable = emptyTable;
        this.size = 0;
        this.reset();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.dataTable = emptyTable;
        this.size = 0;
        this.reset();
    }

    public void resetRowMap() {
        this.groupMap = new TreeMap(this);
    }

    @Override
    public boolean absolute(int position) {
        return super.absolute(position);
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        return this.dataTable[this.currentPos];
    }

    @Override
    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorData");
    }

    public Object[] getNextRowData() {
        return this.next() ? this.getCurrent() : null;
    }

    @Override
    public boolean next() {
        return super.next();
    }

    @Override
    public void removeCurrent() {
        System.arraycopy(this.dataTable, this.currentPos + 1, this.dataTable, this.currentPos, this.size - this.currentPos - 1);
        this.dataTable[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    public void removeRange(int start, int rows) {
        ArrayUtil.adjustArray(76, this.dataTable, this.size, start, -rows);
        if (this.currentPos >= start + rows) {
            this.currentPos -= rows;
        } else if (this.currentPos >= start) {
            this.currentPos = start;
        }
        this.size -= rows;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) {
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.next()) {
            Object[] data = this.getCurrent();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public Object[] getData(long rowId) {
        return (Object[])this.idMap.get(rowId);
    }

    public void copy(RowIterator other, int[] rightColumnIndexes) {
        while (other.next()) {
            Object[] currentData = other.getCurrent();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
    }

    public void union(RowSetNavigatorData other) {
        this.removeDuplicates();
        other.removeDuplicates();
        this.mainIndex = this.fullIndex;
        while (other.next()) {
            Object[] currentData = other.getCurrent();
            int position = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, currentData, this);
            if (position >= 0) continue;
            this.currentPos = position = -position - 1;
            this.insert(currentData);
        }
        this.reset();
    }

    public void unionAll(RowSetNavigatorData other) {
        this.mainIndex = this.fullIndex;
        other.reset();
        while (other.next()) {
            Object[] currentData = other.getCurrent();
            this.add(currentData);
        }
        this.reset();
    }

    public void intersect(RowSetNavigatorData other) {
        this.removeDuplicates();
        other.sortFull();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void intersectAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Object[] otherData = null;
        this.sortFull();
        other.sortFull();
        RowIterator it = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean newGroup;
            Object[] currentData = this.getCurrent();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, compareData, this.visibleColumnCount) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if (it.next() && this.fullIndex.compareRowNonUnique((Session)this.session, currentData, otherData = it.getCurrent(), this.visibleColumnCount) == 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void except(RowSetNavigatorData other) {
        this.removeDuplicates();
        other.sortFull();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void exceptNoDedup(RowSetNavigatorData other) {
        other.sortFull();
        this.reset();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void exceptAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Object[] otherData = null;
        this.sortFull();
        other.sortFull();
        RowIterator it = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean newGroup;
            Object[] currentData = this.getCurrent();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if (!it.next() || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, otherData = it.getCurrent(), this.fullIndex.getColumnCount()) != 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        this.reset();
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.fullIndex.compareRow((Session)this.session, lastRowData, currentData) == 0) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    public void removeDuplicates() {
        this.sortFull();
        this.reset();
        int lastRowPos = -1;
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (lastRowData == null) {
                lastRowPos = this.currentPos;
                lastRowData = currentData;
                continue;
            }
            if (this.fullIndex.compareRow((Session)this.session, lastRowData, currentData) == 0) continue;
            lastRowData = currentData;
            this.dataTable[++lastRowPos] = currentData;
        }
        for (int i = lastRowPos + 1; i < this.size; ++i) {
            this.dataTable[i] = null;
        }
        this.size = lastRowPos + 1;
        this.reset();
    }

    public void trim(int limitstart, int limitcount) {
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if ((long)limitstart + (long)limitcount < (long)this.size) {
            this.reset();
            this.removeRange(limitstart + limitcount, this.size - limitstart - limitcount);
        }
        this.removeRange(0, limitstart);
    }

    boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        Integer position = this.groupMap.get(data);
        if (position == null) {
            return null;
        }
        int pos = position;
        return this.dataTable[pos];
    }

    public Object[] getGroupDataAndPosition(Object[] data) {
        int pos;
        Integer mapPos = this.groupMap.get(data);
        if (mapPos == null) {
            return null;
        }
        this.currentPos = pos = mapPos.intValue();
        return this.dataTable[pos];
    }

    boolean containsRow(Object[] data) {
        int position = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, data, this);
        return position >= 0;
    }

    RowIterator findFirstRow(Object[] data) {
        int position = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, data, this);
        position = position < 0 ? this.size : --position;
        return new DataIterator(position);
    }

    void getBlock(int offset) {
    }

    private void setCapacity(int newSize) {
        if (this.size > this.dataTable.length) {
            this.dataTable = new Object[newSize][];
        }
    }

    private void ensureCapacity() {
        if (this.size == this.dataTable.length) {
            int newSize = this.size == 0 ? 4 : this.size * 2;
            Object[][] newTable = new Object[newSize][];
            System.arraycopy(this.dataTable, 0, newTable, 0, this.size);
            this.dataTable = newTable;
        }
    }

    @Override
    public int compare(Object[] a, Object[] b) {
        return this.mainIndex.compareRow((Session)this.session, a, b);
    }

    class DataIterator
    implements RowIterator {
        int pos;

        DataIterator(int position) {
            this.pos = position;
        }

        @Override
        public Object getField(int col) {
            if (this.pos < RowSetNavigatorData.this.size) {
                return RowSetNavigatorData.this.dataTable[this.pos][col];
            }
            return null;
        }

        @Override
        public boolean next() {
            if (this.pos < RowSetNavigatorData.this.size - 1) {
                ++this.pos;
                return true;
            }
            return false;
        }

        @Override
        public Row getCurrentRow() {
            return null;
        }

        @Override
        public Object[] getCurrent() {
            if (this.pos < RowSetNavigatorData.this.size) {
                return RowSetNavigatorData.this.dataTable[this.pos];
            }
            return null;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }
    }
}

