/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import org.hsqldb.HsqlException;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorDataTable
extends RowSetNavigatorData {
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    Row currentRow;
    Object[] tempRowData;

    public RowSetNavigatorDataTable(Session session, QuerySpecification select) {
        super(session, select.sortAndSlice);
        this.rangePosition = select.resultRangePosition;
        this.visibleColumnCount = select.indexLimitVisible;
        this.table = select.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !select.isAggregated);
        this.isAggregate = select.isAggregated;
        this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        this.reindexTable = select.isGrouped;
        this.mainIndex = select.mainIndex;
        this.fullIndex = select.fullIndex;
        this.orderIndex = select.orderIndex;
        this.groupIndex = select.groupIndex;
        this.idIndex = select.idIndex;
        this.tempRowData = new Object[1];
    }

    public RowSetNavigatorDataTable(Session session, QuerySpecification select, RowSetNavigatorData navigator) {
        this(session, select);
        navigator.reset();
        while (navigator.next()) {
            this.add(navigator.getCurrent());
        }
    }

    public RowSetNavigatorDataTable(Session session, QueryExpression queryExpression) {
        super(session, queryExpression.sortAndSlice);
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorDataTable(Session session, Table table) {
        super(session, SortAndSlice.noSort);
        this.table = table;
        this.visibleColumnCount = table.getColumnCount();
        this.mainIndex = table.getPrimaryIndex();
        this.fullIndex = table.getFullIndex(session);
        this.store = table.getRowStore(session);
        this.size = (int)this.store.elementCount();
        this.reset();
    }

    @Override
    public void sortFull() {
        if (this.reindexTable) {
            this.store.indexRows((Session)this.session);
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    @Override
    public void sortOrder() {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows((Session)this.session);
            }
            this.mainIndex = this.orderIndex;
            if (this.iterator != null) {
                this.iterator.release();
            }
            this.reset();
        }
    }

    @Override
    public void sortOrderUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    @Override
    public void add(Object[] data) {
        try {
            if (this.table.getDataColumnCount() > data.length) {
                Object[] d = this.table.getEmptyRowData();
                ArrayUtil.copyArray(data, d, data.length);
                data = d;
            }
            Row row = (Row)this.store.getNewCachedObject((Session)this.session, data, false);
            this.store.indexRow((Session)this.session, row);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    void addAdjusted(Object[] data, int[] columnMap) {
        try {
            if (columnMap == null) {
                data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.visibleColumnCount);
            } else {
                Object[] newData = new Object[this.visibleColumnCount];
                ArrayUtil.projectRow(data, columnMap, newData);
                data = newData;
            }
            this.add(data);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void update(Object[] oldData, Object[] newData) {
        if (this.isSimpleAggregate) {
            return;
        }
        RowIterator it = this.groupIndex.findFirstRow((Session)this.session, this.store, oldData);
        if (it.next()) {
            it.removeCurrent();
            it.release();
            --this.size;
            this.add(newData);
        }
    }

    @Override
    public boolean absolute(int position) {
        return super.absolute(position);
    }

    @Override
    public Object[] getCurrent() {
        return this.currentRow.getData();
    }

    @Override
    public Row getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        boolean result = super.next();
        if (!result) {
            return false;
        }
        this.iterator.next();
        this.currentRow = this.iterator.getCurrentRow();
        return result;
    }

    @Override
    public void removeCurrent() {
        if (this.currentRow != null) {
            this.iterator.removeCurrent();
            this.currentRow = null;
            --this.currentPos;
            --this.size;
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.iterator != null) {
            this.iterator.release();
        }
        this.iterator = this.mainIndex.firstRow((Session)this.session, this.store, null, 0, null);
    }

    @Override
    public void release() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.store.release();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.store.removeAll();
        this.size = 0;
        this.reset();
    }

    @Override
    public boolean isMemory() {
        return this.store.isMemory();
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) {
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.next()) {
            Object[] data = this.getCurrent();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public Object[] getData(Long rowId) {
        this.tempRowData[0] = rowId;
        RowIterator it = this.idIndex.findFirstRow((Session)this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        it.next();
        return it.getCurrent();
    }

    public void copy(RowSetNavigatorData other, int[] rightColumnIndexes) {
        while (other.next()) {
            Object[] currentData = other.getCurrent();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
    }

    @Override
    public void union(RowSetNavigatorData other) {
        int colCount = this.table.getColumnTypes().length;
        this.removeDuplicates();
        other.reset();
        while (other.next()) {
            Object[] currentData = other.getCurrent();
            RowIterator it = this.findFirstRow(currentData);
            if (!it.next()) {
                currentData = (Object[])ArrayUtil.resizeArrayIfDifferent(currentData, colCount);
                this.add(currentData);
            }
            it.release();
        }
        this.reset();
    }

    @Override
    public void intersect(RowSetNavigatorData other) {
        this.removeDuplicates();
        other.sortFull();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void intersectAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Object otherRow = null;
        Object[] otherData = null;
        this.sortFull();
        other.sortFull();
        RowIterator it = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean newGroup;
            Object[] currentData = this.getCurrent();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if (it.next() && this.fullIndex.compareRowNonUnique((Session)this.session, currentData, otherData = it.getCurrent(), this.fullIndex.getColumnCount()) == 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void except(RowSetNavigatorData other) {
        this.removeDuplicates();
        other.sortFull();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void exceptNoDedup(RowSetNavigatorData other) {
        other.sortFull();
        this.reset();
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void exceptAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Object[] otherData = null;
        this.sortFull();
        other.sortFull();
        RowIterator it = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean newGroup;
            Object[] currentData = this.getCurrent();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if (!it.next() || this.fullIndex.compareRowNonUnique((Session)this.session, currentData, otherData = it.getCurrent(), this.fullIndex.getColumnCount()) != 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.fullIndex.compareRow((Session)this.session, lastRowData, currentData) == 0) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    @Override
    public void removeDuplicates() {
        this.sortFull();
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (lastRowData != null && this.fullIndex.compareRow((Session)this.session, lastRowData, currentData) == 0) {
                this.removeCurrent();
                continue;
            }
            lastRowData = currentData;
        }
        this.reset();
    }

    @Override
    public void trim(int limitstart, int limitcount) {
        int i;
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if (limitstart != 0) {
            this.reset();
            for (i = 0; i < limitstart; ++i) {
                this.next();
                this.removeCurrent();
            }
        }
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        this.reset();
        for (i = 0; i < limitcount; ++i) {
            this.next();
        }
        while (this.next()) {
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator it = this.groupIndex.findFirstRow((Session)this.session, this.store, data);
        if (it.next()) {
            Row row = it.getCurrentRow();
            if (this.isAggregate) {
                row.setChanged(true);
            }
            return row.getData();
        }
        return null;
    }

    @Override
    boolean containsRow(Object[] data) {
        RowIterator it = this.mainIndex.findFirstRow((Session)this.session, this.store, data);
        boolean result = it.next();
        it.release();
        return result;
    }

    @Override
    RowIterator findFirstRow(Object[] data) {
        return this.mainIndex.findFirstRow((Session)this.session, this.store, data);
    }
}

