/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.TextCache;

public class Cache
extends BaseHashMap {
    private int reserveCount;
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private final BaseHashMap.BaseHashIterator objectIterator;
    private final boolean updateAccess;
    private CachedObject[] rowTable;
    private long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch shadowTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dfc) {
        super(dfc.capacity(), 3, 0, true);
        this.maxCapacity = dfc.capacity();
        this.dataFileCache = dfc;
        this.capacity = dfc.capacity();
        this.bytesCapacity = dfc.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
        this.objectIterator = new BaseHashMap.BaseHashIterator(this, true);
        this.updateAccess = dfc instanceof TextCache;
        this.comparator = this.rowComparator;
        this.reserveCount = dfc instanceof TextCache || dfc instanceof DataFileCacheSession ? 0 : 8;
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public CachedObject get(long pos) {
        int lookup = this.getObjectLookup(pos);
        if (lookup == -1) {
            return null;
        }
        this.accessTable[lookup] = this.accessCount.incrementAndGet();
        CachedObject object = (CachedObject)this.objectKeyTable[lookup];
        return object;
    }

    void put(CachedObject row) {
        int storageSize = row.getStorageSize();
        if (!this.preparePut(storageSize)) {
            long value = this.size() + this.reserveCount >= this.capacity ? (long)this.capacity : this.bytesCapacity / 1024L;
            throw Error.error(471, String.valueOf(value));
        }
        this.putNoCheck(row);
    }

    void putUsingReserve(CachedObject row) {
        int storageSize = row.getStorageSize();
        this.preparePut(storageSize);
        if (this.size() >= this.capacity) {
            throw Error.error(471, String.valueOf(this.capacity));
        }
        this.putNoCheck(row);
    }

    boolean preparePut(int storageSize) {
        boolean exceedsSize;
        boolean exceedsCount = this.size() + this.reserveCount >= this.capacity;
        boolean bl = exceedsSize = (long)storageSize + this.cacheBytesLength > this.bytesCapacity;
        if (exceedsCount || exceedsSize) {
            this.cleanUp(false);
            exceedsCount = this.size() + this.reserveCount >= this.capacity;
            boolean bl2 = exceedsSize = (long)storageSize + this.cacheBytesLength > this.bytesCapacity;
            if (!exceedsCount && !exceedsSize) {
                return true;
            }
            this.clearUnchanged();
            exceedsCount = this.size() + this.reserveCount >= this.capacity;
            boolean bl3 = exceedsSize = (long)storageSize + this.cacheBytesLength > this.bytesCapacity;
            if (!exceedsCount && !exceedsSize) {
                return true;
            }
            this.cleanUp(true);
            exceedsCount = this.size() + this.reserveCount >= this.capacity;
            boolean bl4 = exceedsSize = (long)storageSize + this.cacheBytesLength > this.bytesCapacity;
            if (exceedsCount) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE ROWS limit reached");
            }
            if (exceedsSize) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE SIZE limit reached");
            }
            if (exceedsCount || exceedsSize) {
                return false;
            }
        }
        return true;
    }

    private void putNoCheck(CachedObject row) {
        Object existing = this.addOrRemoveObject(row.getPos(), row, false);
        if (existing != null) {
            this.dataFileCache.logSevereEvent("existing object in Cache.put() " + row.getPos() + " " + row.getStorageSize(), null);
        }
        row.setInMemory(true);
        this.cacheBytesLength += (long)row.getStorageSize();
    }

    CachedObject release(long pos) {
        CachedObject r = (CachedObject)this.addOrRemoveObject(pos, null, true);
        if (r == null) {
            return null;
        }
        this.cacheBytesLength -= (long)r.getStorageSize();
        r.setInMemory(false);
        return r;
    }

    public void releaseRange(IntIndex list, int fileBlockItemCount) {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject o = (CachedObject)this.objectIterator.next();
            long pos = o.getPos();
            int block = (int)(pos / (long)fileBlockItemCount);
            int index = list.findFirstEqualKeyIndex(block);
            if (index < 0) continue;
            o.setInMemory(false);
            this.objectIterator.remove();
            this.cacheBytesLength -= (long)o.getStorageSize();
        }
    }

    public void releaseRange(long startPos, long limitPos) {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject o = (CachedObject)this.objectIterator.next();
            long pos = o.getPos();
            if (pos < startPos || pos >= limitPos) continue;
            o.setInMemory(false);
            this.objectIterator.remove();
            this.cacheBytesLength -= (long)o.getStorageSize();
        }
    }

    private void updateAccessCounts() {
        if (this.updateAccess) {
            for (int i = 0; i < this.objectKeyTable.length; ++i) {
                int count;
                CachedObject row = (CachedObject)this.objectKeyTable[i];
                if (row == null || (count = row.getAccessCount()) <= this.accessTable[i]) continue;
                this.accessTable[i] = count;
            }
        }
    }

    private void updateObjectAccessCounts() {
        if (this.updateAccess) {
            for (int i = 0; i < this.objectKeyTable.length; ++i) {
                CachedObject row = (CachedObject)this.objectKeyTable[i];
                if (row == null) continue;
                int count = this.accessTable[i];
                row.updateAccessCount(count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(boolean all) {
        this.updateAccessCounts();
        if (this.accessCount.get() > 0x7FEFFFFF || this.accessCount.get() < 0) {
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        int savecount = 0;
        int removeCount = this.size() / 2;
        int accessTarget = all ? this.accessCount.get() + 1 : this.getAccessCountCeiling(removeCount, removeCount / 8);
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject row;
            CachedObject cachedObject = row = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject) {
                boolean saveRow;
                int currentAccessCount = this.objectIterator.getAccessCount();
                boolean oldRow = currentAccessCount < accessTarget;
                boolean newRow = row.isNew() && row.getStorageSize() >= 4096;
                boolean bl = saveRow = row.hasChanged() && (oldRow || newRow);
                if (saveRow) {
                    this.rowTable[savecount++] = row;
                }
                if (oldRow) {
                    if (row.isKeepInMemory()) {
                        this.objectIterator.setAccessCount(accessTarget);
                    } else {
                        row.setInMemory(false);
                        this.objectIterator.remove();
                        this.cacheBytesLength -= (long)row.getStorageSize();
                    }
                }
            }
            if (savecount != this.rowTable.length) continue;
            this.saveRows(savecount);
            savecount = 0;
        }
        this.saveRows(savecount);
        this.setAccessCountFloor(accessTarget);
        this.accessCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnchanged() {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject row;
            CachedObject cachedObject = row = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject) {
                if (!row.isKeepInMemory() && !row.hasChanged()) {
                    row.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)row.getStorageSize();
                }
            }
        }
    }

    private void saveRows(int count) {
        if (count == 0) {
            return;
        }
        this.rowComparator.setType(1);
        ArraySort.sort(this.rowTable, count, this.rowComparator);
        this.dataFileCache.saveRows(this.rowTable, 0, count);
        this.saveRowCount += count;
    }

    void saveAll() {
        int savecount = 0;
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject r;
            if (savecount == this.rowTable.length) {
                this.saveRows(savecount);
                savecount = 0;
            }
            if (!(r = (CachedObject)this.objectIterator.next()).hasChanged()) continue;
            this.rowTable[savecount] = r;
            ++savecount;
        }
        this.saveRows(savecount);
    }

    void logSaveRowsEvent(int saveCount, long storageSize, long startTime) {
        long time = this.saveAllTimer.elapsedTime();
        StringBuilder sb = new StringBuilder();
        sb.append("cache save rows total [count,time] ");
        sb.append(this.saveRowCount + saveCount);
        sb.append(',').append(time).append(' ');
        sb.append("operation [count,time,size]").append(saveCount).append(',');
        sb.append(time - startTime).append(',');
        sb.append(storageSize).append(' ');
        sb.append("tx-ts ");
        sb.append(this.dataFileCache.database.txManager.getSystemChangeNumber());
        this.dataFileCache.logDetailEvent(sb.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    public Iterator getIterator() {
        this.objectIterator.reset();
        return this.objectIterator;
    }

    protected AtomicInteger getAccessCount() {
        return this.accessCount;
    }

    static final class CachedObjectComparator
    implements Comparator<CachedObject>,
    ObjectComparator<CachedObject> {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType = 1;
        private long compareCount;

        CachedObjectComparator() {
        }

        void setType(int type) {
            this.compareType = type;
            this.compareCount = 0L;
        }

        @Override
        public int compare(CachedObject a, CachedObject b) {
            long diff;
            ++this.compareCount;
            switch (this.compareType) {
                case 1: {
                    diff = a.getPos() - b.getPos();
                    break;
                }
                case 2: {
                    diff = a.getStorageSize() - b.getStorageSize();
                    break;
                }
                default: {
                    return 0;
                }
            }
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }

        @Override
        public boolean equals(CachedObject a, CachedObject b) {
            return this.compare(a, b) == 0;
        }

        @Override
        public int hashCode(CachedObject o) {
            return o.hashCode();
        }

        @Override
        public long longKey(CachedObject o) {
            return o.getPos();
        }
    }
}

