/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.persist.CachedObject;

public abstract class CachedObjectBase
implements CachedObject {
    boolean isMemory;
    long position;
    int storageSize;
    boolean isInMemory;
    boolean hasChanged;
    int keepCount;
    int accessCount;

    @Override
    public boolean isMemory() {
        return this.isMemory;
    }

    @Override
    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public final boolean isInvariable() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return true;
    }

    @Override
    public long getPos() {
        return this.position;
    }

    @Override
    public void setPos(long pos) {
        this.position = pos;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public final void setChanged(boolean flag) {
        this.hasChanged = flag;
    }

    @Override
    public boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        if (!this.isInMemory) {
            return false;
        }
        if (keep) {
            ++this.keepCount;
        } else {
            if (this.keepCount == 0) {
                throw Error.runtimeError(201, "CachedObjectBase - keep count");
            }
            --this.keepCount;
        }
        return true;
    }

    @Override
    public boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public void setInMemory(boolean in) {
        this.isInMemory = in;
    }

    public boolean equals(Object other) {
        return other instanceof CachedObjectBase && ((CachedObjectBase)other).position == this.position;
    }

    public int hashCode() {
        return (int)this.position;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }
}

