/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;

public class Crypto {
    final SecretKeySpec key;
    final Cipher outCipher;
    final Cipher inCipher;
    final Cipher inStreamCipher;
    final Cipher outStreamCipher;
    final IvParameterSpec ivSpec;

    public Crypto(String keyString, String ivString, String cipherName, String provider) {
        String keyAlgorithm = cipherName.contains("/") ? cipherName.substring(0, cipherName.indexOf("/")) : cipherName;
        try {
            byte[] encodedKey = StringConverter.hexStringToByteArray(keyString);
            if (ivString != null && !ivString.isEmpty()) {
                byte[] encodedIv = StringConverter.hexStringToByteArray(ivString);
                this.ivSpec = new IvParameterSpec(encodedIv);
            } else {
                this.ivSpec = null;
            }
            this.key = new SecretKeySpec(encodedKey, keyAlgorithm);
            Cipher cipher = this.outCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            if (this.ivSpec == null) {
                this.outCipher.init(1, this.key);
            } else {
                this.outCipher.init(1, (Key)this.key, this.ivSpec);
            }
            Cipher cipher2 = this.outStreamCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            if (this.ivSpec == null) {
                this.outStreamCipher.init(1, this.key);
            } else {
                this.outStreamCipher.init(1, (Key)this.key, this.ivSpec);
            }
            Cipher cipher3 = this.inCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            if (this.ivSpec == null) {
                this.inCipher.init(2, this.key);
            } else {
                this.inCipher.init(2, (Key)this.key, this.ivSpec);
            }
            Cipher cipher4 = this.inStreamCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            if (this.ivSpec == null) {
                this.inStreamCipher.init(2, this.key);
            } else {
                this.inStreamCipher.init(2, (Key)this.key, this.ivSpec);
            }
        }
        catch (NoSuchPaddingException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw Error.error(331, e);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchProviderException e) {
            throw Error.error(331, e);
        }
        catch (IOException e) {
            throw Error.error(331, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized InputStream getInputStream(InputStream in) {
        if (this.inCipher == null) {
            return in;
        }
        try {
            if (this.ivSpec == null) {
                this.inStreamCipher.init(2, this.key);
            } else {
                this.inStreamCipher.init(2, (Key)this.key, this.ivSpec);
            }
            return new CipherInputStream(in, this.inStreamCipher);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized OutputStream getOutputStream(OutputStream out) {
        if (this.outCipher == null) {
            return out;
        }
        try {
            if (this.ivSpec == null) {
                this.outStreamCipher.init(1, this.key);
            } else {
                this.outStreamCipher.init(1, (Key)this.key, this.ivSpec);
            }
            return new CipherOutputStream(out, this.outStreamCipher);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int decode(byte[] source, int sourceOffset, int length, byte[] dest, int destOffset) {
        if (this.inCipher == null) {
            return length;
        }
        try {
            if (this.ivSpec == null) {
                this.inCipher.init(2, this.key);
            } else {
                this.inCipher.init(2, (Key)this.key, this.ivSpec);
            }
            return this.inCipher.doFinal(source, sourceOffset, length, dest, destOffset);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (BadPaddingException e) {
            throw Error.error(331, e);
        }
        catch (IllegalBlockSizeException e) {
            throw Error.error(331, e);
        }
        catch (ShortBufferException e) {
            throw Error.error(331, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int encode(byte[] source, int sourceOffset, int length, byte[] dest, int destOffset) {
        if (this.outCipher == null) {
            return length;
        }
        try {
            if (this.ivSpec == null) {
                this.outCipher.init(1, this.key);
            } else {
                this.outCipher.init(1, (Key)this.key, this.ivSpec);
            }
            return this.outCipher.doFinal(source, sourceOffset, length, dest, destOffset);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (BadPaddingException e) {
            throw Error.error(331, e);
        }
        catch (IllegalBlockSizeException e) {
            throw Error.error(331, e);
        }
        catch (ShortBufferException e) {
            throw Error.error(331, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Error.error(331, e);
        }
    }

    public static byte[] getNewKey(String cipherName, String provider) {
        try {
            KeyGenerator generator = provider == null ? KeyGenerator.getInstance(cipherName) : KeyGenerator.getInstance(cipherName, provider);
            SecretKey key = generator.generateKey();
            byte[] raw = key.getEncoded();
            return raw;
        }
        catch (NoSuchAlgorithmException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchProviderException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int getEncodedSize(int size) {
        try {
            return this.outCipher.getOutputSize(size);
        }
        catch (IllegalStateException ex) {
            try {
                if (this.ivSpec == null) {
                    this.outCipher.init(1, this.key);
                } else {
                    this.outCipher.init(1, (Key)this.key, this.ivSpec);
                }
                return this.outCipher.getOutputSize(size);
            }
            catch (InvalidKeyException e) {
                throw Error.error(331, e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw Error.error(331, e);
            }
        }
    }
}

