/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DataSpaceManagerBlocks;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;

public class DataFileCache {
    protected FileAccess fa;
    public DataSpaceManager spaceManager;
    static final int initIOBufferSize = 4096;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected int dataFileSpace;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected long lostSpaceSize;
    protected long spaceManagerPosition;
    protected long fileStartFreePosition;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is251;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database db, String baseFileName) {
        this.initParams(db, baseFileName, false);
        this.cache = new Cache(this);
    }

    public DataFileCache(Database db, String baseFileName, boolean defrag) {
        this.initParams(db, baseFileName, true);
        this.cache = new Cache(this);
        try {
            this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "rw");
        }
        catch (Throwable t) {
            throw Error.error(452, t);
        }
        this.initNewFile();
        this.initBuffers();
        this.spaceManager = this.dataFileSpace > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
    }

    protected void initParams(Database database, String baseFileName, boolean defrag) {
        this.database = database;
        this.dataFileName = baseFileName + ".data";
        this.backupFileName = baseFileName + ".backup";
        this.fa = database.logger.getFileAccess();
        this.dataFileScale = database.logger.getDataFileScale();
        this.dataFileSpace = database.logger.getDataFileSpace();
        this.cachedRowPadding = this.dataFileScale;
        if (this.dataFileScale < 8) {
            this.cachedRowPadding = 8;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        this.maxCacheRows = database.logger.getCacheMaxRows();
        this.maxCacheBytes = database.logger.getCacheSize();
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)database.logger.getDataFileFactor();
        if (defrag) {
            this.dataFileName = this.dataFileName + ".new";
            this.backupFileName = this.backupFileName + ".new";
            this.maxCacheRows = 1024;
            this.maxCacheBytes = 0x400000L;
        }
    }

    public void open(boolean readonly) {
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean isNio = this.database.logger.propNioDataFile;
            int fileType = this.database.isFilesInJar() ? 2 : (isNio ? 1 : 0);
            if (readonly || this.database.isFilesInJar()) {
                this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, true, fileType);
                int flags = this.getFlags();
                if (BitMap.isSet(flags, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.initBuffers();
                this.spaceManager = new DataSpaceManagerSimple(this, true);
                return;
            }
            boolean preexists = this.fa.isStreamElement(this.dataFileName);
            boolean isIncremental = true;
            boolean isSaved = false;
            boolean doRestore = false;
            if (preexists) {
                this.dataFile = new RAFileSimple(this.database.logger, this.dataFileName, "r");
                long length = this.dataFile.length();
                boolean wrongVersion = false;
                if (length > 32L) {
                    int flags = this.getFlags();
                    isSaved = BitMap.isSet(flags, 2);
                    isIncremental = BitMap.isSet(flags, 1);
                    this.is251 = BitMap.isSet(flags, 6);
                    if (BitMap.isSet(flags, 5)) {
                        wrongVersion = true;
                    }
                } else {
                    preexists = false;
                }
                if (isSaved && this.is251) {
                    this.dataFile.seek(32L);
                    long timestamp = this.dataFile.readLong();
                    if (timestamp > this.database.logger.getFilesTimestamp()) {
                        doRestore = true;
                    }
                }
                this.dataFile.close();
                if (wrongVersion) {
                    throw Error.error(453);
                }
                if (!this.database.logger.propLargeData && length > this.maxDataFileSize / 8L * 7L) {
                    this.database.logger.propLargeData = true;
                    this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)this.database.logger.getDataFileFactor();
                }
                if (length > this.maxDataFileSize) {
                    throw Error.error(468, String.valueOf(this.maxDataFileSize));
                }
            }
            if (preexists) {
                if (isSaved) {
                    boolean existsBackup = this.fa.isStreamElement(this.backupFileName);
                    if (existsBackup) {
                        this.logInfoEvent("data file was not modified but inc backup exists");
                        if (doRestore) {
                            this.restoreBackupIncremental();
                        }
                    }
                    this.deleteBackupFile();
                } else {
                    boolean restored = isIncremental ? this.restoreBackupIncremental() : this.restoreBackup();
                    if (!restored) {
                        this.database.logger.logSevereEvent("DataFileCache data file modified but no backup exists", null);
                        throw Error.error(454);
                    }
                }
            }
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType);
            if (preexists) {
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(20L);
                int spaceProps = this.dataFile.readInt();
                this.setSpaceProps(spaceProps);
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                int flags = this.getFlags();
                flags = BitMap.set(flags, 1);
                flags = BitMap.set(flags, 2);
                this.setFlags(flags);
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = this.dataFileSpace > 0 ? new DataSpaceManagerBlocks(this) : new DataSpaceManagerSimple(this, false);
            if (!preexists) {
                this.reset();
            }
            this.openShadowFile();
            this.logInfoEvent("dataFileCache open end");
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.open", t);
            this.release();
            throw Error.error(t, 452, 52, new String[]{t.toString(), this.dataFileName});
        }
    }

    void setSpaceProps(int spaceProps) {
        if (spaceProps == 0) {
            spaceProps = this.dataFileScale | this.dataFileSpace << 16;
            try {
                this.dataFile.seek(20L);
                this.dataFile.writeInt(spaceProps);
                this.dataFile.synch();
            }
            catch (Throwable t) {
                throw Error.error(452, t);
            }
            return;
        }
        this.dataFileScale = spaceProps & 0xFFFF;
        this.dataFileSpace = spaceProps >>> 16;
        this.database.logger.setDataFileScaleNoCheck(this.dataFileScale);
        this.database.logger.setDataFileSpace(this.dataFileSpace);
    }

    void initNewFile() {
        try {
            int initialFreePos = 8192;
            if (this.dataFileSpace == 0 && (initialFreePos = 64) < this.dataFileScale) {
                initialFreePos = this.dataFileScale;
            }
            this.fileFreePosition = initialFreePos;
            this.fileStartFreePosition = initialFreePos;
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int spaceProps = this.dataFileScale | this.dataFileSpace << 16;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(spaceProps);
            this.dataFile.seek(32L);
            this.dataFile.writeLong(this.database.logger.getFilesTimestamp());
            int flags = 0;
            flags = BitMap.set(flags, 1);
            flags = BitMap.set(flags, 2);
            flags = BitMap.set(flags, 4);
            flags = BitMap.set(flags, 6);
            this.setFlags(flags);
            this.is251 = true;
        }
        catch (Throwable t) {
            throw Error.error(452, t);
        }
    }

    private void openShadowFile() {
        this.shadowFile = new RAShadowFile(this.database.logger, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
    }

    private boolean restoreBackup() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            this.deleteBackupFile();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackup", t);
            throw Error.error(t, 452, 26, new String[]{t.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackupFile();
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackupIncremental", e);
            throw Error.error(452, e);
        }
    }

    public void release() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file closed");
            this.dataFile = null;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.release", t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() {
        this.writeLock.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            this.reset();
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close end");
            this.dataFile = null;
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.close", t);
            throw Error.error(t, 452, 53, new String[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void adjustStoreCount(int adjust) {
        this.writeLock.lock();
        try {
            this.storeCount += adjust;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reopen() {
        this.writeLock.lock();
        try {
            this.openShadowFile();
            this.spaceManager.initialiseSpaces();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reset() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.spaceManager.reset();
            this.cache.saveAll();
            long lostSize = this.spaceManager.getLostBlocksSize();
            this.dataFile.seek(4L);
            this.dataFile.writeLong(lostSize);
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int spaceProps = this.dataFileScale | this.dataFileSpace << 16;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(spaceProps);
            int pos = (int)(this.spaceManagerPosition / 4096L);
            this.dataFile.seek(24L);
            this.dataFile.writeInt(pos);
            if (this.is251) {
                this.dataFile.seek(32L);
                this.dataFile.writeLong(this.database.logger.getFilesTimestamp());
            }
            this.setFlag(2, true);
            this.logDetailEvent("file sync end");
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.logInfoEvent("dataFileCache commit end");
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.reset commit", t);
            throw Error.error(t, 452, 53, new String[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = new RowOutputBinaryEncode(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag(Session session) {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.database, this);
            dfd.process(session);
            DataFileDefrag dataFileDefrag = dfd;
            return dataFileDefrag;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(CachedObject object) {
        this.release(object.getPos());
    }

    public void removePersistence(CachedObject object) {
    }

    public void add(CachedObject object, boolean keep) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.put(object);
            if (keep) {
                object.keepInMemory(true);
            }
            if (object.getStorageSize() > 4096) {
                this.rowOut.reset(object.getStorageSize());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        long pos;
        this.readLock.lock();
        try {
            if (object.isInMemory()) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            pos = object.getPos();
            if (pos < 0L) {
                CachedObject cachedObject = null;
                return cachedObject;
            }
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long pos, int size, PersistentStore store, boolean keep) {
        if (pos < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, size, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long pos, PersistentStore store, boolean keep) {
        if (pos < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    private CachedObject getFromFile(long pos, PersistentStore store, boolean keep) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            for (int j = 0; j < 2; ++j) {
                try {
                    this.readObject(pos);
                    object = store.get(this.rowIn);
                    if (object == null) {
                        throw Error.error(467, "position " + pos);
                    }
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError) {
                        this.cache.clearUnchanged();
                        if (j <= 0) continue;
                        this.logInfoEvent(this.dataFileName + " getFromFile out of mem, pos: " + pos);
                        HsqlException ex = Error.error(460, t);
                        ex.info = this.rowIn;
                        throw ex;
                    }
                    if (t instanceof HsqlException) {
                        ((HsqlException)t).info = this.rowIn;
                        throw (HsqlException)t;
                    }
                    HsqlException ex = Error.error(467, t);
                    ex.info = this.rowIn;
                    throw ex;
                }
            }
            if (object == null) {
                throw Error.error(466);
            }
            this.cache.put(object);
            if (keep) {
                object.keepInMemory(true);
            }
            CachedObject j = object;
            return j;
        }
        catch (HsqlException e) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + pos, e);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CachedObject getFromFile(long pos, int size, PersistentStore store, boolean keep) {
        CachedObject object = null;
        this.writeLock.lock();
        try {
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            for (int j = 0; j < 2; ++j) {
                try {
                    this.readObject(pos, size);
                    object = store.get(this.rowIn);
                    break;
                }
                catch (OutOfMemoryError err) {
                    this.cache.clearUnchanged();
                    System.gc();
                    if (j <= 0) continue;
                    this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + pos, err);
                    throw err;
                }
            }
            if (object == null) {
                throw Error.error(466);
            }
            this.cache.putUsingReserve(object);
            if (keep) {
                object.keepInMemory(true);
            }
            CachedObject j = object;
            return j;
        }
        catch (HsqlException e) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + pos, e);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(long pos) {
        this.writeLock.lock();
        try {
            this.readObject(pos);
            RowInputInterface rowInputInterface = this.rowIn;
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void readObject(long pos) {
        try {
            this.dataFile.seek(pos * (long)this.dataFileScale);
            int size = this.dataFile.readInt();
            this.rowIn.resetRow(pos, size);
            this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.readObject", t, pos);
            HsqlException ex = Error.error(466, t);
            if (this.rowIn.getFilePosition() != pos) {
                this.rowIn.resetRow(pos, 0);
            }
            ex.info = this.rowIn;
            throw ex;
        }
    }

    protected void readObject(long pos, int size) {
        try {
            this.rowIn.resetBlock(pos, size);
            this.dataFile.seek(pos * (long)this.dataFileScale);
            this.dataFile.read(this.rowIn.getBuffer(), 0, size);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.readObject", t, pos);
            HsqlException ex = Error.error(466, t);
            ex.info = this.rowIn;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(long startPos, long limitPos) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(startPos, limitPos);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void releaseRange(IntIndex list, int fileBlockItemCount) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            this.cache.releaseRange(list, fileBlockItemCount);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(long pos) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            CachedObject cachedObject = this.cache.release(pos);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        if (count == 0) {
            return;
        }
        int pageCount = this.copyShadow(rows, offset, count);
        long startTime = this.cache.saveAllTimer.elapsedTime();
        long storageSize = 0L;
        this.cache.saveAllTimer.start();
        if (pageCount > 0) {
            this.setFileModified();
        }
        for (int i = offset; i < offset + count; ++i) {
            CachedObject r = rows[i];
            this.saveRowNoLock(r);
            rows[i] = null;
            storageSize += (long)r.getStorageSize();
        }
        this.cache.saveAllTimer.stop();
        this.cache.logSaveRowsEvent(count, storageSize, startTime);
    }

    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.copyShadow(row);
            this.setFileModified();
            this.saveRowNoLock(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveRowOutput(long pos) {
        try {
            this.dataFile.seek(pos * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.saveRowOutput", t, pos);
            throw Error.error(466, t);
        }
    }

    protected void saveRowNoLock(CachedObject row) {
        try {
            this.rowOut.reset();
            row.write(this.rowOut);
            this.dataFile.seek(row.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            row.setChanged(false);
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.saveRowNoLock", t, row.getPos());
            throw Error.error(466, t);
        }
    }

    protected int copyShadow(CachedObject[] rows, int offset, int count) {
        int pageCount = 0;
        if (this.shadowFile != null) {
            long time = this.cache.shadowTimer.elapsedTime();
            long seekpos = 0L;
            this.cache.shadowTimer.start();
            try {
                for (int i = offset; i < offset + count; ++i) {
                    CachedObject row = rows[i];
                    seekpos = row.getPos() * (long)this.dataFileScale;
                    pageCount += this.shadowFile.copy(seekpos, row.getStorageSize());
                }
                if (pageCount > 0) {
                    this.shadowFile.synch();
                }
            }
            catch (Throwable t) {
                this.logSevereEvent("DataFileCache.copyShadow", t, seekpos);
                throw Error.error(466, t);
            }
            this.cache.shadowTimer.stop();
            if (pageCount > 0) {
                time = this.cache.shadowTimer.elapsedTime() - time;
                this.logDetailEvent("copyShadow [size, time] " + this.shadowFile.getSavedLength() + " " + time);
            }
        }
        return pageCount;
    }

    protected int copyShadow(CachedObject row) {
        if (this.shadowFile != null) {
            long seekpos = row.getPos() * (long)this.dataFileScale;
            try {
                int pageCount = this.shadowFile.copy(seekpos, row.getStorageSize());
                this.shadowFile.synch();
                return pageCount;
            }
            catch (Throwable t) {
                this.logSevereEvent("DataFileCache.copyShadow", t, row.getPos());
                throw Error.error(466, t);
            }
        }
        return 0;
    }

    void deleteDataFile() {
        Log.deleteFile(this.fa, this.dataFileName);
    }

    private void deleteBackupFile() {
        Log.deleteFile(this.fa, this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long enlargeFileSpace(long newLength) {
        this.writeLock.lock();
        try {
            long position = this.fileFreePosition;
            if (newLength > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum allowed size: " + this.dataFileName + " " + this.maxDataFileSize, null);
                throw Error.error(468);
            }
            boolean result = this.dataFile.ensureLength(newLength);
            if (!result) {
                this.logSevereEvent("data file cannot be enlarged - disk space: " + this.dataFileName + " " + newLength, null);
                throw Error.error(468);
            }
            this.fileFreePosition = newLength;
            long l = position;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public long getLostBlockSize() {
        return this.spaceManager.getLostBlocksSize();
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public int getDataFileScale() {
        return this.dataFileScale;
    }

    public int getDataFileSpace() {
        return this.dataFileSpace;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    protected void setFileModified() {
        try {
            if (!this.fileModified) {
                this.setFlag(2, false);
                this.logDetailEvent("setFileModified flag set ");
                this.fileModified = true;
            }
        }
        catch (Throwable t) {
            this.logSevereEvent("DataFileCache.setFileModified", t);
            throw Error.error(466, t);
        }
    }

    int getFlags() throws IOException {
        this.dataFile.seek(28L);
        int flags = this.dataFile.readInt();
        return flags;
    }

    void setFlags(int flags) throws IOException {
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
        this.dataFile.synch();
    }

    void setFlag(int singleFlag, boolean val) throws IOException {
        this.dataFile.seek(28L);
        int flags = this.dataFile.readInt();
        flags = val ? BitMap.set(flags, singleFlag) : BitMap.unset(flags, singleFlag);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
        this.dataFile.synch();
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    public AtomicInteger getAccessCount() {
        return this.cache.getAccessCount();
    }

    private void logSevereEvent(String message, Throwable t, long position) {
        if (this.logEvents) {
            StringBuilder sb = new StringBuilder(message);
            sb.append(' ').append(position);
            message = sb.toString();
            this.database.logger.logSevereEvent(message, t);
        }
    }

    public void logSevereEvent(String message, Throwable t) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(message, t);
        }
    }

    void logInfoEvent(String message) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(message);
        }
    }

    void logDetailEvent(String message) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(message);
        }
    }

    static interface Positions {
        public static final int LONG_EMPTY_SIZE = 4;
        public static final int LONG_FREE_POS = 12;
        public static final int INT_SPACE_PROPS = 20;
        public static final int INT_SPACE_LIST_POS = 24;
        public static final int INT_FLAGS = 28;
        public static final int LONG_TIMESTAMP = 32;
        public static final int MIN_INITIAL_FREE_POS = 64;
        public static final int MAX_INITIAL_FREE_POS = 8192;
    }

    static interface Flags {
        public static final int FLAG_ISSHADOWED = 1;
        public static final int FLAG_ISSAVED = 2;
        public static final int FLAG_ROWINFO = 3;
        public static final int FLAG_200 = 4;
        public static final int FLAG_HX = 5;
        public static final int FLAG_251 = 6;
    }
}

