/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.RAFile;

public class DataFileCacheSession
extends DataFileCache {
    public DataFileCacheSession(Database db, String baseFileName) {
        super(db, baseFileName);
        this.logEvents = false;
    }

    @Override
    protected void initParams(Database database, String baseFileName, boolean defrag) {
        this.dataFileName = baseFileName + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.cachedRowPadding = this.dataFileScale = 64;
        this.maxCacheRows = 2048;
        this.maxCacheBytes = (long)this.maxCacheRows * 1024L;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale;
    }

    @Override
    public void open(boolean readonly) {
        try {
            this.dataFile = new RAFile(this.database.logger, this.dataFileName, false, false, false);
            this.fileFreePosition = this.dataFileScale;
            this.initBuffers();
            this.spaceManager = new DataSpaceManagerSimple(this, false);
        }
        catch (Throwable t) {
            this.database.logger.logWarningEvent("Failed to open Session RA file", t);
            this.release();
            throw Error.error(t, 452, 52, new String[]{t.toString(), this.dataFileName});
        }
    }

    @Override
    protected void setFileModified() {
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            this.clear();
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.deleteDataFile();
            }
        }
        catch (Throwable t) {
            this.database.logger.logWarningEvent("Failed to close Session RA file", t);
            throw Error.error(t, 452, 53, new String[]{t.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void adjustStoreCount(int adjust) {
        this.writeLock.lock();
        try {
            this.storeCount += adjust;
            if (this.storeCount == 0) {
                this.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.fileStartFreePosition = this.fileFreePosition = (long)this.dataFileScale;
        this.initBuffers();
    }
}

