/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.RowStoreAVLDisk;

final class DataFileDefrag {
    DataFileCache dataFileOut;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    Database database;
    DataFileCache dataCache;
    LongLookup pointerLookup;

    DataFileDefrag(Database db, DataFileCache cache) {
        this.database = db;
        this.dataCache = cache;
        this.dataFileName = cache.getFileName();
    }

    void process(Session session) {
        Throwable error = null;
        this.database.logger.logDetailEvent("Defrag process begins");
        HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[allTables.size()][];
        long maxSize = 0L;
        int tSize = allTables.size();
        for (int i = 0; i < tSize; ++i) {
            Table table = (Table)allTables.get(i);
            if (table.getTableType() != 5) continue;
            RowStoreAVLDisk store = (RowStoreAVLDisk)this.database.persistentStoreCollection.getStore(table);
            long size = store.elementCount();
            if (size > maxSize) {
                maxSize = size;
            }
            if (!this.dataCache.spaceManager.isMultiSpace() || !store.getSpaceManager().isDefaultSpace() || store.getStorageSizeEstimate() <= (long)(this.dataCache.spaceManager.getFileBlockSize() / 2)) continue;
            int spaceId = this.dataCache.spaceManager.getNewTableSpaceID();
            table.setSpaceID(spaceId);
        }
        if (maxSize > Integer.MAX_VALUE) {
            throw Error.error(3426);
        }
        try {
            String baseFileName = this.database.getCanonicalPath();
            this.dataFileOut = new DataFileCache(this.database, baseFileName, true);
            this.pointerLookup = this.dataCache.fileFreePosition < Integer.MAX_VALUE * (long)this.dataCache.dataFileScale ? new DoubleIntIndex((int)maxSize) : new DoubleLongIndex((int)maxSize);
            int tSize2 = allTables.size();
            for (int i = 0; i < tSize2; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 5) {
                    long[] rootsArray = this.writeTableToDataFile(session, t);
                    this.rootsList[i] = rootsArray;
                    continue;
                }
                this.rootsList[i] = null;
            }
            this.dataFileOut.close();
            this.dataFileOut = null;
            for (long[] roots : this.rootsList) {
                if (roots == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList(roots, ",", ""));
            }
        }
        catch (OutOfMemoryError e) {
            error = e;
            throw Error.error(460, e);
        }
        catch (Throwable t) {
            error = t;
            throw Error.error(458, t);
        }
        finally {
            try {
                if (this.dataFileOut != null) {
                    this.dataFileOut.release();
                }
            }
            catch (Throwable throwable) {}
            if (error instanceof OutOfMemoryError) {
                this.database.logger.logInfoEvent("defrag failed - out of memory - required: " + maxSize * 8L);
            }
            if (error == null) {
                this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
            } else {
                this.database.logger.logSevereEvent("defrag failed ", error);
                if (this.dataFileOut != null) {
                    this.dataFileOut.deleteDataFile();
                }
            }
        }
    }

    long[] writeTableToDataFile(Session session, Table table) {
        RowStoreAVLDisk store = (RowStoreAVLDisk)table.database.persistentStoreCollection.getStore(table);
        long[] rootsArray = table.getIndexRootsArray();
        this.pointerLookup.clear();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().statementName + " " + this.stopw.elapsedTime());
        store.moveDataToSpace(this.dataFileOut, this.pointerLookup);
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (rootsArray[i] == -1L) continue;
            long pos = this.pointerLookup.lookup(rootsArray[i], -1L);
            if (pos == -1L) {
                throw Error.error(466);
            }
            rootsArray[i] = pos;
        }
        long count = store.elementCount();
        if (count != (long)this.pointerLookup.size()) {
            this.database.logger.logSevereEvent("discrepency in row count " + table.getName().name + " " + count + " " + this.pointerLookup.size(), null);
        }
        this.database.logger.logDetailEvent("table written " + table.getName().statementName);
        return rootsArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }
}

