/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.DoubleIntArrayCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManagerBlocks defaultSpaceManager;
    final TableSpaceManagerBlocks directorySpaceManager;
    final IntKeyHashMap spaceManagerList;
    final BlockObjectStore rootStore;
    final BlockObjectStore directoryStore;
    final BlockObjectStore bitMapStore;
    final BlockObjectStore lastBlockStore;
    IntArrayCachedObject rootBlock;
    DoubleIntArrayCachedObject lastBlocks;
    final AtomicInteger spaceIdSequence = new AtomicInteger(8);
    final IntIndex emptySpaceList;
    int released = 0;
    public static final int lastBlockListSize = 1024;
    public static final int dirBlockSize = 2048;
    public static final int fileBlockItemCountLimit = 65536;
    final int bitmapIntSize;
    final int bitmapStorageSize;
    final int fileBlockItemCount;
    final int fileBlockSize;
    final int dataFileScale;
    BlockAccessor ba;

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.cache.getDataFileSpace() * 1024 * 1024;
        this.fileBlockItemCount = this.fileBlockSize / this.dataFileScale;
        this.bitmapIntSize = this.fileBlockItemCount / 32;
        int bitmapStoreSizeTemp = 4 * this.bitmapIntSize;
        if (bitmapStoreSizeTemp < 4096) {
            bitmapStoreSizeTemp = 4096;
        }
        this.bitmapStorageSize = bitmapStoreSizeTemp;
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.emptySpaceList = new IntIndex(32, false);
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = this.getRootStore();
        this.directoryStore = this.getDirectoryStore();
        this.bitMapStore = this.getBitMapStore();
        this.lastBlockStore = this.getLastBlockStore();
        if (this.cache.spaceManagerPosition == 0L) {
            this.initialiseNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
        } else {
            long position = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(position, true);
            if (this.getBlockIndexLimit() == 0) {
                throw Error.error(452);
            }
            if (this.cache.isDataReadOnly()) {
                return;
            }
            this.initialiseSpaceList();
            int blockPos = this.rootBlock.getValue(2047);
            if (blockPos == 0) {
                this.lastBlocks = new DoubleIntArrayCachedObject(1024);
                this.initialiseTableSpace(this.directorySpaceManager);
                this.lastBlockStore.add(this.lastBlocks, true);
                blockPos = this.getFileBlockPosFromPosition(this.lastBlocks.getPos());
                this.rootBlock.setValue(2047, blockPos);
            } else {
                position = this.getPositionFromFileBlock(blockPos);
                this.lastBlocks = (DoubleIntArrayCachedObject)this.lastBlockStore.get(position, true);
                this.initialiseTableSpace(this.directorySpaceManager);
            }
        }
    }

    BlockObjectStore getRootStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 8192, 2048);
    }

    BlockObjectStore getDirectoryStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 24576, 2048);
    }

    BlockObjectStore getBitMapStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, this.bitmapStorageSize, this.bitmapIntSize);
    }

    BlockObjectStore getLastBlockStore() {
        return new BlockObjectStore(this.cache, this.directorySpaceManager, DoubleIntArrayCachedObject.class, 8192, 1024);
    }

    private void initialiseNewSpaceDirectory() {
        long filePosition = 8192L;
        int dirSpaceBlockCount = 1;
        this.cache.enlargeFileSpace(this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, filePosition, this.fileBlockSize);
        this.rootBlock = new IntArrayCachedObject(2048);
        this.rootStore.add(this.rootBlock, true);
        this.lastBlocks = new DoubleIntArrayCachedObject(1024);
        this.lastBlockStore.add(this.lastBlocks, true);
        int blockPos = this.getFileBlockPosFromPosition(this.lastBlocks.getPos());
        this.rootBlock.setValue(2047, blockPos);
        this.createFileBlocksInDirectory(0, dirSpaceBlockCount, 1);
    }

    private void ensureDirectorySpaceAvailable(int blockCount) {
        long dirObjectSize = (long)this.bitmapStorageSize * (long)blockCount;
        boolean hasRoom = this.directorySpaceManager.hasFileRoom(dirObjectSize += 24576L);
        if (!hasRoom) {
            int index = this.getBlockIndexLimit();
            long filePosition = (long)index * (long)this.fileBlockSize;
            long dirSpaceBlockCount = dirObjectSize / (long)this.fileBlockSize + 1L;
            long delta = dirSpaceBlockCount * (long)this.fileBlockSize;
            this.cache.enlargeFileSpace(filePosition + delta);
            this.directorySpaceManager.addFileBlock(filePosition, filePosition + delta);
            this.createFileBlocksInDirectory(index, (int)dirSpaceBlockCount, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int tableId, int blockCount) {
        this.cache.writeLock.lock();
        try {
            long index = this.getExistingBlockIndex(tableId, blockCount);
            if (index > 0L) {
                long l = index * (long)this.fileBlockSize;
                return l;
            }
            long l = this.getNewFileBlocks(tableId, blockCount);
            return l;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int tableId, int blockCount) {
        this.ensureDirectorySpaceAvailable(blockCount);
        return this.getNewFileBlocksNoCheck(tableId, blockCount);
    }

    private long getNewFileBlocksNoCheck(int tableId, int blockCount) {
        int index = this.getBlockIndexLimit();
        long filePosition = (long)index * (long)this.fileBlockSize;
        long delta = (long)blockCount * (long)this.fileBlockSize;
        this.cache.enlargeFileSpace(filePosition + delta);
        this.createFileBlocksInDirectory(index, blockCount, tableId);
        return filePosition;
    }

    private void createFileBlocksInDirectory(int fileBlockIndex, int blockCount, int tableId) {
        for (int i = 0; i < blockCount; ++i) {
            this.createFileBlockInDirectory(fileBlockIndex + i, tableId);
        }
    }

    private void createFileBlockInDirectory(int fileBlockIndex, int tableId) {
        BitMapCachedObject bitMap = new BitMapCachedObject(this.bitmapIntSize);
        this.bitMapStore.add(bitMap, false);
        int bitmapBlockPos = this.getFileBlockPosFromPosition(bitMap.getPos());
        int blockOffset = fileBlockIndex % 2048;
        DirectoryBlockCachedObject directory = this.getDirectory(fileBlockIndex, true);
        if (directory == null) {
            this.createDirectory(fileBlockIndex);
            directory = this.getDirectory(fileBlockIndex, true);
        }
        directory.setTableId(blockOffset, tableId);
        directory.setBitmapAddress(blockOffset, bitmapBlockPos);
        directory.keepInMemory(false);
    }

    private DirectoryBlockCachedObject getDirectory(int fileBlockIndex, boolean keep) {
        int indexInRoot = fileBlockIndex / 2048;
        return this.getDirectoryByIndex(indexInRoot, keep);
    }

    private DirectoryBlockCachedObject getDirectoryByIndex(int indexInRoot, boolean keep) {
        int blockPos = this.rootBlock.getValue(indexInRoot);
        long position = this.getPositionFromFileBlock(blockPos);
        if (position == 0L) {
            return null;
        }
        return (DirectoryBlockCachedObject)this.directoryStore.get(position, keep);
    }

    private void createDirectory(int fileBlockIndex) {
        DirectoryBlockCachedObject directory = new DirectoryBlockCachedObject(2048);
        this.directoryStore.add(directory, false);
        int indexInRoot = fileBlockIndex / 2048;
        int blockPosition = this.getFileBlockPosFromPosition(directory.getPos());
        this.rootBlock.setValue(indexInRoot, blockPosition);
    }

    private int getBlockIndexLimit() {
        int indexInRoot = this.rootBlock.getNonZeroSize();
        if (indexInRoot == 0) {
            return 0;
        }
        int directoryBlockOffset = this.getDirectoryIndexLimit(--indexInRoot);
        return indexInRoot * 2048 + directoryBlockOffset;
    }

    private int getDirectoryIndexLimit(int indexInRoot) {
        int index;
        DirectoryBlockCachedObject directory = this.getDirectoryByIndex(indexInRoot, false);
        int[] bitmapArray = directory.getBitmapAddressArray();
        for (index = 0; index < bitmapArray.length && bitmapArray[index] != 0; ++index) {
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSpaceList() {
        int maxId = 7;
        OrderedIntHashSet list = new OrderedIntHashSet();
        this.ba.initialise(false);
        try {
            boolean result;
            while (result = this.ba.nextBlock()) {
                int currentId = this.ba.getTableId();
                if (currentId > maxId) {
                    maxId = currentId;
                }
                if (currentId != 0) continue;
                char freeItems = this.ba.getFreeSpaceValue();
                char freeItemsEnd = this.ba.getFreeBlockValue();
                if (freeItems == '\u0000' && freeItemsEnd == '\u0000') {
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                    continue;
                }
                list.add(this.ba.currentBlockIndex);
            }
        }
        finally {
            this.ba.reset();
        }
        this.spaceIdSequence.set(maxId + 2 & 0xFFFFFFFE);
        if (list.size() > 0) {
            this.setAsideBlocks(list);
            String s = "space manager error - recovered (freeItems in empty blocks) : (" + list.size() + ")";
            this.cache.logSevereEvent(s, null);
        }
    }

    private int getExistingBlockIndex(int tableId, int blockCount) {
        int blockIndex = this.emptySpaceList.removeFirstConsecutiveKeys(blockCount, -1);
        if (blockIndex > 0) {
            this.setDirectoryBlocksAsTable(tableId, blockIndex, blockCount);
        }
        return blockIndex;
    }

    private void setDirectoryBlocksAsTable(int tableId, int blockIndex, int blockCount) {
        int directoryIndex = -1;
        CachedObjectBase directory = null;
        for (int i = blockIndex; i < blockIndex + blockCount; ++i) {
            if (directoryIndex != i / 2048) {
                if (directory != null) {
                    directory.keepInMemory(false);
                }
                directory = this.getDirectory(i, true);
                directoryIndex = i / 2048;
            }
            int offset = i % 2048;
            ((DirectoryBlockCachedObject)directory).setTableId(offset, tableId);
        }
        directory.keepInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSpaceManager getTableSpace(int spaceId) {
        if (spaceId == 7) {
            return this.defaultSpaceManager;
        }
        if (spaceId >= this.spaceIdSequence.get()) {
            this.spaceIdSequence.set(spaceId + 2 & 0xFFFFFFFE);
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManagerBlocks manager = (TableSpaceManagerBlocks)this.spaceManagerList.get(spaceId);
            if (manager == null) {
                manager = new TableSpaceManagerBlocks(this, spaceId, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale);
                this.spaceManagerList.put(spaceId, manager);
            }
            TableSpaceManagerBlocks tableSpaceManagerBlocks = manager;
            return tableSpaceManagerBlocks;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId) {
        if (spaceId == 7 || spaceId == 1) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManager tableSpace = (TableSpaceManager)this.spaceManagerList.get(spaceId);
            if (tableSpace != null) {
                tableSpace.reset();
            }
            this.lastBlocks.removeKey(spaceId);
            IntIndex list = new IntIndex(16, false);
            this.ba.initialise(true);
            try {
                while (this.ba.nextBlockForTable(spaceId)) {
                    list.addUnsorted(this.ba.currentBlockIndex);
                    this.ba.setTable(0);
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                }
            }
            finally {
                this.ba.reset();
            }
            this.cache.releaseRange(list, this.fileBlockItemCount);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId, LongLookup spaceList, long offset, long limit) {
        if (spaceList.size() == 0 && offset == limit) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                int units;
                long position;
                for (int i = 0; i < spaceList.size(); ++i) {
                    position = spaceList.getLongKey(i);
                    units = (int)spaceList.getLongValue(i);
                    this.freeTableSpacePart(position, units);
                }
                position = offset / (long)this.dataFileScale;
                units = (int)((limit - offset) / (long)this.dataFileScale);
                this.freeTableSpacePart(position, units);
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private void freeTableSpacePart(long position, int units) {
        while (units > 0) {
            boolean result;
            int blockIndex = (int)(position / (long)this.fileBlockItemCount);
            int offset = (int)(position % (long)this.fileBlockItemCount);
            int currentUnits = this.fileBlockItemCount - offset;
            if (currentUnits > units) {
                currentUnits = units;
            }
            if (result = this.ba.moveToBlock(blockIndex)) {
                int setCount = this.ba.setRange(offset, currentUnits);
                if (setCount != currentUnits) {
                    this.ba.unsetRange(offset, currentUnits);
                    String s = "space manager error - recovered (block, offset, units) : (" + blockIndex + "," + offset + "," + units + ")";
                    this.cache.logSevereEvent(s, null);
                }
            } else {
                String s = "space manager error - recovered (block, offset, units) : (" + blockIndex + "," + offset + "," + units + ")";
                this.cache.logSevereEvent(s, null);
            }
            units -= currentUnits;
            position += (long)currentUnits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findTableSpace(long position) {
        int blockIndex = (int)(position / (long)this.fileBlockItemCount);
        this.cache.writeLock.lock();
        try {
            int id;
            block8: {
                this.ba.initialise(false);
                try {
                    boolean result = this.ba.moveToBlock(blockIndex);
                    if (result) break block8;
                    int n = -1;
                    this.ba.reset();
                    return n;
                }
                catch (Throwable throwable) {
                    this.ba.reset();
                    throw throwable;
                }
            }
            int n = id = this.ba.getTableId();
            this.ba.reset();
            return n;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsideBlocks(OrderedIntHashSet blocks) {
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                for (int i = 0; i < blocks.size(); ++i) {
                    int block = blocks.get(i);
                    boolean result = this.ba.moveToBlock(block);
                    if (!result) continue;
                    this.ba.setTable(6);
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLostBlocksSize() {
        long fragment = 0L;
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(false);
            try {
                boolean result;
                while (result = this.ba.nextBlock()) {
                    if (this.ba.getTableId() == 1) continue;
                    fragment += (long)this.ba.getFreeSpaceValue() * (long)this.dataFileScale;
                    if (this.ba.getTableId() != 0) continue;
                    fragment += (long)this.fileBlockSize;
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
        return fragment;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        this.cache.writeLock.lock();
        try {
            Iterator it = this.spaceManagerList.values().iterator();
            while (it.hasNext()) {
                TableSpaceManagerBlocks tableSpace = (TableSpaceManagerBlocks)it.next();
                if (tableSpace.getSpaceID() != 1 && tableSpace.getFileBlockIndex() == -1) continue;
                this.initialiseTableSpace(tableSpace);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.cache.writeLock.lock();
        try {
            Iterator it = this.spaceManagerList.values().iterator();
            while (it.hasNext()) {
                TableSpaceManagerBlocks tableSpace = (TableSpaceManagerBlocks)it.next();
                tableSpace.reset();
                int lastBlockIndex = tableSpace.getFileBlockIndex();
                if (lastBlockIndex < 0) continue;
                int spaceId = tableSpace.getSpaceID();
                this.lastBlocks.addKey(spaceId, lastBlockIndex);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    @Override
    public int getFileBlockItemCount() {
        return this.fileBlockItemCount;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        int count = this.rootBlock.getNonZeroSize();
        DirectoryBlockCachedObject[] directoryList = new DirectoryBlockCachedObject[count];
        for (int i = 0; i < directoryList.length; ++i) {
            directoryList[i] = this.getDirectoryByIndex(i, false);
        }
        return directoryList;
    }

    DoubleIntIndex checkDirectorySpaces() {
        DirectoryBlockCachedObject[] directoryList = this.getDirectoryList();
        DoubleIntIndex offspaceBitmaps = new DoubleIntIndex(8);
        DoubleIntIndex positionBitmaps = new DoubleIntIndex(8);
        for (int i = 0; i < directoryList.length; ++i) {
            boolean result;
            DirectoryBlockCachedObject dir = directoryList[i];
            long position = dir.getPos();
            int spaceId = this.findTableSpace(position);
            int blockIndex = i;
            int blockPos = this.rootBlock.getValue(blockIndex);
            int count = dir.getStorageSize() / 4096;
            for (int j = 0; j < count; ++j) {
                result = positionBitmaps.addUnique(blockPos, blockIndex);
            }
            int[] bitMapAddress = dir.getBitmapAddressArray();
            for (int j = 0; j < bitMapAddress.length && (blockPos = dir.getBitmapAddress(j)) != 0; ++j) {
                position = this.getPositionFromFileBlock(blockPos);
                spaceId = this.findTableSpace(position);
                blockIndex = i * 2048 + j;
                if (spaceId != 1) {
                    offspaceBitmaps.add(blockIndex, spaceId);
                    continue;
                }
                result = positionBitmaps.addUnique(blockPos, blockIndex);
                if (result) continue;
                offspaceBitmaps.add(blockIndex, spaceId);
                int offset = positionBitmaps.findFirstEqualKeyIndex(blockPos);
                blockIndex = positionBitmaps.getValue(offset);
                offspaceBitmaps.add(blockIndex, spaceId);
            }
        }
        return offspaceBitmaps;
    }

    DoubleIntIndex checkDirectoryBitmaps(DirectoryBlockCachedObject mismatch) {
        DirectoryBlockCachedObject[] directoryList = this.getDirectoryList();
        DoubleIntIndex offspaceBitmaps = new DoubleIntIndex(8);
        int mismatchCount = 0;
        block0: for (int i = 0; i < directoryList.length; ++i) {
            int blockPos;
            DirectoryBlockCachedObject dir = directoryList[i];
            int[] bitMapAddress = dir.getBitmapAddressArray();
            for (int j = 0; j < bitMapAddress.length && (blockPos = dir.getBitmapAddress(j)) != 0; ++j) {
                long position = this.getPositionFromFileBlock(blockPos);
                int spaceId = this.findTableSpace(position);
                int blockIndex = i * 2048 + j;
                BitMapCachedObject currentBitMap = (BitMapCachedObject)this.bitMapStore.get(position, false);
                spaceId = dir.getTableId(j);
                int freeUnits = currentBitMap.bitMap.countSetBits();
                int freeBlockUnits = currentBitMap.bitMap.countSetBitsEnd();
                if (dir.getFreeSpace(j) == freeUnits && dir.getFreeBlock(j) == freeBlockUnits) continue;
                offspaceBitmaps.add(blockIndex, spaceId);
                mismatch.setTableId(mismatchCount, spaceId);
                mismatch.setFreeSpace(mismatchCount, (char)freeUnits);
                mismatch.setFreeBlock(mismatchCount, (char)freeBlockUnits);
                if (++mismatchCount == mismatch.getTableIdArray().length) continue block0;
            }
        }
        return offspaceBitmaps;
    }

    private int findLastFreeSpace(int spaceId) {
        return this.lastBlocks.getValue(spaceId, -1);
    }

    @Override
    public void initialiseTableSpace(TableSpaceManagerBlocks tableSpace) {
        long position;
        int id;
        int spaceId = tableSpace.getSpaceID();
        int lastBlockIndex = tableSpace.getFileBlockIndex();
        if (lastBlockIndex < 0) {
            lastBlockIndex = this.findLastFreeSpace(spaceId);
        }
        if (lastBlockIndex >= 0 && (id = this.findTableSpace(position = (long)lastBlockIndex * (long)this.fileBlockItemCount)) != spaceId) {
            lastBlockIndex = -1;
        }
        if (lastBlockIndex < 0) {
            lastBlockIndex = this.findLargestFreeSpace(spaceId);
        }
        if (lastBlockIndex < 0) {
            return;
        }
        if (this.hasFreeSpace(spaceId, lastBlockIndex)) {
            this.initialiseTableSpace(tableSpace, lastBlockIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFreeSpace(int spaceId, int blockIndex) {
        this.ba.initialise(false);
        try {
            boolean result = this.ba.moveToBlock(blockIndex);
            if (result && this.ba.getTableId() == spaceId && this.ba.getFreeBlockValue() > '\u0000') {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLargestFreeSpace(int spaceId) {
        char maxFree = '\u0000';
        int blockIndex = -1;
        this.ba.initialise(false);
        try {
            while (this.ba.nextBlockForTable(spaceId)) {
                char currentFree = this.ba.getFreeBlockValue();
                if (currentFree <= maxFree) continue;
                blockIndex = this.ba.currentBlockIndex;
                maxFree = currentFree;
            }
            int n = blockIndex;
            return n;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpace, int blockIndex) {
        this.ba.initialise(true);
        try {
            this.ba.moveToBlock(blockIndex);
            char freeItems = this.ba.getFreeBlockValue();
            long blockPos = (long)blockIndex * (long)this.fileBlockSize;
            int unsetCount = this.ba.unsetRange(this.fileBlockItemCount - freeItems, freeItems);
            if (unsetCount == freeItems) {
                tableSpace.initialiseFileBlock(null, blockPos + (long)this.fileBlockSize - (long)freeItems * (long)this.dataFileScale, blockPos + (long)this.fileBlockSize);
            } else {
                this.cache.logSevereEvent("space manager error - recovered", null);
            }
        }
        finally {
            this.ba.reset();
        }
    }

    long getPositionFromFileBlock(int fixedBlockPos) {
        return (long)fixedBlockPos * (long)(4096 / this.dataFileScale);
    }

    int getFileBlockPosFromPosition(long position) {
        return (int)(position / (long)(4096 / this.dataFileScale));
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean forUpdate) {
            this.currentKeep = forUpdate;
        }

        boolean nextBlock() {
            boolean result = this.moveToBlock(this.currentBlockIndex + 1);
            return result;
        }

        boolean nextBlockForTable(int tableId) {
            do {
                boolean result;
                if (result = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != tableId);
            return true;
        }

        boolean moveToBlock(int fileBlockIndex) {
            if (this.currentBlockIndex != fileBlockIndex) {
                this.endBlockUpdate();
                this.currentBitMap = null;
                if (this.currentDirIndex != fileBlockIndex / 2048) {
                    this.reset();
                    this.currentDirIndex = fileBlockIndex / 2048;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(fileBlockIndex, this.currentKeep);
                }
                if (this.currentDir == null) {
                    this.reset();
                    return false;
                }
                this.currentBlockIndex = fileBlockIndex;
                this.currentBlockOffset = fileBlockIndex % 2048;
                long position = this.currentDir.getBitmapAddress(this.currentBlockOffset);
                if (position == 0L) {
                    this.reset();
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(position *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), true);
                }
            }
            return true;
        }

        int setRange(int offset, int currentUnits) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.setRange(offset, currentUnits);
        }

        int unsetRange(int offset, int currentUnits) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.unsetRange(offset, currentUnits);
        }

        void reset() {
            this.endBlockUpdate();
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        private void endBlockUpdate() {
            if (this.currentBitMap == null) {
                return;
            }
            if (!this.currentBitMap.hasChanged()) {
                this.currentBitMap.keepInMemory(false);
                return;
            }
            int freeUnits = this.currentBitMap.bitMap.countSetBits();
            int freeBlockUnits = this.currentBitMap.bitMap.countSetBitsEnd();
            if (freeUnits == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                int currentId = this.currentDir.getTableIdArray()[this.currentBlockOffset];
                if (currentId != 6) {
                    this.setTable(0);
                    DataSpaceManagerBlocks.this.emptySpaceList.addUnique(this.currentBlockIndex);
                    ++DataSpaceManagerBlocks.this.released;
                }
                this.currentBitMap.keepInMemory(false);
                return;
            }
            this.currentBitMap.keepInMemory(false);
            this.currentDir.setFreeSpace(this.currentBlockOffset, (char)freeUnits);
            this.currentDir.setFreeBlock(this.currentBlockOffset, (char)freeBlockUnits);
        }

        void setTable(int tableId) {
            this.currentDir.setTableId(this.currentBlockOffset, tableId);
            this.currentDir.setFreeSpace(this.currentBlockOffset, '\u0000');
            this.currentDir.setFreeBlock(this.currentBlockOffset, '\u0000');
            this.currentBitMap.bitMap.reset();
            this.currentBitMap.setChanged(true);
        }

        int getTableId() {
            return this.currentDir.getTableId(this.currentBlockOffset);
        }

        char getFreeSpaceValue() {
            return this.currentDir.getFreeSpace(this.currentBlockOffset);
        }

        char getFreeBlockValue() {
            return this.currentDir.getFreeBlock(this.currentBlockOffset);
        }
    }
}

