/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;
import org.hsqldb.persist.TableSpaceManagerSimple;
import org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManager defaultSpaceManager;
    final int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    LongLookup lookup;

    DataSpaceManagerSimple(DataFileCache cache, boolean isReadOnly) {
        this.cache = cache;
        if (cache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(cache);
        } else if (cache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(cache);
        } else {
            int capacity = cache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, 4096, capacity, cache.getDataFileScale());
            if (!isReadOnly) {
                this.initialiseSpaces();
                cache.spaceManagerPosition = 0L;
            }
        }
        this.totalFragmentSize = cache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int spaceId) {
        if (spaceId >= this.spaceIdSequence) {
            this.spaceIdSequence = spaceId + 2;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        int id = this.spaceIdSequence;
        this.spaceIdSequence += 2;
        return id;
    }

    @Override
    public long getFileBlocks(int spaceId, int blockCount) {
        long filePosition = this.cache.getFileFreePos();
        this.cache.enlargeFileSpace(filePosition + (long)blockCount * 4096L);
        return filePosition;
    }

    @Override
    public void initialiseTableSpace(TableSpaceManagerBlocks tableSpace) {
    }

    @Override
    public void freeTableSpace(int spaceId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId, LongLookup spaceList, long offset, long limit) {
        this.totalFragmentSize += spaceList.getTotalValues() * (long)this.cache.getDataFileScale();
        if (this.cache.fileFreePosition == limit) {
            this.cache.writeLock.lock();
            try {
                this.cache.fileFreePosition = offset;
            }
            finally {
                this.cache.writeLock.unlock();
            }
        } else {
            this.totalFragmentSize += limit - offset;
        }
        if (spaceList.size() != 0) {
            this.lookup = spaceList.duplicate();
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return 0x100000 * this.cache.getDataFileScale() / 16;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long filePosition = this.cache.getFileFreePos();
        long totalBlocks = (filePosition + 4096L) / 4096L;
        long lastFreePosition = this.cache.enlargeFileSpace(totalBlocks * 4096L);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, lastFreePosition, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues() * (long)this.cache.getDataFileScale();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    @Override
    public int getFileBlockItemCount() {
        return 65536;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        return new DirectoryBlockCachedObject[0];
    }
}

