/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DoubleIntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 8;
    DoubleIntIndex table;

    public DoubleIntArrayCachedObject(int capacity) {
        this.table = new DoubleIntIndex(capacity, true);
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface in) {
        int i;
        this.position = in.getFilePosition();
        int capacity = this.table.capacity();
        int[] array = this.table.getKeys();
        int lastValueIndex = -1;
        for (i = 0; i < capacity; ++i) {
            array[i] = in.readInt();
            if (array[i] == 0) continue;
            lastValueIndex = i;
        }
        array = this.table.getValues();
        for (i = 0; i < capacity; ++i) {
            array[i] = in.readInt();
        }
        this.table.setSize(lastValueIndex + 1);
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.table.capacity();
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return this.table.capacity() * 8;
    }

    @Override
    public void write(RowOutputInterface out) {
        this.write(out, null);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        int i;
        int capacity = this.table.capacity();
        out.setStorageSize(this.storageSize);
        int[] array = this.table.getKeys();
        for (i = 0; i < capacity; ++i) {
            out.writeInt(array[i]);
        }
        array = this.table.getValues();
        for (i = 0; i < capacity; ++i) {
            out.writeInt(array[i]);
        }
        out.writeEnd();
    }

    public void clear() {
        this.hasChanged |= this.table.size() > 0;
        this.table.clear();
    }

    public boolean removeKey(int key) {
        boolean result = this.table.removeKey(key);
        this.hasChanged |= result;
        return result;
    }

    public boolean addKey(int key, int value) {
        boolean result = this.table.addOrReplaceUnique(key, value);
        this.hasChanged |= result;
        return result;
    }

    public int getValue(int key) {
        return this.table.lookup(key, -1);
    }

    public int getValue(int key, int def) {
        return this.table.lookup(key, def);
    }
}

