/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.map.ValuePool;

public class HsqlProperties {
    public static final int ANY_ERROR = 0;
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected String fileExtension = "";
    protected Properties stringProps;
    protected int[] errorCodes = ValuePool.emptyIntArray;
    protected String[] errorKeys = ValuePool.emptyStringArray;
    protected FileAccess fa;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String fileName) {
        this(fileName, ".properties");
    }

    public HsqlProperties(String fileName, String fileExtension) {
        this.stringProps = new Properties();
        this.fileName = fileName;
        this.fileExtension = fileExtension;
        this.fa = FileUtil.getFileUtil();
    }

    public HsqlProperties(String fileName, FileAccess accessor, boolean b) {
        this.stringProps = new Properties();
        this.fileName = fileName;
        this.fileExtension = ".properties";
        this.fa = accessor;
    }

    public HsqlProperties(Properties props) {
        this.stringProps = props;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String setProperty(String key, int value) {
        return this.setProperty(key, Integer.toString(value));
    }

    public String setProperty(String key, boolean value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public String setProperty(String key, String value) {
        return (String)this.stringProps.put(key, value);
    }

    public String setPropertyIfNotExists(String key, String value) {
        value = this.getProperty(key, value);
        return this.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String key) {
        return this.stringProps.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.stringProps.getProperty(key, defaultValue);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        return HsqlProperties.getIntegerProperty(this.stringProps, key, defaultValue);
    }

    public static int getIntegerProperty(Properties props, String key, int defaultValue) {
        String prop = props.getProperty(key);
        try {
            if (prop != null) {
                prop = prop.trim();
                defaultValue = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean isPropertyTrue(String key) {
        return this.isPropertyTrue(key, false);
    }

    public boolean isPropertyTrue(String key, boolean defaultValue) {
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        return value.toLowerCase().equals("true");
    }

    public void removeProperty(String key) {
        this.stringProps.remove(key);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            this.stringProps.put(key, value);
        }
    }

    public void addProperties(HsqlProperties props) {
        if (props == null) {
            return;
        }
        this.addProperties(props.stringProps);
    }

    public boolean propertiesFileExists() {
        if (this.fileName == null) {
            return false;
        }
        String propFilename = this.fileName + this.fileExtension;
        return this.fa.isStreamElement(propFilename);
    }

    public boolean load() throws Exception {
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        if (!this.propertiesFileExists()) {
            return false;
        }
        String propsFilename = this.fileName + this.fileExtension;
        try (InputStream fis = null;){
            fis = this.fa.openInputStreamElement(propsFilename);
            this.stringProps.load(fis);
        }
        return true;
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        String filestring = this.fileName + this.fileExtension;
        this.save(filestring);
    }

    public void save(String fileString) throws Exception {
        this.fa.createParentDirs(fileString);
        this.fa.removeElement(fileString);
        OutputStream fos = this.fa.openOutputStreamElement(fileString);
        FileAccess.FileSync outDescriptor = this.fa.getFileSync(fos);
        String name = "HSQL Database Engine 2.7.1";
        this.stringProps.store(fos, name);
        fos.flush();
        outDescriptor.sync();
        fos.close();
        outDescriptor = null;
        fos = null;
    }

    protected void addError(int code, String key) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = code;
        this.errorKeys[this.errorKeys.length - 1] = key;
    }

    public static HsqlProperties argArrayToProps(String[] arg, String type) {
        HsqlProperties props = new HsqlProperties();
        for (int i = 0; i < arg.length; ++i) {
            String value;
            String p = arg[i];
            if (p.equals("--help") || p.equals("-help")) {
                props.addError(1, p.substring(1));
                continue;
            }
            if (p.startsWith("--")) {
                value = i + 1 < arg.length ? arg[i + 1] : "";
                props.setProperty(type + "." + p.substring(2), value);
                ++i;
                continue;
            }
            if (p.charAt(0) != '-') continue;
            value = i + 1 < arg.length ? arg[i + 1] : "";
            props.setProperty(type + "." + p.substring(1), value);
            ++i;
        }
        return props;
    }

    public static HsqlProperties delimitedArgPairsToProps(String s, String pairsep, String dlimiter, String type) {
        HsqlProperties props = new HsqlProperties();
        int currentpair = 0;
        while (true) {
            int valindex;
            int nextpair;
            if ((nextpair = s.indexOf(dlimiter, currentpair)) == -1) {
                nextpair = s.length();
            }
            if ((valindex = s.substring(0, nextpair).indexOf(pairsep, currentpair)) == -1) {
                props.addError(1, s.substring(currentpair, nextpair).trim());
            } else {
                String key = s.substring(currentpair, valindex).trim();
                String value = s.substring(valindex + pairsep.length(), nextpair).trim();
                if (type != null) {
                    key = type + "." + key;
                }
                props.setProperty(key, value);
            }
            if (nextpair == s.length()) break;
            currentpair = nextpair + dlimiter.length();
        }
        return props;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }

    public void validate() {
    }

    public static PropertyMeta newMeta(String name, int type, long defaultVal) {
        PropertyMeta meta = new PropertyMeta();
        meta.propName = name;
        meta.propType = type;
        meta.propClass = "Long";
        meta.propDefaultValue = defaultVal;
        return meta;
    }

    public static PropertyMeta newMeta(String name, int type, String defaultValue) {
        PropertyMeta meta = new PropertyMeta();
        meta.propName = name;
        meta.propType = type;
        meta.propClass = "String";
        meta.propDefaultValue = defaultValue;
        return meta;
    }

    public static PropertyMeta newMeta(String name, int type, boolean defaultValue) {
        PropertyMeta meta = new PropertyMeta();
        meta.propName = name;
        meta.propType = type;
        meta.propClass = "Boolean";
        meta.propDefaultValue = defaultValue ? Boolean.TRUE : Boolean.FALSE;
        return meta;
    }

    public static PropertyMeta newMeta(String name, int type, int defaultValue, int[] values) {
        PropertyMeta meta = new PropertyMeta();
        meta.propName = name;
        meta.propType = type;
        meta.propClass = "Integer";
        meta.propDefaultValue = ValuePool.getInt(defaultValue);
        meta.propValues = values;
        return meta;
    }

    public static PropertyMeta newMeta(String name, int type, int defaultValue, int rangeLow, int rangeHigh) {
        PropertyMeta meta = new PropertyMeta();
        meta.propName = name;
        meta.propType = type;
        meta.propClass = "Integer";
        meta.propDefaultValue = ValuePool.getInt(defaultValue);
        meta.propIsRange = true;
        meta.propRangeLow = rangeLow;
        meta.propRangeHigh = rangeHigh;
        return meta;
    }

    public static String validateProperty(String key, String value, PropertyMeta meta) {
        if (meta.propClass.equals("Boolean")) {
            if ((value = value.toLowerCase()).equals("true") || value.equals("false")) {
                return null;
            }
            return "invalid boolean value for property: " + key;
        }
        if (meta.propClass.equals("String")) {
            return null;
        }
        if (meta.propClass.equals("Long")) {
            return null;
        }
        if (meta.propClass.equals("Integer")) {
            try {
                int[] values;
                int number = Integer.parseInt(value);
                if (meta.propIsRange) {
                    int low = meta.propRangeLow;
                    int high = meta.propRangeHigh;
                    if (number < low || high < number) {
                        return "value outside range for property: " + key;
                    }
                }
                if (meta.propValues != null && ArrayUtil.find(values = meta.propValues, number) == -1) {
                    return "value not supported for property: " + key;
                }
            }
            catch (NumberFormatException e) {
                return "invalid integer value for property: " + key;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int len = this.stringProps.size();
        Enumeration<?> en = this.stringProps.propertyNames();
        ArrayList<?> list = Collections.list(en);
        Collections.sort(list);
        for (int i = 0; i < len; ++i) {
            String key = (String)list.get(i);
            sb.append(key);
            sb.append('=');
            sb.append('\"');
            sb.append(this.stringProps.get(key));
            sb.append('\"');
            if (i + 1 >= len) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public static class PropertyMeta {
        public String propName;
        public int propType;
        public String propClass;
        public boolean propIsRange;
        public Object propDefaultValue;
        public int propRangeLow;
        public int propRangeHigh;
        public int[] propValues;
    }
}

