/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class IntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    int[] values;

    public IntArrayCachedObject(int capacity) {
        this.values = new int[capacity];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface in) {
        this.position = in.getFilePosition();
        int capacity = this.values.length;
        for (int i = 0; i < capacity; ++i) {
            this.values[i] = in.readInt();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.values.length;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return this.values.length * 4;
    }

    @Override
    public void write(RowOutputInterface out) {
        this.write(out, null);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        int capacity = this.values.length;
        out.setStorageSize(this.storageSize);
        for (int i = 0; i < capacity; ++i) {
            out.writeInt(this.values[i]);
        }
        out.writeEnd();
    }

    public int getNonZeroSize() {
        int i;
        for (i = 0; i < this.values.length && this.values[i] != 0; ++i) {
        }
        return i;
    }

    public void setValue(int position, int value) {
        this.values[position] = value;
        this.hasChanged = true;
    }

    public void setIntArray(int[] array) {
        this.values = array;
        this.hasChanged = true;
    }

    public int getValue(int position) {
        return this.values[position];
    }

    public int[] getIntArray() {
        return this.values;
    }
}

