/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    byte[] byteBuffer;
    Inflater inflater;
    Deflater deflater;
    byte[] dataBuffer;
    boolean cryptLobs;
    boolean compressLobs;
    int lobBlockSize;
    int largeLobBlockSize = 524288;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getSpanningBlocks;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement createSingleLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement mergeUnusedSpace;
    Statement getLobUseLimit;
    Statement getLobCount;
    Statement getSpanningParts;
    Statement getLastPart;
    Statement createPart;
    long usageChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static final String existsBlocksSQL = "SELECT * FROM SYSTEM_LOBS.BLOCKS LIMIT 1";
    private static final String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static final String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_IDS.LOB_ID = ?";
    private static final String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOBS.LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static final String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static final String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static final String createSingleLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_SINGLE_BLOCK(?, ?, ?)";
    private static final String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static final String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = LOB_USAGE_COUNT + ? WHERE LOB_IDS.LOB_ID = ?";
    private static final String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static final String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static final String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED_LOBS(?,?)";
    private static final String mergeUnusedSpaceSQL = "CALL SYSTEM_LOBS.MERGE_EMPTY_BLOCKS()";
    private static final String getLobUseLimitSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE BLOCK_ADDR = (SELECT MAX(BLOCK_ADDR) FROM SYSTEM_LOBS.LOBS)";
    private static final String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";
    private static final String getPartsSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ?  AND PART_OFFSET + PART_LENGTH > ? AND PART_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String getLastPartSQL = "SELECT BLOCK_COUNT, BLOCK_OFFSET, PART_OFFSET, PART_LENGTH, PART_BYTES, LOB_ID FROM SYSTEM_LOBS.PARTS WHERE LOB_ID = ? ORDER BY LOB_ID DESC, BLOCK_OFFSET DESC LIMIT 1";
    private static final String createPartSQL = "INSERT INTO SYSTEM_LOBS.PARTS VALUES ?,?,?,?,?,?";

    public LobManager(Database database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        OrderedHashMap map = LineGroupReader.getStatementMap(resourceFileName);
        String sql = (String)map.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(sql);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        this.compileStatements();
    }

    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getSpanningBlocks = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.createSingleLobPartCall = this.sysLobSession.compileStatement(createSingleLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.mergeUnusedSpace = this.sysLobSession.compileStatement(mergeUnusedSpaceSQL);
            this.getLobUseLimit = this.sysLobSession.compileStatement(getLobUseLimitSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
            this.getSpanningParts = this.sysLobSession.compileStatement(getPartsSQL);
            this.getLastPart = this.sysLobSession.compileStatement(getLastPartSQL);
            this.createPart = this.sysLobSession.compileStatement(createPartSQL);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(existsBlocksSQL);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        if (size > 0) {
            return;
        }
        statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] params = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, params, 0);
    }

    public void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        this.cryptLobs = this.database.logger.cryptLobs;
        this.compressLobs = this.database.logger.propCompressLobs;
        if (this.compressLobs || this.cryptLobs) {
            int largeBufferBlockSize = this.largeLobBlockSize + 32768;
            this.inflater = new Inflater();
            this.deflater = new Deflater(1);
            this.dataBuffer = new byte[largeBufferBlockSize];
        }
        switch (this.database.getType()) {
            case DB_FILE: {
                this.lobStore = new LobStoreRAFile(this.database, this.lobBlockSize);
                if (this.database.isFilesReadOnly()) break;
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
                break;
            }
            case DB_RES: {
                this.lobStore = new LobStoreInJar(this.database, this.lobBlockSize);
                break;
            }
            case DB_MEM: {
                this.lobStore = new LobStoreMem(this.lobBlockSize);
                this.byteBuffer = new byte[this.lobBlockSize];
                this.initialiseLobSpace();
            }
        }
    }

    public void close() {
        if (this.lobStore != null) {
            this.lobStore.close();
        }
        this.lobStore = null;
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private Long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.release();
            return 0L;
        }
        Object[] data = navigator.getCurrent();
        navigator.release();
        return (Long)data[0];
    }

    private Object[] getLobHeader(long lobID) {
        ResultMetaData meta = this.getLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            throw result.getException();
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        Object[] data = null;
        if (next) {
            data = navigator.getCurrent();
        }
        navigator.release();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                BlobData blobData = null;
                return blobData;
            }
            BlobDataID blobDataID = new BlobDataID(lobID);
            return blobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                ClobData clobData = null;
                return clobData;
            }
            ClobDataID clobDataID = new ClobDataID(lobID);
            return clobDataID;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(Session session, long length) {
        this.writeLock.lock();
        try {
            Long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = lobID;
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_0;
            params[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params, 0);
            long l = lobID;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(Session session, long length) {
        this.writeLock.lock();
        try {
            Long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = lobID;
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_0;
            params[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params, 0);
            long l = lobID;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long lobID) {
        this.writeLock.lock();
        try {
            ResultMetaData meta = this.deleteLobCall.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, params, 0);
            this.usageChanged += (long)this.lobBlockSize;
            Result result2 = result;
            return result2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getUsageChanged() {
        return this.usageChanged;
    }

    public void setUsageChanged() {
        this.usageChanged += (long)this.lobBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs() {
        this.writeLock.lock();
        try {
            long currentLength;
            if (this.lobStore == null || this.byteBuffer == null || this.usageChanged == 0L) {
                Result result = Result.updateZeroResult;
                return result;
            }
            long limitLobID = Long.MAX_VALUE;
            ResultMetaData meta = this.deleteUnusedLobs.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            int deleteCount = 0;
            params[0] = limitLobID;
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, params, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (params[1] != null && (deleteCount = ((Number)params[1]).intValue()) < 1) {
                Result result3 = Result.updateZeroResult;
                return result3;
            }
            result = this.sysLobSession.executeCompiledStatement(this.mergeUnusedSpace, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result4 = result;
                return result4;
            }
            result = this.sysLobSession.executeCompiledStatement(this.getLobUseLimit, ValuePool.emptyObjectArray, 0);
            if (result.isError()) {
                Result result5 = result;
                return result5;
            }
            this.usageChanged = 0L;
            long sizeLimit = 0L;
            RowSetNavigator navigator = result.getNavigator();
            boolean next = navigator.next();
            if (next) {
                Object[] data = navigator.getCurrent();
                if (data[0] == null || data[1] == null) {
                    Result result6 = Result.updateOneResult;
                    return result6;
                }
                sizeLimit = (Integer)data[0] + (Integer)data[1];
                sizeLimit *= (long)this.lobBlockSize;
            }
            if ((currentLength = this.lobStore.getLength()) > sizeLimit) {
                this.database.logger.logInfoEvent("lob file truncated to usage");
                this.lobStore.setLength(sizeLimit);
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {}
            } else if (currentLength < sizeLimit) {
                this.database.logger.logInfoEvent("lob file reported smaller than usage");
            }
            Result result7 = Result.newUpdateCountResult(deleteCount);
            return result7;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                throw Error.error(1852);
            }
            long length = (Long)data[1];
            int type = (Integer)data[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
            return resultLob;
        }
        catch (HsqlException e) {
            Result result = Result.newErrorResult(e);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(long lobId, byte[] b) {
        this.writeLock.lock();
        try {
            int n;
            Object[] data = this.getLobHeader(lobId);
            long aLength = (Long)data[1];
            int[][] aAddresses = this.getBlockAddresses(lobId, 0, Integer.MAX_VALUE);
            int aIndex = 0;
            int bOffset = 0;
            int aOffset = 0;
            if (aLength == 0L) {
                int n2 = b.length == 0 ? 0 : -1;
                return n2;
            }
            if (b.length == 0) {
                int n3 = 1;
                return n3;
            }
            do {
                int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                for (int i = 0; i < aBytes.length; ++i) {
                    if (bOffset + i >= b.length) {
                        if (aLength == (long)b.length) {
                            int n4 = 0;
                            return n4;
                        }
                        int n5 = 1;
                        return n5;
                    }
                    if (aBytes[i] == b[bOffset + i]) continue;
                    int n6 = (aBytes[i] & 0xFF) > (b[bOffset + i] & 0xFF) ? 1 : -1;
                    return n6;
                }
                bOffset += this.lobBlockSize;
                if (++aOffset != aAddresses[aIndex][1]) continue;
                aOffset = 0;
                ++aIndex;
            } while (aIndex != aAddresses.length && bOffset < b.length);
            if (aLength == (long)b.length) {
                n = 0;
                return n;
            }
            n = aLength > (long)b.length ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData a, BlobData b) {
        if (a.getId() == b.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n = this.compareBytesCompressed(a.getId(), b.getId());
                return n;
            }
            int n = this.compareBytesNormal(a.getId(), b.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, long lobId, String b) {
        this.writeLock.lock();
        try {
            int n;
            Object[] data = this.getLobHeader(lobId);
            long aLength = (Long)data[1];
            int[][] aAddresses = this.getBlockAddresses(lobId, 0, Integer.MAX_VALUE);
            int aIndex = 0;
            int bOffset = 0;
            int aOffset = 0;
            if (aLength == 0L) {
                int n2 = b.isEmpty() ? 0 : -1;
                return n2;
            }
            if (b.isEmpty()) {
                int n3 = 1;
                return n3;
            }
            do {
                String bString;
                int diff;
                int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                long aLimit = aLength - ((long)aAddresses[aIndex][2] + (long)aOffset) * (long)this.lobBlockSize / 2L;
                if (aLimit > (long)(this.lobBlockSize / 2)) {
                    aLimit = this.lobBlockSize / 2;
                }
                String aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit);
                int bLimit = b.length() - bOffset;
                if (bLimit > this.lobBlockSize / 2) {
                    bLimit = this.lobBlockSize / 2;
                }
                if ((diff = collation.compare(aString, bString = b.substring(bOffset, bOffset + bLimit))) != 0) {
                    int n4 = diff;
                    return n4;
                }
                bOffset += this.lobBlockSize / 2;
                if (++aOffset != aAddresses[aIndex][1]) continue;
                aOffset = 0;
                ++aIndex;
            } while (aIndex != aAddresses.length && bOffset < b.length());
            if (aLength == (long)b.length()) {
                n = 0;
                return n;
            }
            n = aLength > (long)b.length() ? 1 : -1;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(Collation collation, ClobData a, ClobData b) {
        if (a.getId() == b.getId()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                int n = this.compareTextCompressed(collation, a.getId(), b.getId());
                return n;
            }
            int n = this.compareTextNormal(collation, a.getId(), b.getId());
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int compareBytesNormal(long aID, long bID) {
        Object[] data = this.getLobHeader(aID);
        long aLength = (Long)data[1];
        data = this.getLobHeader(bID);
        long bLength = (Long)data[1];
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        if (aLength == 0L) {
            return bLength == 0L ? 0 : -1;
        }
        if (bLength == 0L) {
            return 1;
        }
        do {
            byte[] bBytes;
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            int result = ArrayUtil.compare(aBytes, bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1));
            if (result != 0) {
                return result;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length && bIndex != bAddresses.length);
        if (aLength == bLength) {
            return 0;
        }
        return aLength > bLength ? 1 : -1;
    }

    private int compareTextNormal(Collation collation, long aID, long bID) {
        Object[] data = this.getLobHeader(aID);
        long aLength = (Long)data[1];
        data = this.getLobHeader(bID);
        long bLength = (Long)data[1];
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        if (aLength == 0L) {
            return bLength == 0L ? 0 : -1;
        }
        if (bLength == 0L) {
            return 1;
        }
        do {
            String bString;
            String aString;
            int diff;
            long bLimit;
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            byte[] bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1);
            long aLimit = aLength - ((long)aAddresses[aIndex][2] + (long)aOffset) * (long)this.lobBlockSize / 2L;
            if (aLimit > (long)(this.lobBlockSize / 2)) {
                aLimit = this.lobBlockSize / 2;
            }
            if ((bLimit = bLength - ((long)bAddresses[bIndex][2] + (long)bOffset) * (long)this.lobBlockSize / 2L) > (long)(this.lobBlockSize / 2)) {
                bLimit = this.lobBlockSize / 2;
            }
            if ((diff = collation.compare(aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit), bString = new String(ArrayUtil.byteArrayToChars(bBytes), 0, (int)bLimit))) != 0) {
                return diff;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length && bIndex != bAddresses.length);
        if (aLength == bLength) {
            return 0;
        }
        return aLength > bLength ? 1 : -1;
    }

    public Result getLob(long lobID, long offset, long length) {
        if (offset == 0L) {
            return this.createDuplicateLob(lobID, length);
        }
        throw Error.runtimeError(201, "LobManager");
    }

    public Result createDuplicateLob(long lobID) {
        Result result = this.getLength(lobID);
        if (result.isError()) {
            return result;
        }
        return this.createDuplicateLob(lobID, ((ResultLob)result).getBlockLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result createDuplicateLob(long lobID, long newLength) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            Long newLobID = this.getNewLobID();
            Object[] params = new Object[data.length];
            params[0] = newLobID;
            params[1] = newLength;
            params[2] = ValuePool.INTEGER_0;
            params[3] = data[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params, 0);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (newLength == 0L) {
                ResultLob resultLob = ResultLob.newLobSetResponse(newLobID, newLength);
                return resultLob;
            }
            long byteLength = newLength;
            int lobType = (Integer)data[3];
            if (lobType == 40) {
                byteLength *= 2L;
            }
            int newBlockCount = (int)(byteLength / (long)this.lobBlockSize);
            if (byteLength % (long)this.lobBlockSize != 0L) {
                ++newBlockCount;
            }
            if ((result = this.createBlockAddresses(newLobID, 0, newBlockCount)).isError()) {
                Result result3 = result;
                return result3;
            }
            int[][] sourceBlocks = this.getBlockAddresses(lobID, 0, Integer.MAX_VALUE);
            int[][] targetBlocks = this.getBlockAddresses(newLobID, 0, Integer.MAX_VALUE);
            try {
                this.copyBlockSet(sourceBlocks, targetBlocks);
            }
            catch (HsqlException e) {
                Result result4 = Result.newErrorResult(e);
                this.writeLock.unlock();
                return result4;
            }
            catch (Throwable e) {
                Result result5 = Result.newErrorResult(e);
                this.writeLock.unlock();
                return result5;
            }
            int endOffset = (int)(byteLength % (long)this.lobBlockSize);
            if (endOffset != 0) {
                int[] block = targetBlocks[targetBlocks.length - 1];
                int blockOffset = block[0] + block[1] - 1;
                byte[] bytes = this.getLobStore().getBlockBytes(blockOffset, 1);
                ArrayUtil.fillArray(bytes, endOffset, (byte)0);
                this.getLobStore().setBlockBytes(bytes, blockOffset, 1);
            }
            this.lobStore.synch();
            ResultLob resultLob = ResultLob.newLobSetResponse(newLobID, newLength);
            return resultLob;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getTruncateLength(long lobID) {
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                throw Error.error(1852);
            }
            long length = (Long)data[1];
            int type = (Integer)data[3];
            ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void copyBlockSet(int[][] source, int[][] target) {
        int sourceIndex = 0;
        int targetIndex = 0;
        int sourceOffset = 0;
        int targetOffset = 0;
        do {
            byte[] bytes = this.getLobStore().getBlockBytes(source[sourceIndex][0] + sourceOffset, 1);
            this.getLobStore().setBlockBytes(bytes, target[targetIndex][0] + targetOffset, 1);
            ++targetOffset;
            if (++sourceOffset == source[sourceIndex][1]) {
                sourceOffset = 0;
                ++sourceIndex;
            }
            if (targetOffset != target[targetIndex][1]) continue;
            targetOffset = 0;
            ++targetIndex;
        } while (sourceIndex != source.length && targetIndex != target.length);
        this.storeModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getChars(long lobID, long offset, int length) {
        Result result;
        this.writeLock.lock();
        try {
            result = this.compressLobs || this.cryptLobs ? this.getBytesCompressed(lobID, offset * 2L, length * 2) : this.getBytesNormal(lobID, offset * 2L, length * 2);
        }
        finally {
            this.writeLock.unlock();
        }
        if (result.isError()) {
            return result;
        }
        byte[] bytes = ((ResultLob)result).getByteArray();
        char[] chars = ArrayUtil.byteArrayToChars(bytes);
        return ResultLob.newLobGetCharsResponse(lobID, offset, chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getBytes(long lobID, long offset, int length) {
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.getBytesCompressed(lobID, offset, length);
                return result;
            }
            Result result = this.getBytesNormal(lobID, offset, length);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result getBytesNormal(long lobID, long offset, int length) {
        byte[] bytes;
        int blockOffset = (int)(offset / (long)this.lobBlockSize);
        int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
        int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
        int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        if (length == 0) {
            return ResultLob.newLobGetBytesResponse(lobID, offset, BinaryData.zeroLengthBytes);
        }
        int dataBytesPosition = 0;
        byte[] dataBytes = new byte[length];
        int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
        if (blockAddresses.length == 0) {
            return Result.newErrorResult(Error.error(1852));
        }
        int i = 0;
        int blockCount = blockAddresses[i][1] + blockAddresses[i][2] - blockOffset;
        if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
            blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
        }
        try {
            bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0] - blockAddresses[i][2] + blockOffset, blockCount);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        int subLength = this.lobBlockSize * blockCount - byteBlockOffset;
        if (subLength > length) {
            subLength = length;
        }
        System.arraycopy(bytes, byteBlockOffset, dataBytes, dataBytesPosition, subLength);
        dataBytesPosition += subLength;
        ++i;
        while (i < blockAddresses.length && dataBytesPosition < length) {
            blockCount = blockAddresses[i][1];
            if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
            }
            try {
                bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0], blockCount);
            }
            catch (HsqlException e) {
                return Result.newErrorResult(e);
            }
            subLength = this.lobBlockSize * blockCount;
            if (subLength > length - dataBytesPosition) {
                subLength = length - dataBytesPosition;
            }
            System.arraycopy(bytes, 0, dataBytes, dataBytesPosition, subLength);
            dataBytesPosition += subLength;
            ++i;
        }
        return ResultLob.newLobGetBytesResponse(lobID, offset, dataBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result setBytesBA(long lobID, long offset, byte[] dataBytes, int dataLength) {
        if (dataLength == 0) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            if (this.compressLobs || this.cryptLobs) {
                Result result = this.setBytesBACompressed(lobID, offset, dataBytes, dataLength);
                return result;
            }
            Result result = this.setBytesBANormal(lobID, offset, dataBytes, dataLength);
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setBytesBANormal(long lobID, long offset, byte[] dataBytes, int dataLength) {
        boolean newBlocks = false;
        int blockOffset = (int)(offset / (long)this.lobBlockSize);
        int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
        int blockLimit = (int)((offset + (long)dataLength) / (long)this.lobBlockSize);
        int byteLimitOffset = (int)((offset + (long)dataLength) % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
        int existingLimit = blockOffset;
        if (blockAddresses.length > 0) {
            existingLimit = blockAddresses[blockAddresses.length - 1][2] + blockAddresses[blockAddresses.length - 1][1];
        }
        if (existingLimit < blockLimit) {
            this.createBlockAddresses(lobID, existingLimit, blockLimit - existingLimit);
            blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
            newBlocks = true;
        }
        int currentDataOffset = 0;
        int currentDataLength = dataLength;
        try {
            for (int i = 0; i < blockAddresses.length; ++i) {
                long currentBlockOffset = (long)blockAddresses[i][2] * (long)this.lobBlockSize;
                long currentBlockLength = (long)blockAddresses[i][1] * (long)this.lobBlockSize;
                long currentBlockPosition = (long)blockAddresses[i][0] * (long)this.lobBlockSize;
                int padding = 0;
                if (offset > currentBlockOffset) {
                    currentBlockLength -= offset - currentBlockOffset;
                    currentBlockPosition += offset - currentBlockOffset;
                }
                if ((long)currentDataLength < currentBlockLength) {
                    if (newBlocks) {
                        padding = (int)((currentBlockLength - (long)currentDataLength) % (long)this.lobBlockSize);
                    }
                    currentBlockLength = currentDataLength;
                }
                this.getLobStore().setBlockBytes(dataBytes, currentBlockPosition, currentDataOffset, (int)currentBlockLength);
                if (padding != 0) {
                    ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                    this.getLobStore().setBlockBytes(this.byteBuffer, currentBlockPosition + currentBlockLength, 0, padding);
                }
                currentDataOffset = (int)((long)currentDataOffset + currentBlockLength);
                currentDataLength = (int)((long)currentDataLength - currentBlockLength);
            }
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        this.lobStore.synch();
        this.storeModified = true;
        return ResultLob.newLobSetResponse(lobID, dataLength);
    }

    private Result setBytesIS(long lobID, InputStream inputStream, long offset, long length) {
        if (length == 0L) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        if (this.compressLobs || this.cryptLobs) {
            return this.setBytesISCompressed(lobID, inputStream, offset, length);
        }
        return this.setBytesISNormal(lobID, inputStream, length);
    }

    private Result setBytesISNormal(long lobID, InputStream inputStream, long length) {
        long writeLength = 0L;
        int blockLimit = (int)(length / (long)this.lobBlockSize);
        int byteLimitOffset = (int)(length % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        Result actionResult = this.createBlockAddresses(lobID, 0, blockLimit);
        int[][] blockAddresses = this.getBlockAddresses(lobID, 0, blockLimit);
        for (int i = 0; i < blockAddresses.length; ++i) {
            for (int j = 0; j < blockAddresses[i][1]; ++j) {
                int localLength = this.lobBlockSize;
                ArrayUtil.fillArray(this.byteBuffer, 0, (byte)0);
                if (i == blockAddresses.length - 1 && j == blockAddresses[i][1] - 1) {
                    localLength = byteLimitOffset;
                }
                try {
                    int read;
                    int count = 0;
                    while (localLength > 0 && (read = inputStream.read(this.byteBuffer, count, localLength)) != -1) {
                        localLength -= read;
                        count += read;
                    }
                    writeLength += (long)count;
                }
                catch (IOException e) {
                    return Result.newErrorResult(e);
                }
                try {
                    this.getLobStore().setBlockBytes(this.byteBuffer, blockAddresses[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e);
                }
            }
        }
        this.storeModified = true;
        this.lobStore.synch();
        return ResultLob.newLobSetResponse(lobID, writeLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long lobID, long offset, byte[] dataBytes, int dataLength) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long length = (Long)data[1];
            if (dataLength == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
                return resultLob;
            }
            Result result = this.setBytesBA(lobID, offset, dataBytes, dataLength);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (offset + (long)dataLength > length && (result = this.setLength(lobID, length = offset + (long)dataLength)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long lobID, InputStream inputStream, long length) {
        if (this.byteBuffer == null) {
            return Result.newErrorResult(Error.error(456));
        }
        this.writeLock.lock();
        try {
            Result result = this.setBytesIS(lobID, inputStream, 0L, length);
            Result actionResult = Result.updateZeroResult;
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            long newLength = ((ResultLob)result).getBlockLength();
            if (newLength < length) {
                actionResult = this.truncate(lobID, newLength);
            }
            if (actionResult.isError()) {
                Result result3 = actionResult;
                return result3;
            }
            Result result4 = result;
            return result4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long lobID, long offset, char[] chars, int dataLength) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long length = (Long)data[1];
            if (dataLength == 0) {
                ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
                return resultLob;
            }
            byte[] bytes = ArrayUtil.charArrayToBytes(chars, dataLength);
            Result result = this.setBytesBA(lobID, offset * 2L, bytes, dataLength * 2);
            if (result.isError()) {
                Result result2 = result;
                return result2;
            }
            if (offset + (long)dataLength > length && (result = this.setLength(lobID, length = offset + (long)dataLength)).isError()) {
                Result result3 = result;
                return result3;
            }
            ResultLob resultLob = ResultLob.newLobSetResponse(lobID, length);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long lobID, InputStream inputStream, long length) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = this.setBytesIS(lobID, inputStream, 0L, length * 2L);
            if (result2.isError()) {
                Result result3 = result2;
                return result3;
            }
            long newLength = ((ResultLob)result2).getBlockLength();
            if (newLength < length) {
                result = this.truncate(lobID, newLength);
            }
            result = result2;
            return result;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long lobID, long offset) {
        if (this.byteBuffer == null) {
            throw Error.error(456);
        }
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                Result result = Result.newErrorResult(Error.error(1852));
                return result;
            }
            long length = (Long)data[1];
            long byteLength = offset;
            if ((Integer)data[3] == 40) {
                byteLength *= 2L;
            }
            int blockOffset = (int)((byteLength + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
            ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = blockOffset;
            params[2] = ValuePool.INTEGER_MAX;
            params[3] = ValuePool.getLong(this.sysLobSession.getTransactionSCN());
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params, 0);
            this.setLength(lobID, offset);
            ResultLob resultLob = ResultLob.newLobTruncateResponse(lobID, offset);
            return resultLob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Result setLength(long lobID, long length) {
        ResultMetaData meta = this.updateLobLength.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(length);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, params, 0);
        return result;
    }

    public Result adjustUsageCount(Session session, long lobID, int delta) {
        ResultMetaData meta = this.updateLobUsage.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(delta);
        params[1] = ValuePool.getLong(lobID);
        session.sessionContext.pushDynamicArguments(params);
        Result result = this.updateLobUsage.execute(session);
        if (delta < 0) {
            this.usageChanged += (long)this.lobBlockSize;
        }
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.getSpanningBlocks.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getSpanningBlocks.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        int[][] blocks = new int[size][3];
        for (int i = 0; i < size; ++i) {
            navigator.absolute(i);
            Object[] data = navigator.getCurrent();
            blocks[i][0] = (Integer)data[0];
            blocks[i][1] = (Integer)data[1];
            blocks[i][2] = (Integer)data[2];
        }
        navigator.release();
        return blocks;
    }

    private void deleteBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        params[3] = ValuePool.getLong(this.sysLobSession.getTransactionSCN());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params, 0);
    }

    private void divideBlockAddresses(long lobID, int offset) {
        ResultMetaData meta = this.divideLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(offset);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, params, 0);
    }

    private Result createBlockAddresses(long lobID, int offset, int count) {
        ResultMetaData meta = this.createLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(count);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, params, 0);
        return result;
    }

    private Result createFullBlockAddresses(long lobID, int offset, int count) {
        ResultMetaData meta = this.createSingleLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(count);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.createSingleLobPartCall, params, 0);
        return result;
    }

    private Result createPart(long lobID, long partOffset, int dataLength, int byteLength, int blockOffset, int blockCount) {
        ResultMetaData meta = this.createPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(blockCount);
        params[1] = ValuePool.getInt(blockOffset);
        params[2] = ValuePool.getLong(partOffset);
        params[3] = ValuePool.getLong(dataLength);
        params[4] = ValuePool.getLong(byteLength);
        params[5] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.createPart, params, 0);
        return result;
    }

    private int getBlockAddress(int[][] blockAddresses, int blockOffset) {
        for (int i = 0; i < blockAddresses.length; ++i) {
            if (blockAddresses[i][2] + blockAddresses[i][1] <= blockOffset) continue;
            return blockAddresses[i][0] - blockAddresses[i][2] + blockOffset;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        this.writeLock.lock();
        try {
            this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
            Result result = this.getLobCount.execute(this.sysLobSession);
            this.sysLobSession.sessionContext.pop();
            RowSetNavigator navigator = result.getNavigator();
            boolean next = navigator.next();
            if (!next) {
                navigator.release();
                int n = 0;
                return n;
            }
            Object[] data = navigator.getCurrent();
            int n = ((Number)data[0]).intValue();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                try {
                    this.lobStore.synch();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.storeModified = false;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private long[][] getParts(long lobID, long offset, long limit) {
        ResultMetaData meta = this.getSpanningParts.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getLong(offset);
        params[2] = ValuePool.getLong(limit);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getSpanningParts.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        long[][] blocks = new long[size][6];
        for (int i = 0; i < size; ++i) {
            navigator.absolute(i);
            Object[] data = navigator.getCurrent();
            for (int j = 0; j < blocks[i].length; ++j) {
                blocks[i][j] = ((Number)data[j]).longValue();
            }
        }
        navigator.release();
        return blocks;
    }

    private void inflate(byte[] data, int length) {
        if (this.cryptLobs) {
            length = this.database.logger.getCrypto().decode(data, 0, length, data, 0);
        }
        try {
            this.inflater.setInput(data, 0, length);
            length = this.inflater.inflate(this.dataBuffer);
            this.inflater.reset();
        }
        catch (DataFormatException dataFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int limit = (int)ArrayUtil.getBinaryMultipleCeiling(length, this.lobBlockSize);
        for (int i = length; i < limit; ++i) {
            this.dataBuffer[i] = 0;
        }
    }

    private int deflate(byte[] data, int offset, int length) {
        this.deflater.setInput(data, offset, length);
        this.deflater.finish();
        length = this.deflater.deflate(this.dataBuffer);
        this.deflater.reset();
        if (this.cryptLobs) {
            length = this.database.logger.getCrypto().encode(this.dataBuffer, 0, length, this.dataBuffer, 0);
        }
        int limit = (int)ArrayUtil.getBinaryMultipleCeiling(length, this.lobBlockSize);
        for (int i = length; i < limit; ++i) {
            this.dataBuffer[i] = 0;
        }
        return length;
    }

    private int compareBytesCompressed(long aID, long bID) {
        long[][] aParts = this.getParts(aID, 0L, Long.MAX_VALUE);
        long[][] bParts = this.getParts(bID, 0L, Long.MAX_VALUE);
        for (int i = 0; i < aParts.length && i < bParts.length; ++i) {
            int aPartLength = (int)aParts[i][3];
            this.getPartBytesCompressedInBuffer(aID, aParts[i]);
            byte[] aPartBytes = new byte[aPartLength];
            System.arraycopy(this.dataBuffer, 0, aPartBytes, 0, aPartLength);
            int bPartLength = (int)bParts[i][3];
            this.getPartBytesCompressedInBuffer(aID, bParts[i]);
            int result = ArrayUtil.compare(aPartBytes, 0, aPartLength, this.byteBuffer, 0, bPartLength);
            if (result == 0) continue;
            return result;
        }
        if (aParts.length == bParts.length) {
            return 0;
        }
        return aParts.length > bParts.length ? 1 : -1;
    }

    private int compareTextCompressed(Collation collation, long aID, long bID) {
        long[][] aParts = this.getParts(aID, 0L, Long.MAX_VALUE);
        long[][] bParts = this.getParts(bID, 0L, Long.MAX_VALUE);
        for (int i = 0; i < aParts.length && i < bParts.length; ++i) {
            int aPartLength = (int)aParts[i][3];
            this.getPartBytesCompressedInBuffer(aID, aParts[i]);
            String aString = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, aPartLength));
            int bPartLength = (int)bParts[i][3];
            this.getPartBytesCompressedInBuffer(bID, bParts[i]);
            String bString = new String(ArrayUtil.byteArrayToChars(this.dataBuffer, bPartLength));
            int diff = collation.compare(aString, bString);
            if (diff == 0) continue;
            return diff;
        }
        if (aParts.length == bParts.length) {
            return 0;
        }
        return aParts.length > bParts.length ? 1 : -1;
    }

    private Result setBytesISCompressed(long lobID, InputStream inputStream, long baseOffset, long length) {
        int count;
        long offset = 0L;
        byte[] tempBuffer = new byte[this.largeLobBlockSize];
        do {
            int localLength;
            if ((long)(localLength = tempBuffer.length) > length - offset) {
                localLength = (int)(length - offset);
            }
            count = 0;
            try {
                while (localLength > 0) {
                    int read = inputStream.read(tempBuffer, count, localLength);
                    if (read == -1) {
                        return Result.newErrorResult(new EOFException());
                    }
                    localLength -= read;
                    count += read;
                }
            }
            catch (IOException e) {
                return Result.newErrorResult(e);
            }
            Result result = this.setBytesBACompressedPart(lobID, baseOffset, tempBuffer, count);
            if (result.isError()) {
                return result;
            }
            baseOffset += (long)count;
        } while ((offset += (long)count) != length);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(lobID, length);
    }

    private Result setBytesBACompressed(long lobID, long offset, byte[] dataBytes, int dataLength) {
        if (dataLength == 0) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        if (dataLength <= this.largeLobBlockSize) {
            return this.setBytesBACompressedPart(lobID, offset, dataBytes, dataLength);
        }
        HsqlByteArrayInputStream is = new HsqlByteArrayInputStream(dataBytes, 0, dataLength);
        return this.setBytesISCompressed(lobID, is, offset, dataLength);
    }

    private Result setBytesBACompressedPart(long lobID, long offset, byte[] dataBytes, int dataLength) {
        long[] lastPart = this.getLastPart(lobID);
        int blockOffset = (int)lastPart[1] + (int)lastPart[0];
        long limit = lastPart[2] + lastPart[3];
        if (limit != offset || limit % (long)this.largeLobBlockSize != 0L) {
            return Result.newErrorResult(Error.error(1551, "compressed lobs"));
        }
        int byteLength = this.deflate(dataBytes, 0, dataLength);
        int blockCount = (byteLength + this.lobBlockSize - 1) / this.lobBlockSize;
        Result result = this.createFullBlockAddresses(lobID, blockOffset, blockCount);
        if (result.isError()) {
            return result;
        }
        result = this.createPart(lobID, offset, dataLength, byteLength, blockOffset, blockCount);
        if (result.isError()) {
            return result;
        }
        long blockByteOffset = (long)blockOffset * (long)this.lobBlockSize;
        int blockByteLength = (int)ArrayUtil.getBinaryMultipleCeiling(byteLength, this.lobBlockSize);
        this.setBytesBANormal(lobID, blockByteOffset, this.dataBuffer, blockByteLength);
        this.storeModified = true;
        return ResultLob.newLobSetResponse(lobID, dataLength);
    }

    private Result getBytesCompressed(long lobID, long offset, int length) {
        byte[] dataBytes = new byte[length];
        long[][] parts = this.getParts(lobID, offset, offset + (long)length);
        for (int i = 0; i < parts.length; ++i) {
            long[] part = parts[i];
            long partOffset = part[2];
            int partLength = (int)part[3];
            Result result = this.getPartBytesCompressedInBuffer(lobID, part);
            if (result.isError()) {
                return result;
            }
            ArrayUtil.copyBytes(partOffset, this.dataBuffer, 0, partLength, offset, dataBytes, length);
        }
        return ResultLob.newLobGetBytesResponse(lobID, offset, dataBytes);
    }

    private Result getPartBytesCompressedInBuffer(long lobID, long[] part) {
        long blockOffset = part[1];
        long partOffset = part[2];
        long partLength = part[3];
        long blockByteOffset = blockOffset * (long)this.lobBlockSize;
        int partBytesLength = (int)part[4];
        Result result = this.getBytesNormal(lobID, blockByteOffset, partBytesLength);
        if (result.isError()) {
            return result;
        }
        byte[] byteBlock = ((ResultLob)result).getByteArray();
        this.inflate(byteBlock, partBytesLength);
        return ResultLob.newLobSetResponse(lobID, partLength);
    }

    private long[] getLastPart(long lobID) {
        ResultMetaData meta = this.getLastPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLastPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        long[] blocks = new long[6];
        if (size == 0) {
            blocks[5] = lobID;
        } else {
            navigator.absolute(0);
            Object[] data = navigator.getCurrent();
            for (int j = 0; j < blocks.length; ++j) {
                blocks[j] = ((Number)data[j]).longValue();
            }
        }
        navigator.release();
        return blocks;
    }

    private static interface ALLOC_PART {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int PART_OFFSET = 2;
        public static final int PART_LENGTH = 3;
        public static final int PART_BYTES = 4;
        public static final int LOB_ID = 5;
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

