/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.LobStore;

public class LobStoreMem
implements LobStore {
    final int lobBlockSize;
    int blocksInLargeBlock = 128;
    int largeBlockSize;
    HsqlArrayList byteStoreList;

    public LobStoreMem(int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.largeBlockSize = lobBlockSize * this.blocksInLargeBlock;
        this.byteStoreList = new HsqlArrayList();
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        byte[] dataBytes = new byte[blockCount * this.lobBlockSize];
        int dataBlockOffset = 0;
        while (blockCount > 0) {
            int largeBlockIndex = blockAddress / this.blocksInLargeBlock;
            byte[] largeBlock = (byte[])this.byteStoreList.get(largeBlockIndex);
            int blockOffset = blockAddress % this.blocksInLargeBlock;
            int currentBlockCount = blockCount;
            if (blockOffset + currentBlockCount > this.blocksInLargeBlock) {
                currentBlockCount = this.blocksInLargeBlock - blockOffset;
            }
            System.arraycopy(largeBlock, blockOffset * this.lobBlockSize, dataBytes, dataBlockOffset * this.lobBlockSize, currentBlockCount * this.lobBlockSize);
            blockAddress += currentBlockCount;
            dataBlockOffset += currentBlockCount;
            blockCount -= currentBlockCount;
        }
        return dataBytes;
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        int dataBlockOffset = 0;
        while (blockCount > 0) {
            int largeBlockIndex = blockAddress / this.blocksInLargeBlock;
            if (largeBlockIndex >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] largeBlock = (byte[])this.byteStoreList.get(largeBlockIndex);
            int blockOffset = blockAddress % this.blocksInLargeBlock;
            int currentBlockCount = blockCount;
            if (blockOffset + currentBlockCount > this.blocksInLargeBlock) {
                currentBlockCount = this.blocksInLargeBlock - blockOffset;
            }
            System.arraycopy(dataBytes, dataBlockOffset * this.lobBlockSize, largeBlock, blockOffset * this.lobBlockSize, currentBlockCount * this.lobBlockSize);
            blockAddress += currentBlockCount;
            dataBlockOffset += currentBlockCount;
            blockCount -= currentBlockCount;
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, long position, int offset, int length) {
        while (length > 0) {
            int largeBlockIndex = (int)(position / (long)this.largeBlockSize);
            if (largeBlockIndex >= this.byteStoreList.size()) {
                this.byteStoreList.add(new byte[this.largeBlockSize]);
            }
            byte[] largeBlock = (byte[])this.byteStoreList.get(largeBlockIndex);
            int offsetInLargeBlock = (int)(position % (long)this.largeBlockSize);
            int currentLength = length;
            if (offsetInLargeBlock + currentLength > this.largeBlockSize) {
                currentLength = this.largeBlockSize - offsetInLargeBlock;
            }
            System.arraycopy(dataBytes, offset, largeBlock, offsetInLargeBlock, currentLength);
            position += (long)currentLength;
            offset += currentLength;
            length -= currentLength;
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return (long)this.byteStoreList.size() * (long)this.largeBlockSize;
    }

    @Override
    public void setLength(long length) {
        int largeBlockIndex = (int)(length / (long)this.largeBlockSize);
        this.byteStoreList.setSize(largeBlockIndex + 1);
    }

    @Override
    public void close() {
        this.byteStoreList.clear();
    }

    @Override
    public void synch() {
    }
}

