/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLMemory;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLHybridExtended;
import org.hsqldb.persist.RowStoreAVLMemory;
import org.hsqldb.persist.RowStoreDataChange;
import org.hsqldb.persist.TextTableStorageManager;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Logger
implements EventLogInterface {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private Database database;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean propIsFileDatabase;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks = 512;
    private int propCacheMaxRows;
    private long propCacheMaxSize;
    int propDataFileDefragLimit;
    private int propDataFileScale;
    int propDataFileSpace;
    String propTextSourceDefault = "";
    boolean propTextAllowFullPath;
    private int propWriteDelay;
    private int propLogSize;
    private boolean propLogData = true;
    private int propExternalEventLogLevel;
    private int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    boolean propCompressLobs;
    int propScriptFormat = 0;
    boolean propLargeData;
    long propFilesTimestamp;
    Log log;
    private LockFile lockFile;
    private Crypto crypto;
    boolean cryptLobs;
    public FileAccess fileAccess;
    String tempDirectoryPath;
    public TextTableStorageManager textTableManager = new TextTableStorageManager();
    public boolean isNewDatabase;
    public boolean isSingleFile;
    AtomicInteger backupState = new AtomicInteger();
    AtomicInteger checkpointState = new AtomicInteger();
    long maxLogSize;
    static final int largeDataFactor = 128;
    static final int stateNormal = 0;
    static final int stateBackup = 1;
    static final int stateCheckpoint = 2;
    static final int stateCheckpointNormal = 0;
    static final int stateCheckpointRequired = 1;
    static final int stateCheckpointDue = 2;
    public static final String oldFileExtension = ".old";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String logFileExtension = ".log";
    public static final String scriptFileExtension = ".script";
    public static final String propertiesFileExtension = ".properties";
    public static final String dataFileExtension = ".data";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String lockFileExtension = ".lck";
    public SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static char runtimeFileDelim = System.getProperty("file.separator").charAt(0);
    DbBackup backup;

    public Logger(Database database) {
        this.database = database;
    }

    public void open() {
        int level;
        boolean hasFileProps = false;
        boolean hasScript = false;
        this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        this.propIsFileDatabase = this.database.getType().isFileBased();
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        if (this.propIsFileDatabase) {
            hasFileProps = this.database.databaseProperties.load();
            hasScript = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension);
            boolean version18 = this.database.databaseProperties.isVersion18();
            if (version18) {
                throw Error.error(453, "unsupported old database version");
            }
            boolean exists = hasScript;
            if (!exists) {
                exists = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension + newFileExtension);
                if (exists) {
                    this.database.databaseProperties.setDBModified(2);
                } else {
                    exists = this.fileAccess.isStreamElement(this.database.getPath() + dataFileExtension);
                    if (exists) {
                        throw Error.error(466, "database files not complete");
                    }
                    exists = this.fileAccess.isStreamElement(this.database.getPath() + backupFileExtension);
                    if (exists) {
                        throw Error.error(466, "database files not complete");
                    }
                }
            }
            this.isNewDatabase = !exists;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            String name = this.newUniqueName();
            this.database.setDatabaseName(name);
            boolean checkExists = this.database.isFilesInJar();
            if (checkExists |= this.database.urlProperties.isPropertyTrue("ifexists") || !this.database.urlProperties.isPropertyTrue("create", true)) {
                throw Error.error(465, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            if (!hasFileProps) {
                this.database.databaseProperties.setDBModified(1);
            }
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
            if (!this.database.urlProperties.isPropertyTrue("hsqldb.lock_file", true)) {
                this.database.databaseProperties.setProperty("hsqldb.lock_file", false);
            }
        }
        this.setVariables();
        String appLogPath = null;
        String sqlLogPath = null;
        if (this.propIsFileDatabase && !this.database.isFilesReadOnly()) {
            appLogPath = this.database.getPath() + appLogFileExtension;
            sqlLogPath = this.database.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(appLogPath, this.propEventLogLevel, false);
        this.sqlLog = new SimpleLog(sqlLogPath, this.propSqlLogLevel, true);
        this.database.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.checkpointState.set(0);
        this.logsStatements = false;
        boolean useLock = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (useLock && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        this.log = new Log(this.database);
        this.log.open();
        this.logsStatements = true;
        boolean bl = this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        if (this.database.getNameString().isEmpty()) {
            this.database.setDatabaseName(this.newUniqueName());
        }
        if ((level = this.database.urlProperties.getIntegerProperty("hsqldb.applog", -1)) >= 0) {
            this.setEventLogLevel(level, false);
        }
        if ((level = this.database.urlProperties.getIntegerProperty("hsqldb.extlog", -1)) >= 0) {
            this.setExternalEventLogLevel(level);
        }
        if ((level = this.database.urlProperties.getIntegerProperty("hsqldb.sqllog", -1)) >= 0) {
            this.setEventLogLevel(level, true);
        }
    }

    private void setVariables() {
        String txMode;
        String tableType;
        String cryptKey = this.database.urlProperties.getProperty("crypt_key");
        if (cryptKey != null) {
            String cryptType = this.database.urlProperties.getProperty("crypt_type");
            String cryptProvider = this.database.urlProperties.getProperty("crypt_provider");
            String cryptIv = this.database.urlProperties.getProperty("crypt_iv");
            this.crypto = new Crypto(cryptKey, cryptIv, cryptType, cryptProvider);
            this.cryptLobs = this.database.urlProperties.isPropertyTrue("crypt_lobs", true);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == DatabaseType.DB_MEM ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = this.database.databaseProperties.getIntegerProperty("hsqldb.script_format");
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count");
        this.propMaxFreeBlocks = ArrayUtil.getTwoPowerFloor(this.propMaxFreeBlocks);
        if (this.database.urlProperties.isPropertyTrue("hsqldb.large_data", false)) {
            this.propLargeData = true;
        }
        if (!this.database.databaseProperties.isPropertyTrue("sql.pad_space", true)) {
            this.database.collation.setPadding(false);
        }
        String temp = this.database.getProperties().getStringProperty("hsqldb.digest");
        this.database.granteeManager.setDigestAlgo(temp);
        if (!this.isNewDatabase) {
            return;
        }
        if (this.tempDirectoryPath != null) {
            int rows = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(rows);
        }
        if ("CACHED".equalsIgnoreCase(tableType = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(5);
        }
        if ("MVCC".equalsIgnoreCase(txMode = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        String txLevel = this.database.databaseProperties.getStringProperty("hsqldb.tx_level");
        this.database.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(txLevel) ? 8 : 2;
        this.database.txConflictRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_conflict_rollback");
        this.database.txInterruptRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_interrupt_rollback");
        this.database.sqlRestrictExec = this.database.databaseProperties.isPropertyTrue("sql.restrict_exec");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        this.database.sqlRegularNames = this.database.databaseProperties.isPropertyTrue("sql.regular_names");
        this.database.sqlEnforceRefs = this.database.databaseProperties.isPropertyTrue("sql.enforce_refs");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceTypes = this.database.databaseProperties.isPropertyTrue("sql.enforce_types");
        this.database.sqlEnforceTDCD = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_delete");
        this.database.sqlEnforceTDCU = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_update");
        this.database.sqlTranslateTTI = this.database.databaseProperties.isPropertyTrue("jdbc.translate_tti_types");
        this.database.sqlLiveObject = this.database.databaseProperties.isPropertyTrue("sql.live_object");
        this.database.sqlCharLiteral = this.database.databaseProperties.isPropertyTrue("sql.char_literal");
        this.database.sqlConcatNulls = this.database.databaseProperties.isPropertyTrue("sql.concat_nulls");
        this.database.sqlNullsFirst = this.database.databaseProperties.isPropertyTrue("sql.nulls_first");
        this.database.sqlNullsOrder = this.database.databaseProperties.isPropertyTrue("sql.nulls_order");
        this.database.sqlUniqueNulls = this.database.databaseProperties.isPropertyTrue("sql.unique_nulls");
        this.database.sqlConvertTruncate = this.database.databaseProperties.isPropertyTrue("sql.convert_trunc");
        this.database.sqlTruncateTrailing = this.database.databaseProperties.isPropertyTrue("sql.truncate_trailing");
        this.database.sqlAvgScale = this.database.databaseProperties.getIntegerProperty("sql.avg_scale");
        this.database.sqlMaxRecursive = this.database.databaseProperties.getIntegerProperty("sql.max_recursive");
        this.database.sqlDoubleNaN = this.database.databaseProperties.isPropertyTrue("sql.double_nan");
        this.database.sqlLongvarIsLob = this.database.databaseProperties.isPropertyTrue("sql.longvar_is_lob");
        this.database.sqlIgnoreCase = this.database.databaseProperties.isPropertyTrue("sql.ignore_case");
        this.database.sqlSyntaxDb2 = this.database.databaseProperties.isPropertyTrue("sql.syntax_db2");
        this.database.sqlSyntaxMss = this.database.databaseProperties.isPropertyTrue("sql.syntax_mss");
        this.database.sqlSyntaxMys = this.database.databaseProperties.isPropertyTrue("sql.syntax_mys");
        this.database.sqlSyntaxOra = this.database.databaseProperties.isPropertyTrue("sql.syntax_ora");
        this.database.sqlSyntaxPgs = this.database.databaseProperties.isPropertyTrue("sql.syntax_pgs");
        this.database.sqlSysIndexNames = this.database.databaseProperties.isPropertyTrue("sql.sys_index_names");
        this.database.sqlLowerCaseIdentifier = this.database.databaseProperties.isPropertyTrue("sql.lowercase_ident");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propExternalEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.extlog");
        this.propSqlLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.sqllog");
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propNioMaxSize = (long)this.database.databaseProperties.getIntegerProperty("hsqldb.nio_max_size") * 1024L * 1024L;
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = (long)this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024L;
        this.setLobFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.lob_file_scale"));
        this.setLobFileCompressedNoCheck(this.database.databaseProperties.isPropertyTrue("hsqldb.lob_compressed"));
        this.setDataFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale"));
        boolean fileSpace = this.database.databaseProperties.isPropertyTrue("hsqldb.files_space");
        this.setDataFileSpace(fileSpace);
        this.propDataFileDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propWriteDelay = this.database.databaseProperties.getIntegerProperty("hsqldb.write_delay_millis");
        if (!this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.setLogSize(this.database.databaseProperties.getIntegerProperty("hsqldb.log_size"));
        this.propLogData = this.database.databaseProperties.isPropertyTrue("hsqldb.log_data");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = this.database.databaseProperties.isPropertyTrue("sql.ref_integrity");
    }

    public boolean close(int closemode) {
        boolean result = true;
        if (this.log == null) {
            this.textTableManager.closeAllTextCaches(false);
            return true;
        }
        this.log.synchLog();
        this.database.lobManager.synch();
        try {
            switch (closemode) {
                case 1: {
                    this.log.closeImmediately();
                    break;
                }
                case 2: {
                    this.log.close(false);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.close(true);
                }
            }
            this.database.persistentStoreCollection.release();
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("error closing log", e);
            result = false;
        }
        this.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.sqlLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return result;
    }

    String newUniqueName() {
        String name = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        name = "HSQLDB" + name.substring(6).toUpperCase(Locale.ENGLISH);
        return name;
    }

    public boolean isLogged() {
        return this.propIsFileDatabase && !this.database.isFilesReadOnly();
    }

    public boolean isCurrentlyLogged() {
        return this.loggingEnabled;
    }

    public boolean isAllowedFullPath() {
        return this.propTextAllowFullPath;
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String name = this.database.getNameString();
        if (name.isEmpty()) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "hsqldb.db." + this.database.getNameString());
    }

    public void setEventLogLevel(int level, boolean logSql) {
        if (level < 0 || level > 4) {
            throw Error.error(5556);
        }
        if (logSql) {
            this.propSqlLogLevel = level;
            this.sqlLog.setLevel(level);
        } else {
            this.propEventLogLevel = level;
            this.appLog.setLevel(level);
        }
    }

    public void setExternalEventLogLevel(int level) {
        if (level < 0 || level > 4) {
            throw Error.error(5556);
        }
        this.propExternalEventLogLevel = level;
    }

    @Override
    public void logSevereEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 1) {
            this.fwLogger.severe(message, t);
        }
        if (this.appLog != null) {
            if (t == null) {
                this.appLog.logContext(1, message);
            } else {
                this.appLog.logContext(t, message, 1);
            }
        }
    }

    @Override
    public void logWarningEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 2) {
            this.fwLogger.warning(message, t);
        }
        this.appLog.logContext(t, message, 2);
    }

    @Override
    public void logInfoEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 3) {
            this.fwLogger.info(message);
        }
        this.appLog.logContext(3, message);
    }

    @Override
    public void logDetailEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 4) {
            this.fwLogger.finest(message);
        }
        if (this.appLog != null) {
            this.appLog.logContext(4, message);
        }
    }

    public void logStatementEvent(Session session, Statement statement, Object[] paramValues, Result result, int level) {
        if (this.sqlLog != null && level <= this.propSqlLogLevel) {
            String sessionId = Long.toString(session.getId());
            String sql = statement.getSQL();
            String values = "";
            int paramLength = 0;
            if (this.propSqlLogLevel < 4) {
                if (sql.length() > 256) {
                    sql = sql.substring(0, 256);
                }
                paramLength = 32;
            }
            if (paramValues != null && paramValues.length > 0) {
                values = RowType.convertToSQLString(paramValues, statement.getParametersMetaData().getParameterTypes(), paramLength);
            }
            if (this.propSqlLogLevel == 4) {
                StringBuilder sb = new StringBuilder(values);
                sb.append(' ').append('[');
                if (result.isError()) {
                    sb.append(result.getErrorCode());
                } else if (result.isData()) {
                    sb.append(result.getNavigator().getSize());
                } else if (result.isUpdateCount()) {
                    sb.append(result.getUpdateCount());
                }
                sb.append(']');
                values = sb.toString();
            }
            this.sqlLog.logContext(level, sessionId, sql, values);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    public DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void writeOtherStatement(Session session, String statement) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Row row, Table table) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, row, table);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
        } else if (this.maxLogSize > 0L && this.database.lobManager.getUsageChanged() > this.maxLogSize) {
            this.setCheckpointRequired();
        }
    }

    public synchronized void synchLog() {
        if (this.loggingEnabled) {
            this.log.synchLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(Session session, boolean defrag, boolean lobs) {
        if (!this.backupState.compareAndSet(0, 2)) {
            throw Error.error(457);
        }
        this.database.lobManager.lock();
        try {
            Logger logger = this;
            synchronized (logger) {
                this.checkpointInternal(session, defrag);
                if (lobs) {
                    Result result = this.database.lobManager.deleteUnusedLobs();
                    if (this.log != null && result.getUpdateCount() > 0) {
                        this.log.synchLog();
                        this.logDetailEvent("Deleted unused LOBs, count: " + result.getUpdateCount());
                    }
                }
            }
        }
        finally {
            this.backupState.set(0);
            this.checkpointState.set(0);
            this.database.lobManager.unlock();
        }
    }

    private void checkpointInternal(Session session, boolean defrag) {
        if (this.logsStatements) {
            this.logInfoEvent("Checkpoint start");
            this.log.checkpoint(session, defrag);
            this.logInfoEvent("Checkpoint end - txts: " + this.database.txManager.getSystemChangeNumber());
        }
    }

    public synchronized void setLogSize(int megas) {
        this.propLogSize = megas;
        this.maxLogSize = (long)this.propLogSize * 1024L * 1024L;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setLogData(boolean mode) {
        this.propLogData = mode;
        this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        this.loggingEnabled &= this.logsStatements;
    }

    public synchronized void setScriptType(int format) {
        if (format == this.propScriptFormat) {
            return;
        }
        this.propScriptFormat = format;
        this.checkpointState.compareAndSet(0, 1);
    }

    public synchronized void setWriteDelay(int delay) {
        this.propWriteDelay = delay;
        if (this.log != null) {
            this.log.setWriteDelay(delay);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public void setCacheMaxRows(int value) {
        this.propCacheMaxRows = value;
    }

    public int getCacheMaxRows() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int value) {
        this.propCacheMaxSize = (long)value * 1024L;
    }

    public long getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setDataFileScale(int value) {
        if (value < 16) {
            throw Error.error(5556);
        }
        this.setDataFileScaleNoCheck(value);
    }

    public void setDataFileScaleNoCheck(int value) {
        Logger.checkPower(value, 10);
        if (value < 8 && value != 1) {
            throw Error.error(5556);
        }
        this.propDataFileScale = value;
        if (this.propDataFileSpace > 0) {
            this.propDataFileSpace = this.propDataFileScale / 16;
        }
    }

    public int getDataFileScale() {
        return this.propDataFileScale;
    }

    public int getDataFileFactor() {
        return this.propLargeData ? 128 : 1;
    }

    public void setDataFileSpace(boolean value) {
        if (value) {
            this.setDataFileSpace(this.propDataFileScale / 16);
        } else {
            this.setDataFileSpace(0);
        }
    }

    public void setDataFileSpace(int value) {
        if (value != 0) {
            Logger.checkPower(value, 6);
        }
        if (value > this.propDataFileScale / 16) {
            value = this.propDataFileScale / 16;
        }
        this.propDataFileSpace = value;
    }

    public int getDataFileSpace() {
        return this.propDataFileSpace;
    }

    public long getFilesTimestamp() {
        return this.propFilesTimestamp;
    }

    public void setFilesTimestamp(long value) {
        this.propFilesTimestamp = value;
    }

    public void setLobFileScale(int value) {
        if (this.propLobBlockSize == value * 1024) {
            return;
        }
        Logger.checkPower(value, 5);
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = value * 1024;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int value) {
        Logger.checkPower(value, 5);
        this.propLobBlockSize = value * 1024;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setLobFileCompressed(boolean value) {
        if (this.propCompressLobs == value) {
            return;
        }
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propCompressLobs = value;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileCompressedNoCheck(boolean value) {
        this.propCompressLobs = value;
    }

    public void setDefagLimit(int value) {
        if (value > 0 && value < 25) {
            value = 25;
        }
        this.propDataFileDefragLimit = value;
    }

    public int getDefragLimit() {
        return this.propDataFileDefragLimit;
    }

    public void setDefaultTextTableProperties(String source, HsqlProperties props) {
        props.setProperty("check_props", true);
        this.database.getProperties().setURLProperties(props);
        this.propTextSourceDefault = source;
    }

    public void setNioDataFile(boolean value) {
        this.propNioDataFile = value;
    }

    public void setNioMaxSize(int value) {
        if ((value = ArrayUtil.getTwoPowerFloor(value)) < 64) {
            value = 64;
        }
        this.propNioMaxSize = (long)value * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int max) {
        if (!ArrayUtil.isTwoPower(n, max)) {
            throw Error.error(5556);
        }
    }

    public void setCheckpointRequired() {
        this.checkpointState.compareAndSet(0, 1);
    }

    public boolean needsCheckpointReset() {
        return this.checkpointState.compareAndSet(1, 2);
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String path) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection collection, TableBase table) {
        switch (table.getTableType()) {
            case 5: {
                DataFileCache cache = this.getCache();
                if (cache == null) break;
                return new RowStoreAVLDisk(cache, (Table)table);
            }
            case 4: 
            case 12: {
                return new RowStoreAVLMemory((Table)table);
            }
            case 7: {
                return new RowStoreAVLDiskData((Table)table);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, table, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, table, true);
            }
            case 13: {
                return new RowStoreDataChange(session, table);
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, table, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        switch (table.getTableType()) {
            case 1: 
            case 4: 
            case 12: {
                return new IndexAVLMemory(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return new IndexAVL(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public HashMap getPropertyValueMap(Session session) {
        String prop;
        HashMap<String, String> map = new HashMap<String, String>();
        String value = null;
        map.put("sql.avg_scale", String.valueOf(this.database.sqlAvgScale));
        map.put("sql.char_literal", String.valueOf(this.database.sqlCharLiteral));
        map.put("sql.concat_nulls", String.valueOf(this.database.sqlConcatNulls));
        map.put("sql.convert_trunc", String.valueOf(this.database.sqlConvertTruncate));
        map.put("sql.default_collation", String.valueOf(this.database.collation.getName().name));
        map.put("sql.truncate_trailing", String.valueOf(this.database.sqlTruncateTrailing));
        map.put("sql.double_nan", String.valueOf(this.database.sqlDoubleNaN));
        map.put("sql.enforce_names", String.valueOf(this.database.sqlEnforceNames));
        map.put("sql.enforce_refs", String.valueOf(this.database.sqlEnforceRefs));
        map.put("sql.enforce_size", String.valueOf(this.database.sqlEnforceSize));
        map.put("sql.enforce_tdc_delete", String.valueOf(this.database.sqlEnforceTDCD));
        map.put("sql.enforce_tdc_update", String.valueOf(this.database.sqlEnforceTDCU));
        map.put("sql.enforce_types", String.valueOf(this.database.sqlEnforceTypes));
        map.put("sql.ignore_case", String.valueOf(this.database.sqlIgnoreCase));
        map.put("sql.live_object", String.valueOf(this.database.sqlLiveObject));
        map.put("sql.longvar_is_lob", String.valueOf(this.database.sqlLongvarIsLob));
        map.put("sql.lowercase_ident", String.valueOf(this.database.sqlLowerCaseIdentifier));
        map.put("sql.max_recursive", String.valueOf(this.database.sqlMaxRecursive));
        map.put("sql.nulls_first", String.valueOf(this.database.sqlNullsFirst));
        map.put("sql.nulls_order", String.valueOf(this.database.sqlNullsOrder));
        map.put("sql.pad_space", String.valueOf(this.database.collation.isPadSpace()));
        map.put("sql.ref_integrity", String.valueOf(this.database.isReferentialIntegrity()));
        map.put("sql.regular_names", String.valueOf(this.database.sqlRegularNames));
        map.put("sql.restrict_exec", String.valueOf(this.database.sqlRestrictExec));
        map.put("sql.syntax_db2", String.valueOf(this.database.sqlSyntaxDb2));
        map.put("sql.syntax_mss", String.valueOf(this.database.sqlSyntaxMss));
        map.put("sql.syntax_mys", String.valueOf(this.database.sqlSyntaxMys));
        map.put("sql.syntax_ora", String.valueOf(this.database.sqlSyntaxOra));
        map.put("sql.syntax_pgs", String.valueOf(this.database.sqlSyntaxPgs));
        map.put("sql.sys_index_names", String.valueOf(this.database.sqlSysIndexNames));
        map.put("sql.unique_nulls", String.valueOf(this.database.sqlUniqueNulls));
        map.put("jdbc.translate_tti_types", String.valueOf(this.database.sqlTranslateTTI));
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                value = "MVCC";
                break;
            }
            case 1: {
                value = "MVLOCKS";
                break;
            }
            case 0: {
                value = "LOCKS";
            }
        }
        map.put("hsqldb.tx", value);
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                value = "READ" + '_' + "COMMITTED";
                break;
            }
            case 8: {
                value = "SERIALIZABLE";
            }
        }
        map.put("hsqldb.tx_level", value);
        map.put("hsqldb.reconfig_logging", System.getProperty("hsqldb.reconfig_logging"));
        if (HsqlDatabaseProperties.methodClassNames != null) {
            map.put("hsqldb.method_class_names", HsqlDatabaseProperties.methodClassNames);
        }
        map.put("hsqldb.applog", String.valueOf(this.appLog.getLevel()));
        map.put("hsqldb.extlog", String.valueOf(this.propExternalEventLogLevel));
        map.put("hsqldb.sqllog", String.valueOf(this.sqlLog.getLevel()));
        map.put("hsqldb.lob_file_scale", String.valueOf(this.propLobBlockSize / 1024));
        map.put("hsqldb.lob_compressed", String.valueOf(this.propCompressLobs));
        map.put("hsqldb.cache_file_scale", String.valueOf(this.propDataFileScale));
        map.put("hsqldb.cache_free_count", String.valueOf(this.propMaxFreeBlocks));
        map.put("hsqldb.cache_rows", String.valueOf(this.propCacheMaxRows));
        map.put("hsqldb.cache_size", String.valueOf(this.propCacheMaxSize / 1024L));
        switch (this.database.schemaManager.getDefaultTableType()) {
            case 5: {
                prop = "CACHED";
                break;
            }
            default: {
                prop = "MEMORY";
            }
        }
        map.put("hsqldb.default_table_type", prop);
        map.put("hsqldb.defrag_limit", String.valueOf(this.propDataFileDefragLimit));
        map.put("hsqldb.files_space", String.valueOf(this.propDataFileSpace));
        map.put("files_readonly", this.database.databaseProperties.isPropertyTrue("files_readonly") ? "true" : "false");
        map.put("hsqldb.large_data", String.valueOf(this.propLargeData));
        map.put("hsqldb.lock_file", this.database.databaseProperties.isPropertyTrue("hsqldb.lock_file") ? "true" : "false");
        map.put("hsqldb.log_data", String.valueOf(this.propLogData));
        map.put("hsqldb.log_size", String.valueOf(this.propLogSize));
        map.put("hsqldb.nio_data_file", String.valueOf(this.propNioDataFile));
        map.put("hsqldb.nio_max_size", String.valueOf(this.propNioMaxSize / 0x100000L));
        map.put("hsqldb.script_format", ScriptWriterBase.LIST_SCRIPT_FORMATS[this.propScriptFormat].toLowerCase());
        map.put("hsqldb.temp_directory", this.tempDirectoryPath);
        map.put("hsqldb.tx_conflict_rollback", String.valueOf(this.database.txConflictRollback));
        map.put("hsqldb.tx_interrupt_rollback", String.valueOf(this.database.txInterruptRollback));
        map.put("hsqldb.result_max_memory_rows", String.valueOf(this.database.getResultMaxMemoryRows()));
        map.put("readonly", this.database.isReadOnly() ? "true" : "false");
        map.put("files_readonly", this.database.isFilesReadOnly() ? "true" : "false");
        map.put("hsqldb.write_delay", String.valueOf(this.propWriteDelay != 0));
        map.put("hsqldb.write_delay_millis", String.valueOf(this.propWriteDelay));
        map.put("hsqldb.digest", this.database.granteeManager.getDigestAlgo());
        return map;
    }

    public String[] getPropertiesSQL(boolean indexRoots) {
        int delay;
        boolean millis;
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("SET DATABASE ").append("UNIQUE").append(' ');
        sb.append("NAME").append(' ').append(this.database.getNameString());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("RESULT").append(' ').append("MEMORY");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.database.getResultMaxMemoryRows());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("EVENT").append(' ');
        sb.append("LOG").append(' ').append("LEVEL");
        sb.append(' ').append(this.propEventLogLevel);
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propExternalEventLogLevel != 0) {
            sb.append("SET DATABASE ").append("EXTERNAL").append(' ');
            sb.append("EVENT").append(' ');
            sb.append("LOG").append(' ').append("LEVEL");
            sb.append(' ').append(this.propExternalEventLogLevel);
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.propSqlLogLevel != 0) {
            sb.append("SET DATABASE ").append("EVENT").append(' ');
            sb.append("LOG").append(' ').append("SQL");
            sb.append(' ').append("LEVEL");
            sb.append(' ').append(this.propEventLogLevel);
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                sb.append("MVCC");
                break;
            }
            case 1: {
                sb.append("MVLOCKS");
                break;
            }
            case 0: {
                sb.append("LOCKS");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("ISOLATION").append(' ').append("LEVEL");
        sb.append(' ');
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                sb.append("READ").append(' ').append("COMMITTED");
                break;
            }
            case 8: {
                sb.append("SERIALIZABLE");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TRANSACTION").append(' ');
        sb.append("ROLLBACK").append(' ');
        sb.append("ON").append(' ');
        sb.append("CONFLICT").append(' ');
        sb.append(this.database.txConflictRollback ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.txInterruptRollback) {
            sb.append("SET DATABASE ").append("TRANSACTION");
            sb.append(' ').append("ROLLBACK").append(' ');
            sb.append("ON").append(' ');
            sb.append("INTERRUPT").append(' ');
            sb.append(this.database.txInterruptRollback ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("TEXT").append(' ');
        sb.append("TABLE").append(' ').append("DEFAULTS");
        sb.append(' ').append('\'');
        sb.append(this.propTextSourceDefault).append('\'');
        list.add(sb.toString());
        sb.setLength(0);
        String temp = HsqlDatabaseProperties.getStringPropertyDefault("hsqldb.digest");
        if (!temp.equals(this.database.granteeManager.getDigestAlgo())) {
            sb.append("SET DATABASE ").append("PASSWORD").append(' ');
            sb.append("DIGEST").append(' ').append('\'');
            sb.append(this.database.granteeManager.getDigestAlgo()).append('\'');
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.schemaManager.getDefaultTableType() == 5) {
            sb.append("SET DATABASE ").append("DEFAULT").append(' ');
            sb.append("TABLE").append(' ');
            sb.append("TYPE").append(' ');
            sb.append("CACHED");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("NAMES").append(' ');
        sb.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("RESTRICT").append(' ');
        sb.append("EXEC").append(' ');
        sb.append(this.database.sqlRestrictExec ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (!this.database.sqlRegularNames) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("REGULAR").append(' ');
            sb.append("NAMES").append(' ');
            sb.append(this.database.sqlRegularNames ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("REFERENCES").append(' ');
        sb.append(this.database.sqlEnforceRefs ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("SIZE").append(' ');
        sb.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TYPES").append(' ');
        sb.append(this.database.sqlEnforceTypes ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("DELETE").append(' ');
        sb.append(this.database.sqlEnforceTDCD ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("TDC").append(' ');
        sb.append("UPDATE").append(' ');
        sb.append(this.database.sqlEnforceTDCU ? "TRUE" : "FALSE");
        list.add(sb.toString());
        if (!this.database.sqlTranslateTTI) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("TRANSLATE").append(' ').append("TTI");
            sb.append(' ').append("TYPES").append(' ');
            sb.append(this.database.sqlTranslateTTI ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("SYS").append(' ').append("INDEX");
        sb.append(' ').append("NAMES").append(' ');
        sb.append(this.database.sqlSysIndexNames ? "TRUE" : "FALSE");
        list.add(sb.toString());
        if (!this.database.sqlCharLiteral) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("CHARACTER").append(' ');
            sb.append("LITERAL").append(' ');
            sb.append(this.database.sqlCharLiteral ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONCAT").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlConcatNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        if (!this.database.sqlNullsFirst) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("NULLS").append(' ');
            sb.append("FIRST").append(' ');
            sb.append(this.database.sqlNullsFirst ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        if (!this.database.sqlNullsOrder) {
            sb.setLength(0);
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("NULLS").append(' ');
            sb.append("ORDER").append(' ');
            sb.append(this.database.sqlNullsOrder ? "TRUE" : "FALSE");
            list.add(sb.toString());
        }
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("UNIQUE").append(' ');
        sb.append("NULLS").append(' ');
        sb.append(this.database.sqlUniqueNulls ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("CONVERT").append(' ');
        sb.append("TRUNCATE").append(' ');
        sb.append(this.database.sqlConvertTruncate ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("AVG").append(' ');
        sb.append("SCALE").append(' ');
        sb.append(this.database.sqlAvgScale);
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.sqlMaxRecursive != HsqlDatabaseProperties.getIntegerPropertyDefault("sql.max_recursive")) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("MAX").append(' ');
            sb.append("RECURSIVE").append(' ');
            sb.append(this.database.sqlMaxRecursive);
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("DOUBLE").append(' ');
        sb.append("NAN").append(' ');
        sb.append(this.database.sqlDoubleNaN ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        if (this.database.sqlIgnoreCase) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("IGNORECASE").append(' ');
            sb.append(this.database.sqlIgnoreCase ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlLongvarIsLob) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("LONGVAR").append(' ');
            sb.append("IS").append(' ');
            sb.append("LOB").append(' ');
            sb.append(this.database.sqlLongvarIsLob ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlLowerCaseIdentifier) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("LOWER").append(' ');
            sb.append("CASE").append(' ');
            sb.append("IDENTIFIER").append(' ');
            sb.append(this.database.sqlLowerCaseIdentifier ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (!this.database.sqlTruncateTrailing) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("TRUNCATE").append(' ');
            sb.append("TRAILING").append(' ');
            sb.append(this.database.sqlTruncateTrailing ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxDb2) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("DB2").append(' ');
            sb.append(this.database.sqlSyntaxDb2 ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxMss) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MSS").append(' ');
            sb.append(this.database.sqlSyntaxMss ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxMys) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("MYS").append(' ');
            sb.append(this.database.sqlSyntaxMys ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxOra) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("ORA").append(' ');
            sb.append(this.database.sqlSyntaxOra ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (this.database.sqlSyntaxPgs) {
            sb.append("SET DATABASE ").append("SQL").append(' ');
            sb.append("SYNTAX").append(' ');
            sb.append("PGS").append(' ');
            sb.append(this.database.sqlSyntaxPgs ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        boolean bl = millis = (delay = this.propWriteDelay) > 0 && delay < 1000;
        if (millis) {
            if (delay < 20) {
                delay = 20;
            }
        } else {
            delay /= 1000;
        }
        sb.append("SET FILES ").append("WRITE").append(' ');
        sb.append("DELAY").append(' ').append(delay);
        if (millis) {
            sb.append(' ').append("MILLIS");
        }
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("BACKUP");
        sb.append(' ').append("INCREMENT").append(' ');
        sb.append("TRUE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("SIZE").append(' ');
        sb.append(this.propCacheMaxSize / 1024L);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CACHE");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.propCacheMaxRows);
        list.add(sb.toString());
        int fileScale = this.propDataFileScale;
        if (!indexRoots && fileScale < 32) {
            fileScale = 32;
        }
        sb.setLength(0);
        sb.append("SET FILES ").append("SCALE");
        sb.append(' ').append(fileScale);
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propDataFileSpace != 0) {
            sb.append("SET FILES ").append("SPACE").append(' ');
            sb.append(this.propDataFileSpace);
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET FILES ").append("LOB").append(' ');
        sb.append("SCALE");
        sb.append(' ').append(this.getLobFileScale());
        list.add(sb.toString());
        sb.setLength(0);
        if (this.propCompressLobs) {
            sb.append("SET FILES ").append("LOB").append(' ');
            sb.append("COMPRESSED").append(' ');
            sb.append(this.propCompressLobs ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
        }
        sb.append("SET FILES ").append("DEFRAG").append(' ');
        sb.append(this.propDataFileDefragLimit);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO").append(' ');
        sb.append(this.propNioDataFile ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("NIO").append(' ');
        sb.append("SIZE").append(' ');
        sb.append(this.propNioMaxSize / 0x100000L);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append(this.propLogData ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("LOG").append(' ');
        sb.append("SIZE").append(' ').append(this.propLogSize);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET FILES ").append("CHECK").append(' ');
        sb.append(this.propFilesTimestamp);
        list.add(sb.toString());
        sb.setLength(0);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String destPath, boolean script, boolean blocking, boolean compressed, boolean files) {
        block11: {
            if (!this.backupState.compareAndSet(0, 1)) {
                throw Error.error(470, "backup in progress");
            }
            if (blocking) {
                this.database.lobManager.lock();
                try {
                    Logger logger = this;
                    synchronized (logger) {
                        this.backupInternal(destPath, script, blocking, compressed, files);
                        break block11;
                    }
                }
                finally {
                    this.backupState.set(0);
                    this.database.lobManager.unlock();
                }
            }
            try {
                this.backupInternal(destPath, script, blocking, compressed, files);
            }
            finally {
                this.backupState.set(0);
            }
        }
    }

    void backupInternal(String destPath, boolean script, boolean blocking, boolean compressed, boolean asFiles) {
        block28: {
            File archiveFile;
            boolean generateName;
            String scriptName = null;
            String dbPath = this.database.getPath();
            String instanceName = new File(dbPath).getName();
            char lastChar = destPath.charAt(destPath.length() - 1);
            boolean bl = generateName = lastChar == '/' || lastChar == runtimeFileDelim;
            if (asFiles) {
                if (!generateName) {
                    throw Error.error(null, 462, 0, new String[]{"", "/"});
                }
                if ((destPath = this.getSecurePath(destPath, true, false)) == null) {
                    throw Error.error(470, "access to directory denied");
                }
                archiveFile = new File(destPath);
                archiveFile.mkdirs();
                File[] files = FileUtil.getDatabaseMainFileList(destPath + instanceName);
                if (files == null || files.length != 0) {
                    throw Error.error(470, "files exist in directory");
                }
            } else {
                boolean nameImpliesCompress;
                String defaultSuffix = compressed ? ".tar.gz" : ".tar";
                archiveFile = generateName ? new File(destPath.substring(0, destPath.length() - 1), instanceName + '-' + this.fileDateFormat.format(new Date()) + defaultSuffix) : new File(destPath);
                boolean bl2 = nameImpliesCompress = archiveFile.getName().endsWith(".tar.gz") || archiveFile.getName().endsWith(".tgz");
                if (!nameImpliesCompress && !archiveFile.getName().endsWith(".tar")) {
                    throw Error.error(null, 462, 0, new String[]{archiveFile.getName(), ".tar, .tar.gz, .tgz"});
                }
                if (compressed != nameImpliesCompress) {
                    throw Error.error(null, 463, 0, new String[]{String.valueOf(compressed), archiveFile.getName()});
                }
                if (archiveFile.exists()) {
                    throw Error.error(470, "file exists :" + archiveFile.getName());
                }
            }
            if (blocking) {
                this.log.checkpointClose();
            }
            try {
                this.logInfoEvent("Initiating backup of instance '" + instanceName + "'");
                if (script) {
                    String path = this.getTempDirectoryPath();
                    if (path == null) {
                        return;
                    }
                    path = path + "/" + new File(this.database.getPath()).getName();
                    scriptName = path + scriptFileExtension;
                    ScriptWriterText dsw = new ScriptWriterText(this.database, scriptName, true, true, true);
                    dsw.writeAll();
                    dsw.close();
                    this.backup = new DbBackup(archiveFile, path, true);
                    this.backup.write();
                } else {
                    this.backup = new DbBackup(archiveFile, dbPath);
                    this.backup.setAbortUponModify(false);
                    if (!blocking) {
                        long fileLength;
                        InputStreamWrapper isw;
                        File file = null;
                        if (this.hasCache()) {
                            DataFileCache dataFileCache = this.getCache();
                            RAShadowFile shadowFile = dataFileCache.getShadowFile();
                            file = new File(dataFileCache.dataFileName);
                            isw = new InputStreamWrapper(new FileInputStream(file));
                            isw.setSizeLimit(dataFileCache.fileStartFreePosition);
                            this.backup.setStream(dataFileExtension, isw);
                            InputStreamInterface isi = shadowFile.getInputStream();
                            this.backup.setStream(backupFileExtension, isi);
                        }
                        if ((fileLength = (file = new File(this.log.getLogFileName())).length()) == 0L) {
                            this.backup.setFileIgnore(logFileExtension);
                        } else {
                            isw = new InputStreamWrapper(new FileInputStream(file));
                            isw.setSizeLimit(fileLength);
                            this.backup.setStream(logFileExtension, isw);
                        }
                    }
                    if (asFiles) {
                        this.backup.writeAsFiles();
                    } else {
                        this.backup.write();
                    }
                }
                this.logInfoEvent("Successfully backed up instance '" + instanceName + "' to '" + destPath + "'");
                if (scriptName == null) break block28;
                FileUtil.getFileUtil().delete(scriptName);
            }
            catch (IOException ioe) {
                throw Error.error(ioe, 452, ioe.toString());
            }
            catch (TarMalformatException tme) {
                throw Error.error(tme, 452, tme.toString());
            }
            finally {
                if (scriptName != null) {
                    FileUtil.getFileUtil().delete(scriptName);
                }
                if (blocking) {
                    this.log.checkpointReopen();
                }
            }
        }
        if (blocking) {
            this.log.checkpointReopen();
        }
    }

    public String getSecurePath(String path, boolean allowFull, boolean includeRes) {
        if (this.database.getType() == DatabaseType.DB_RES) {
            if (includeRes) {
                return path;
            }
            return null;
        }
        if (this.database.getType() == DatabaseType.DB_MEM) {
            if (this.propTextAllowFullPath) {
                return path;
            }
            return null;
        }
        if (path.startsWith("/") || path.startsWith("\\") || path.contains(":")) {
            if (allowFull || this.propTextAllowFullPath) {
                return path;
            }
            return null;
        }
        if (path.contains("..") && !allowFull && !this.propTextAllowFullPath) {
            return null;
        }
        String fullPath = new File(new File(this.database.getPath() + propertiesFileExtension).getAbsolutePath()).getParent();
        if (fullPath != null) {
            path = fullPath + File.separator + path;
        }
        return path;
    }

    public boolean isNewDatabase() {
        return this.isNewDatabase;
    }
}

