/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.TableBase;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.TableSpaceManager;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private Database database;
    private AtomicLong persistentStoreIdSequence = new AtomicLong();
    private final LongKeyHashMap rowStoreMap = new LongKeyHashMap();

    public PersistentStoreCollectionDatabase(Database db) {
        this.database = db;
    }

    @Override
    public synchronized PersistentStore getStore(TableBase table) {
        long persistenceId = table.getPersistenceId();
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(persistenceId);
        if (store == null) {
            store = this.database.logger.newStore(null, this, table);
            this.rowStoreMap.put(persistenceId, store);
            table.store = store;
        }
        return store;
    }

    public synchronized void setStore(TableBase table, PersistentStore store) {
        this.rowStoreMap.put(table.getPersistenceId(), store);
        table.store = store;
    }

    @Override
    public void release() {
        if (this.rowStoreMap.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMap.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMap.clear();
    }

    @Override
    public synchronized void removeStore(TableBase table) {
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(table.getPersistenceId());
        if (store != null) {
            store.removeAll();
            store.release();
            this.rowStoreMap.remove(table.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence.getAndIncrement();
    }

    public void setNewTableSpaces() {
        DataFileCache dataCache = this.database.logger.getCache();
        if (dataCache == null) {
            return;
        }
        Iterator it = this.rowStoreMap.values().iterator();
        while (it.hasNext()) {
            TableBase table;
            PersistentStore store = (PersistentStore)it.next();
            if (store == null || (table = store.getTable()).getTableType() != 5) continue;
            TableSpaceManager tableSpace = dataCache.spaceManager.getTableSpace(table.getSpaceID());
            store.setSpaceManager(tableSpace);
        }
    }
}

