/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFileInJar
implements RandomAccessInterface {
    DataInputStream file;
    final String fileName;
    long fileLength;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferOffset;
    long seekPosition;
    long realPosition;

    RAFileInJar(String name) throws FileNotFoundException, IOException {
        this.fileName = name;
        this.fileLength = this.getLength();
        this.resetStream();
    }

    @Override
    public long length() {
        return this.fileLength;
    }

    @Override
    public void seek(long position) {
        this.seekPosition = position;
    }

    @Override
    public long getFilePointer() {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long filePos = this.seekPosition;
        this.bufferDirty = false;
        long subOffset = filePos % (long)this.buffer.length;
        long readLength = this.fileLength - (filePos - subOffset);
        if (readLength <= 0L) {
            throw new IOException("read beyond end of file");
        }
        if (readLength > (long)this.buffer.length) {
            readLength = this.buffer.length;
        }
        this.fileSeek(filePos - subOffset);
        this.file.readFully(this.buffer, 0, (int)readLength);
        this.bufferOffset = filePos - subOffset;
        this.realPosition = this.bufferOffset + readLength;
    }

    @Override
    public int read() throws IOException {
        if (this.seekPosition >= this.fileLength) {
            return -1;
        }
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int val = this.ba.read();
        ++this.seekPosition;
        return val;
    }

    @Override
    public long readLong() throws IOException {
        long hi = this.readInt();
        long lo = this.readInt();
        return (hi << 32) + (lo & 0xFFFFFFFFL);
    }

    @Override
    public int readInt() throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int val = this.ba.readInt();
        this.seekPosition += 4L;
        return val;
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int bytesRead = this.ba.read(b, offset, length);
        this.seekPosition += (long)bytesRead;
        if (bytesRead < length) {
            if (this.seekPosition != this.realPosition) {
                this.fileSeek(this.seekPosition);
            }
            this.file.readFully(b, offset + bytesRead, length - bytesRead);
            this.seekPosition += (long)(length - bytesRead);
            this.realPosition = this.seekPosition;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
    }

    @Override
    public void writeInt(int i) {
    }

    @Override
    public void writeLong(long i) {
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private long getLength() throws IOException {
        int count = 0;
        this.resetStream();
        while (this.file.read() >= 0) {
            ++count;
        }
        return count;
    }

    private void resetStream() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        InputStream fis = null;
        try {
            ClassLoader cl;
            fis = this.getClass().getResourceAsStream(this.fileName);
            if (fis == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                fis = cl.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (fis == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.file = new DataInputStream(fis);
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition = this.realPosition;
        if (position < skipPosition) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.file.skip(position - skipPosition);
        }
    }

    @Override
    public boolean ensureLength(long newLong) {
        return true;
    }

    @Override
    public boolean setLength(long newLength) {
        return false;
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
    }
}

