/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;
    final EventLogInterface logger;

    RAFileSimple(EventLogInterface logger, String name, String openMode) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(name, openMode);
        this.logger = logger;
        this.readOnly = openMode.equals("r");
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long position) throws IOException {
        this.file.seek(position);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        this.file.readFully(b, offset, length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.file.write(b, off, len);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.file.writeInt(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.file.writeLong(i);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long newLength) {
        try {
            if (!this.readOnly && this.file.length() < newLength) {
                this.file.seek(newLength - 1L);
                this.file.writeByte(0);
            }
        }
        catch (IOException e) {
            this.logger.logWarningEvent("data file enlarge failed ", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long newLength) {
        try {
            this.file.setLength(newLength);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (Throwable t) {
            try {
                this.file.getFD().sync();
            }
            catch (Throwable tt) {
                this.logger.logSevereEvent("RA file sync error ", t);
                throw Error.error(t, 452, null);
            }
        }
    }
}

