/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Date;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.scriptio.ScriptWriterText;

public class RowInsertSimple
implements RowInsertInterface {
    final Session session;
    final RowInsertInterface.ErrorLogger callback;
    final int mode;

    public RowInsertSimple(Session session, RowInsertInterface.ErrorLogger callback, int mode) {
        this.session = session;
        this.callback = callback;
        this.mode = mode;
    }

    @Override
    public void finishTable() {
    }

    @Override
    public void close() {
        this.callback.close();
    }

    @Override
    public long getErrorLineNumber() {
        return 0L;
    }

    @Override
    public void insert(Table table, PersistentStore store, Object[] rowData) {
        table.insertFromScript(this.session, store, rowData);
    }

    @Override
    public void setStartLineNumber(long number) {
    }

    public static class DefaultErrorHandler
    implements RowInsertInterface.ErrorLogger {
        @Override
        public void writeLogStatement(long lineNumber, String s) {
        }

        @Override
        public void writeRow(long lineNumber, Row row) {
        }

        @Override
        public void close() {
        }
    }

    public static class InsertErrorHandler
    implements RowInsertInterface.ErrorLogger {
        Database database;
        String fileNamePath;
        ScriptWriterText scrwriter;

        public InsertErrorHandler(Database database, String fileNamePath) {
            this.database = database;
            this.fileNamePath = fileNamePath;
        }

        @Override
        public void writeLogStatement(long lineNumber, String s) {
            this.setScrWriter();
            try {
                this.scrwriter.writeLogStatement(null, s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void writeRow(long lineNumber, Row row) {
            this.setScrWriter();
            try {
                this.scrwriter.writeInsertStatement(null, row, (Table)row.getTable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void close() {
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
        }

        private void setScrWriter() {
            if (this.scrwriter == null) {
                String timestamp = this.database.logger.fileDateFormat.format(new Date());
                String name = this.fileNamePath + "." + timestamp + ".reject";
                this.scrwriter = new ScriptWriterText(this.database, name, false, false, true);
            }
        }
    }
}

