/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInsertVersioning
implements RowInsertInterface {
    final Session session;
    final RowInsertInterface.ErrorLogger callback;
    final int mode;
    RowSetNavigatorClient rowSet = new RowSetNavigatorClient(64);
    Table table = null;
    PersistentStore store;
    Index index = null;

    public RowInsertVersioning(Session session, RowInsertInterface.ErrorLogger callback, int mode) {
        this.session = session;
        this.callback = callback;
        this.mode = mode;
    }

    @Override
    public void finishTable() {
        this.applyChangeSet();
    }

    @Override
    public void close() {
        this.callback.close();
    }

    @Override
    public long getErrorLineNumber() {
        return 0L;
    }

    @Override
    public void insert(Table table, PersistentStore store, Object[] rowData) {
        if (this.table != table) {
            this.resetTable(table, store);
        }
        if (this.isSameRowSet(rowData)) {
            this.rowSet.add(rowData);
        } else {
            this.applyChangeSet();
            this.rowSet.add(rowData);
        }
    }

    @Override
    public void setStartLineNumber(long number) {
    }

    boolean isSameRowSet(Object[] rowData) {
        if (this.rowSet.isEmpty()) {
            return true;
        }
        return this.index.compareRow(this.session, rowData, this.rowSet.getData(0)) == 0;
    }

    void applyChangeSet() {
        Object[] newData;
        if (this.rowSet.getSize() == 0) {
            return;
        }
        int startNewRow = 0;
        RowIterator it = this.index.findFirstRow(this.session, this.store, this.rowSet.getData(0));
        boolean reportFailed = false;
        Row currentRow = null;
        while (it.next() && this.isSameRowSet(it.getCurrent())) {
            currentRow = it.getCurrentRow();
            TimestampData ts = currentRow.getSystemStartVersion();
            int compare = this.compareColumn(ts, newData = this.rowSet.getData(startNewRow), this.table.getSystemPeriodStartIndex());
            if (compare < 0) {
                ts = currentRow.getSystemEndVersion();
                compare = this.compareColumn(ts, newData, this.table.getSystemPeriodStartIndex());
                if (compare <= 0) continue;
                reportFailed = true;
                break;
            }
            if (compare > 0) {
                reportFailed = true;
                break;
            }
            ts = currentRow.getSystemEndVersion();
            compare = this.compareColumn(ts, newData, this.table.getSystemPeriodEndIndex());
            if (compare == 0) {
                ++startNewRow;
                continue;
            }
            if (ts.getSeconds() != DateTimeType.epochLimitSeconds) continue;
            it.removeCurrent();
            break;
        }
        if (reportFailed) {
            for (int i = startNewRow; i < this.rowSet.getSize(); ++i) {
                newData = this.rowSet.getData(i);
                Row newRow = new Row(this.table, newData);
                this.callback.writeRow(0L, newRow);
            }
        } else {
            for (int i = startNewRow; i < this.rowSet.getSize(); ++i) {
                newData = this.rowSet.getData(i);
                this.table.insertFromScript(this.session, this.store, newData);
            }
        }
        this.rowSet.clear();
    }

    void resetTable(Table newTable, PersistentStore newStore) {
        this.table = newTable;
        this.store = newStore;
        this.index = newTable.getPrimaryIndex();
    }

    int compareColumn(TimestampData ts, Object[] data, int colIndex) {
        return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.compare(this.session, ts, data[colIndex]);
    }
}

