/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLCheck;
import org.hsqldb.index.IndexStats;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    Database database;
    TableSpaceManager tableSpace;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    long baseElementCount;
    AtomicLong elementCount = new AtomicLong();
    long storageSize;
    boolean[] nullsList;
    double[][] searchCost;
    boolean isSchemaStore;
    public LongKeyHashMap rowActionMap;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    @Override
    public boolean isRowStore() {
        return true;
    }

    public boolean isRowSet() {
        return false;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public abstract boolean isMemory();

    @Override
    public void setMemory(boolean mode) {
    }

    @Override
    public abstract CachedObject get(long var1, boolean var3);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    public int compare(Session session, long key) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract void add(Session var1, CachedObject var2, boolean var3);

    @Override
    public final void add(CachedObject object, boolean keep) {
    }

    @Override
    public boolean canRead(Session session, long pos, int mode, int[] colMap) {
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject object, int mode, int[] colMap) {
        RowAction action = ((Row)object).rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public CachedObject get(CachedObject object, RowInputInterface in) {
        return object;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public int getDefaultObjectSize() {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(CachedObject var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteActionToRow(Session session, Row row, int[] colMap, boolean isMV) {
        Row row2 = row;
        synchronized (row2) {
            return RowAction.addDeleteAction(session, this.table, this, row, colMap);
        }
    }

    @Override
    public abstract DataFileCache getCache();

    @Override
    public TableSpaceManager getSpaceManager() {
        return this.tableSpace;
    }

    @Override
    public void setSpaceManager(TableSpaceManager manager) {
        this.tableSpace = manager;
    }

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        this.writeLock();
        try {
            int i;
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            for (i = 0; i < this.subStores.length; ++i) {
                this.subStores[i].delete(session, row);
            }
            row.delete(this);
            long count = this.elementCount.decrementAndGet();
            if (count > 16384L && count < this.baseElementCount / 2L) {
                this.baseElementCount = count;
                this.searchCost = null;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        int i;
        this.writeLock();
        try {
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
            int j = 0;
            try {
                for (j = 0; j < this.subStores.length; ++j) {
                    this.subStores[j].indexRow(session, row);
                }
            }
            catch (HsqlException e) {
                int count = j;
                for (j = 0; j < count; ++j) {
                    this.subStores[j].delete(session, row);
                }
                throw e;
            }
            long count = this.elementCount.incrementAndGet();
            if (count > 16384L && count > this.baseElementCount * 2L) {
                this.baseElementCount = count;
                this.searchCost = null;
            }
        }
        catch (HsqlException e) {
            int count = i;
            for (i = 0; i < count; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            if (this.rowActionMap != null) {
                this.rowActionMap.remove(row.getPos());
            }
            this.remove(row);
            throw e;
        }
        catch (Throwable t) {
            int count = i;
            for (i = 0; i < count; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            if (this.rowActionMap != null) {
                this.rowActionMap.remove(row.getPos());
            }
            throw Error.error(458, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public abstract void commitRow(Session var1, Row var2, int var3, int var4);

    @Override
    public abstract void rollbackRow(Session var1, Row var2, int var3, int var4);

    @Override
    public abstract void postCommitAction(Session var1, RowAction var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void indexRows(Session session) {
        this.writeLock();
        try {
            for (int i = 1; i < this.indexList.length; ++i) {
                this.setAccessor(this.indexList[i], null);
            }
            RowIterator it = this.rowIterator();
            while (it.next()) {
                Row row = it.getCurrentRow();
                ((RowAVL)row).clearNonPrimaryNodes();
                for (int i = 1; i < this.indexList.length; ++i) {
                    this.indexList[i].insert(session, this, row);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            index = this.indexList[i];
            break;
        }
        return index.firstRow(this);
    }

    @Override
    public void setAccessors(long base, long[] accessors, long cardinality) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        this.accessorList[key.getPosition()] = accessor;
    }

    @Override
    public void setAccessor(Index key, long accessor) {
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] keys) {
        int position;
        this.searchCost = null;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == keys) {
            return;
        }
        Index[] oldIndexList = this.indexList;
        CachedObject[] oldAccessors = this.accessorList;
        int limit = this.indexList.length;
        int diff = keys.length - this.indexList.length;
        if (diff < -1) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        if (diff == -1) {
            limit = keys.length;
        } else {
            if (diff == 0) {
                return;
            }
            if (diff != 1) {
                for (position = 0; position < limit && this.indexList[position] == keys[position]; ++position) {
                }
                Index[] tempKeys = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, position, 1);
                tempKeys[position] = keys[position];
                this.resetAccessorKeys(session, tempKeys);
                this.resetAccessorKeys(session, keys);
                return;
            }
        }
        while (position < limit && this.indexList[position] == keys[position]) {
            ++position;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, position, diff);
        this.indexList = keys;
        try {
            if (diff > 0) {
                this.insertIndexNodes(session, this.indexList[0], this.indexList[position]);
            } else {
                this.dropIndexFromRows(this.indexList[0], oldIndexList[position]);
            }
        }
        catch (HsqlException e) {
            this.accessorList = oldAccessors;
            this.indexList = oldIndexList;
            throw e;
        }
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double searchCost(Session session, Index index, int count, int opType) {
        if (count == 0) {
            return this.elementCount.get();
        }
        if (opType != 40) {
            return (double)this.elementCount.get() / 2.0;
        }
        if (index.isUnique() && count == index.getColumnCount()) {
            return 1.0;
        }
        int position = index.getPosition();
        RowStoreAVL rowStoreAVL = this;
        synchronized (rowStoreAVL) {
            if (this.searchCost == null || this.searchCost.length != this.indexList.length) {
                this.searchCost = new double[this.indexList.length][];
            }
            if (this.searchCost[position] == null) {
                this.searchCost[position] = this.indexList[position].searchCost(session, this);
            }
            return this.searchCost[index.getPosition()][count - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.readLock();
            try {
                long count = index.size(null, this);
                this.elementCount.set(count);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.elementCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elementCount(Session session) {
        if (session == null) {
            return this.elementCount();
        }
        Index index = this.indexList[0];
        if (session.database.txManager.isMVRows()) {
            switch (this.table.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    this.readLock();
                    try {
                        long l = index.size(session, this);
                        return l;
                    }
                    finally {
                        this.readUnlock();
                    }
                }
            }
        }
        return this.elementCount();
    }

    @Override
    public long elementCountUnique(Index index) {
        return 0L;
    }

    final void setElementCount(long size) {
        this.elementCount.set(size);
    }

    @Override
    public boolean hasNull(int pos) {
        return false;
    }

    @Override
    public final void moveData(Session session, PersistentStore other, int[] colIndex, int adjust) {
        try {
            Row row;
            Type type;
            Object[] data;
            Table table = (Table)this.table;
            RowIterator it = other.rowIterator();
            while (it.next()) {
                Row row2 = it.getCurrentRow();
                Object[] olddata = row2.getData();
                data = table.getEmptyRowData();
                ArrayUtil.copyAdjustArray(olddata, data, colIndex, adjust);
                for (int i = 0; i < colIndex.length; ++i) {
                    Object value;
                    if (adjust == 0) {
                        Object value2;
                        Type oldtype = other.getTable().getColumnTypes()[colIndex[i]];
                        Type newtype = this.table.getColumnTypes()[colIndex[i]];
                        Object oldvalue = olddata[colIndex[i]];
                        data[colIndex[i]] = value2 = newtype.convertToType(session, oldvalue, oldtype);
                        table.systemSetIdentityColumn(session, data);
                        continue;
                    }
                    if (adjust <= 0) continue;
                    ColumnSchema column = table.getColumn(colIndex[i]);
                    data[colIndex[i]] = value = table.getColumnDefaultOrGeneratedValue(session, column, data);
                    table.systemSetIdentityColumn(session, data);
                }
                table.enforceRowConstraints(session, data);
                Row newrow = (Row)this.getNewCachedObject(session, data, false);
                this.indexRow(session, newrow);
            }
            if (table.isTemp()) {
                return;
            }
            if (colIndex.length == 0) {
                return;
            }
            if (adjust <= 0 && (type = other.getTable().getColumnTypes()[colIndex[0]]) != null && type.isLobType()) {
                it = other.rowIterator();
                while (it.next()) {
                    row = it.getCurrentRow();
                    Object[] olddata = row.getData();
                    LobData oldvalue = (LobData)olddata[colIndex[0]];
                    if (oldvalue == null) continue;
                    session.sessionData.adjustLobUsageCount(oldvalue, -1);
                }
            }
            if (adjust >= 0 && (type = this.table.getColumnTypes()[colIndex[0]]) != null && type.isLobType()) {
                it = this.rowIterator();
                while (it.next()) {
                    row = it.getCurrentRow();
                    data = row.getData();
                    LobData value = (LobData)data[colIndex[0]];
                    if (value == null) continue;
                    session.sessionData.adjustLobUsageCount(value, 1);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw Error.error(460, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindex(Session session, Index index, Index useIndex) {
        this.writeLock();
        try {
            RowIterator it = useIndex == null ? this.table.rowIterator(this) : useIndex.firstRow(this);
            this.setAccessor(index, null);
            while (it.next()) {
                RowAVL row = (RowAVL)it.getCurrentRow();
                row.getNode(index.getPosition()).delete();
                index.insert(session, this, row);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public IndexStats[] checkIndexes(Session session, int mode) {
        IndexStats[] indexStats = new IndexStats[this.accessorList.length];
        for (int i = 0; i < this.indexList.length; ++i) {
            IndexAVL index = (IndexAVL)this.indexList[i];
            NodeAVL node = (NodeAVL)this.accessorList[i];
            IndexAVLCheck.IndexAVLProbe probe = new IndexAVLCheck.IndexAVLProbe(session, this, index, node);
            probe.probe();
            indexStats[i] = probe.getStats();
        }
        return indexStats;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    void dropIndexFromRows(Index primaryIndex, Index oldIndex) {
        RowIterator it = primaryIndex.firstRow(this);
        int position = oldIndex.getPosition() - 1;
        while (it.next()) {
            Row row = it.getCurrentRow();
            int i = position;
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        it.release();
    }

    /*
     * Exception decompiling
     */
    boolean insertIndexNodes(Session session, Index primaryIndex, Index newIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void destroyIndexes() {
        if (this.indexList.length == 0) {
            return;
        }
        IndexAVL idx = (IndexAVL)this.indexList[0];
        NodeAVL root = (NodeAVL)this.accessorList[0];
        idx.unlinkNodes(this, root);
    }
}

