/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAVLDiskLarge;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;
    boolean largeData;

    public RowStoreAVLDisk(DataFileCache cache, Table table) {
        this.table = table;
        this.database = table.database;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = cache;
        this.rowOut = cache.rowOut.duplicate();
        this.largeData = this.database.logger.getDataFileFactor() > 1;
        cache.adjustStoreCount(1);
        this.rowActionMap = new LongKeyHashMap(8);
        this.largeData = this.database.logger.propLargeData;
        this.tableSpace = cache.spaceManager.getTableSpace(table.getSpaceID());
        this.lock = new ReentrantReadWriteLock(true);
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    private void set(CachedObject object) {
        RowAction action;
        if (this.database.txManager.isMVRows() && (action = (RowAction)this.rowActionMap.get(object.getPos())) != null) {
            ((Row)object).rowAction = action;
        }
    }

    @Override
    public CachedObject get(long key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    public CachedObject get(long key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, false);
        return object;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public void add(Session session, CachedObject object, boolean tx) {
        int size = object.getRealSize(this.rowOut);
        size += this.indexList.length * 16;
        size = this.rowOut.getStorageSize(size);
        object.setStorageSize(size);
        long pos = this.tableSpace.getFilePosition(size);
        object.setPos(pos);
        if (tx) {
            RowAction action = RowAction.addInsertAction(session, this.table, this, (Row)object);
            if (this.database.txManager.isMVRows()) {
                this.rowActionMap.put(object.getPos(), action);
            }
        }
        this.cache.add(object, false);
        this.storageSize += (long)size;
    }

    @Override
    public boolean canRead(Session session, long pos, int mode, int[] colMap) {
        if (this.database.txManager.isMVRows()) {
            RowAction action = (RowAction)this.rowActionMap.get(pos);
            if (action == null) {
                return true;
            }
            return action.canRead(session, mode);
        }
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject object, int mode, int[] colMap) {
        RowAction action = ((Row)object).rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        RowAVLDisk row = this.largeData ? new RowAVLDiskLarge(this, in) : new RowAVLDisk(this, in);
        this.set(row);
        return row;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDisk row = this.largeData ? new RowAVLDiskLarge(this.table, (Object[])object, this) : new RowAVLDisk(this.table, (Object[])object, this);
        this.add(session, row, tx);
        return row;
    }

    @Override
    public void delete(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.delete(session, row);
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void removeAll() {
        if (this.cache.spaceManager.isMultiSpace()) {
            if (this.tableSpace.isDefaultSpace()) {
                DoubleLongIndex pointerLookup = this.getPointerList();
                this.removeDefaultSpaces(pointerLookup);
            } else {
                this.cache.spaceManager.freeTableSpace(this.tableSpace.getSpaceID());
            }
        }
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject object) {
        this.cache.remove(object);
        this.tableSpace.release(object.getPos(), object.getStorageSize());
        this.storageSize -= (long)object.getStorageSize();
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postCommitAction(Session session, RowAction action) {
        if (action.getType() == 0) {
            Lock mapLock = this.rowActionMap.getWriteLock();
            mapLock.lock();
            try {
                if (action.getType() != 0) return;
                this.rowActionMap.remove(action.getPos());
                return;
            }
            finally {
                mapLock.unlock();
            }
        } else {
            if (action.getType() != 3 || action.isDeleteComplete()) return;
            action.setDeleteComplete();
            Row row = action.getRow();
            this.delete(session, row);
            this.rowActionMap.remove(row.getPos());
            this.remove(row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, data);
                if (txModel != 0) break;
                this.remove(row);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row);
                break;
            }
            case 3: {
                this.delete(session, row);
                if (this.database.txManager.isMVRows()) {
                    this.rowActionMap.remove(row.getPos());
                }
                this.remove(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel == 0) {
                    row = (Row)this.get((CachedObject)row, true);
                    ((RowAVL)row).setNewNodes(this);
                    row.keepInMemory(false);
                    this.indexRow(session, row);
                    break;
                }
                RowAction ra = row.getAction();
                if (ra.getType() != 0) break;
                this.rowActionMap.remove(row.getPos());
                break;
            }
            case 1: {
                this.delete(session, row);
                if (this.database.txManager.isMVRows()) {
                    this.rowActionMap.remove(row.getPos());
                }
                this.remove(row);
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.rowActionMap.remove(row.getPos());
                this.remove(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteActionToRow(Session session, Row row, int[] colMap, boolean isMV) {
        RowAction action = null;
        if (!isMV) {
            Row row2 = row;
            synchronized (row2) {
                return RowAction.addDeleteAction(session, this.table, this, row, colMap);
            }
        }
        row = (Row)this.cache.get(row, (PersistentStore)this, true);
        Lock mapLock = this.rowActionMap.getWriteLock();
        mapLock.lock();
        try {
            action = RowAction.addDeleteAction(session, this.table, this, row, colMap);
            if (action != null) {
                this.rowActionMap.put(action.getPos(), action);
            }
        }
        finally {
            mapLock.unlock();
            row.keepInMemory(false);
        }
        return action;
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void release() {
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVLDisk");
        }
        NodeAVL node = (NodeAVL)this.accessorList[position];
        if (node == null) {
            return null;
        }
        RowAVL row = (RowAVL)this.get((CachedObject)node.getRow(this), false);
        node = row.getNode(key.getPosition());
        this.accessorList[key.getPosition()] = node;
        return node;
    }

    @Override
    public void setAccessors(long base, long[] accessors, long cardinality) {
        for (int index = 0; index < this.indexList.length; ++index) {
            this.setAccessor(this.indexList[index], accessors[index]);
        }
        this.setElementCount(cardinality);
    }

    @Override
    public void setAccessor(Index key, long accessor) {
        CachedObject object = this.get(accessor, false);
        if (object != null) {
            NodeAVL node = ((RowAVL)object).getNode(key.getPosition());
            object = node;
        }
        this.setAccessor(key, object);
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    public void setSpaceManager(Session session) {
        if (this.table.getSpaceID() == 7) {
            return;
        }
        TableSpaceManager tableSpace = this.cache.spaceManager.getTableSpace(this.table.getSpaceID());
        this.setSpaceManager(tableSpace);
        this.moveDataToSpace(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToSpace(Session session) {
        Table table = (Table)this.table;
        long rowCount = this.elementCount();
        if (rowCount == 0L) {
            return;
        }
        if (rowCount > Integer.MAX_VALUE) {
            return;
        }
        this.writeLock();
        try {
            DoubleLongIndex pointerLookup = this.getPointerList();
            LongLookup removeList = pointerLookup.duplicate();
            this.moveDataToNewSpace(this.cache, pointerLookup);
            CachedObject[] newAccessorList = new CachedObject[this.accessorList.length];
            for (int i = 0; i < this.accessorList.length; ++i) {
                Index key = this.indexList[i];
                long pos = pointerLookup.lookup(this.accessorList[i].getPos());
                RowAVL row = (RowAVL)this.cache.get(pos, (PersistentStore)this, false);
                NodeAVL node = row.getNode(key.getPosition());
                newAccessorList[key.getPosition()] = node;
            }
            this.removeDefaultSpaces(removeList);
            this.accessorList = newAccessorList;
        }
        finally {
            this.writeUnlock();
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
    }

    public void moveDataToSpace(DataFileCache targetCache, LongLookup pointerLookup) {
        this.populatePointerList(pointerLookup);
        this.moveDataToNewSpace(targetCache, pointerLookup);
    }

    private DoubleLongIndex getPointerList() {
        DoubleLongIndex pointerLookup = new DoubleLongIndex((int)this.elementCount());
        this.populatePointerList(pointerLookup);
        return pointerLookup;
    }

    private void populatePointerList(LongLookup pointerLookup) {
        RowIterator it = this.indexList[0].firstRow(this);
        while (it.next()) {
            Row row = it.getCurrentRow();
            pointerLookup.addUnsorted(row.getPos(), row.getStorageSize());
        }
        pointerLookup.sort();
    }

    private void moveDataToNewSpace(DataFileCache targetCache, LongLookup pointerLookup) {
        int spaceId = this.table.getSpaceID();
        TableSpaceManager targetSpace = targetCache.spaceManager.getTableSpace(spaceId);
        for (int i = 0; i < pointerLookup.size(); ++i) {
            long newPos = targetSpace.getFilePosition((int)pointerLookup.getLongValue(i));
            pointerLookup.setLongValue(i, newPos);
        }
        RowIterator it = this.indexList[0].firstRow(this);
        while (it.next()) {
            Row row = it.getCurrentRow();
            long newPos = pointerLookup.lookup(row.getPos());
            targetCache.rowOut.reset();
            row.write(targetCache.rowOut, pointerLookup);
            targetCache.saveRowOutput(newPos);
        }
    }

    private void removeDefaultSpaces(LongLookup removeList) {
        DataSpaceManager manager = this.cache.spaceManager;
        int scale = this.cache.getDataFileScale();
        for (int i = 0; i < removeList.size(); ++i) {
            long pos = removeList.getLongKey(i);
            long size = removeList.getLongValue(i) / (long)scale;
            removeList.setLongValue(i, size);
            this.cache.release(pos);
        }
        removeList.compactLookupAsIntervals();
        manager.freeTableSpace(7, removeList, 0L, 0L);
    }

    long getStorageSizeEstimate() {
        if (this.elementCount.get() == 0L) {
            return 0L;
        }
        CachedObject accessor = this.getAccessor(this.indexList[0]);
        CachedObject row = this.get(accessor.getPos(), false);
        return (long)row.getStorageSize() * this.elementCount.get();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

