/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVL {
    TextCache cache;
    RowOutputInterface rowOut;
    AtomicInteger accessCount;

    public RowStoreAVLDiskData(Table table) {
        this.database = table.database;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    public Object[] getData(RowAVLDiskData row) {
        this.cache.writeLock.lock();
        try {
            this.cache.get(row, (PersistentStore)this, false);
            Object[] objectArray = row.getData();
            return objectArray;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    public int getNextAccessCount() {
        return this.accessCount.incrementAndGet();
    }

    @Override
    public CachedObject get(long key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, CachedObject object, boolean tx) {
        this.cache.writeLock.lock();
        try {
            int size = object.getRealSize(this.rowOut);
            object.setStorageSize(size);
            long pos = this.tableSpace.getFilePosition(size);
            object.setPos(pos);
            if (tx) {
                RowAction.addInsertAction(session, this.table, this, (Row)object);
            }
            this.cache.add(object, false);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        RowAVLDiskData row = new RowAVLDiskData(this, this.table, in);
        this.cache.cache.put(row);
        return row;
    }

    @Override
    public CachedObject get(CachedObject object, RowInputInterface in) {
        Object[] rowData = in.readData(this.table.getColumnTypes());
        ((RowAVLDiskData)object).setData(rowData);
        return object;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDiskData row = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(session, row, tx);
        return row;
    }

    @Override
    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void removeAll() {
        this.destroyIndexes();
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject object) {
        this.cache.remove(object);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    @Override
    public void commitPersistence(CachedObject row) {
        try {
            this.cache.saveRow(row);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void postCommitAction(Session session, RowAction action) {
        if (action.getType() == 3 && !action.isDeleteComplete()) {
            action.setDeleteComplete();
            Row row = action.getRow();
            if (row == null) {
                row = (Row)this.get(action.getPos(), false);
            }
            this.delete(session, row);
            this.remove(row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.cache.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        this.cache = (TextCache)cache;
        this.tableSpace = cache.spaceManager.getTableSpace(7);
        this.accessCount = cache.getAccessCount();
        this.rowOut = cache.rowOut;
    }

    @Override
    public void release() {
        this.destroyIndexes();
        this.table.database.logger.textTableManager.closeTextCache((Table)this.table);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

