/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    Session session;
    boolean resettingAccessor = false;

    public RowStoreAVLHybridExtended(Session session, TableBase table, boolean diskBased) {
        super(session, table, diskBased);
        this.session = session;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        if (!this.resettingAccessor && this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(session, this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, tx);
    }

    @Override
    public synchronized void add(Session session, CachedObject object, boolean tx) {
        super.add(session, object, tx);
        if (tx) {
            RowAction.addInsertAction(session, this.table, this, (Row)object);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (this.isCached && row.isMemory() || count != this.indexList.length) {
            row = (Row)this.getNewCachedObject(session, row.getData(), true);
        }
        super.indexRow(session, row);
    }

    @Override
    public void delete(Session session, Row row) {
        NodeAVL node = ((RowAVL)row).getNode(0);
        int count = 0;
        while (node != null) {
            ++count;
            node = node.nNext;
        }
        if (this.isCached && row.isMemory() || count != this.indexList.length) {
            row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        }
        if (row != null) {
            super.delete(session, row);
        }
    }

    @Override
    public synchronized double searchCost(Session session, Index index, int count, int opType) {
        if (this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(session, this.table.getIndexList());
        }
        return super.searchCost(session, index, count, opType);
    }

    @Override
    public CachedObject getAccessor(Index key) {
        if (!this.resettingAccessor && key.getPosition() > 0 && this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(this.session, this.table.getIndexList());
        }
        return super.getAccessor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] keys) {
        this.resettingAccessor = true;
        try {
            if (this.indexList.length == 0 || this.accessorList[0] == null) {
                this.indexList = keys;
                this.accessorList = new CachedObject[this.indexList.length];
                return;
            }
            if (this.isCached) {
                this.resetAccessorKeysCached(keys);
            } else {
                super.resetAccessorKeys(session, keys);
            }
        }
        finally {
            this.resettingAccessor = false;
        }
    }

    private void resetAccessorKeysCached(Index[] keys) {
        RowStoreAVLHybridExtended tempStore = new RowStoreAVLHybridExtended(this.session, this.table, true);
        tempStore.changeToDiskTable(this.session);
        tempStore.indexList = this.indexList;
        tempStore.accessorList = this.accessorList;
        tempStore.elementCount.set(this.elementCount.get());
        this.indexList = keys;
        this.accessorList = new CachedObject[this.indexList.length];
        this.elementCount.set(0L);
        RowIterator iterator = tempStore.rowIterator();
        while (iterator.next()) {
            Row row = iterator.getCurrentRow();
            Row newRow = (Row)this.getNewCachedObject(this.session, row.getData(), false);
            this.indexRow(this.session, newRow);
        }
    }
}

