/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptRunner {
    public static void runScript(Database database, String logFilename, boolean fullReplay) {
        ScriptReaderText scr;
        Crypto crypto = database.logger.getCrypto();
        try {
            scr = crypto == null ? new ScriptReaderText(database, logFilename, false) : new ScriptReaderDecode(database, logFilename, crypto, true);
        }
        catch (Throwable e) {
            if (!(e instanceof EOFException)) {
                database.logger.logSevereEvent("opening log file", e);
            }
            return;
        }
        ScriptRunner.runScript(database, scr, fullReplay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(Database database, ScriptReaderBase scr, boolean fullReplay) {
        IntKeyHashMap<Session> sessionMap = new IntKeyHashMap<Session>();
        Session current = null;
        int currentId = 0;
        StatementDML dummy = new StatementDML(91, null);
        String databaseFile = database.getCanonicalPath();
        String action = fullReplay ? "open aborted" : "open continued";
        dummy.setCompileTimestamp(Long.MAX_VALUE);
        database.setReferentialIntegrity(false);
        try {
            while (scr.readLoggedStatement(current)) {
                int sessionId = scr.getSessionNumber();
                if ((current == null || currentId != sessionId) && (current = (Session)sessionMap.get(currentId = sessionId)) == null) {
                    current = database.getSessionManager().newSessionForLog(database);
                    sessionMap.put(currentId, current);
                }
                Result result = null;
                int statementType = scr.getStatementType();
                switch (statementType) {
                    case 7: {
                        result = null;
                    }
                    case 1: {
                        String statement = scr.getLoggedStatement();
                        try {
                            Statement cs = current.compileStatement(statement);
                            result = current.executeCompiledStatement(cs, ValuePool.emptyObjectArray, 0);
                        }
                        catch (Throwable e) {
                            result = Result.newErrorResult(e);
                        }
                        if (result == null || !result.isError()) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Error.error(result);
                    }
                    case 4: {
                        current.commit(false);
                        break;
                    }
                    case 3: {
                        current.sessionContext.currentStatement = dummy;
                        current.beginAction(dummy);
                        Object[] data = scr.getData();
                        scr.getCurrentTable().insertNoCheckFromLog(current, data);
                        current.endAction(Result.updateOneResult);
                        break;
                    }
                    case 2: {
                        current.sessionContext.currentStatement = dummy;
                        current.beginAction(dummy);
                        Table table = scr.getCurrentTable();
                        PersistentStore store = table.getRowStore(current);
                        Object[] data = scr.getData();
                        Row row = table.getDeleteRowFromLog(current, data);
                        if (row != null) {
                            current.addDeleteAction(table, store, row, null);
                        }
                        current.endAction(Result.updateOneResult);
                        break;
                    }
                    case 6: {
                        HsqlNameManager.HsqlName name = database.schemaManager.findSchemaHsqlName(scr.getCurrentSchema());
                        current.setCurrentSchemaHsqlName(name);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw Error.error(472);
                    }
                }
                if (!current.isClosed()) continue;
                current = null;
                sessionMap.remove(currentId);
            }
        }
        catch (HsqlException e) {
            if (e.getErrorCode() == -472) {
                throw e;
            }
            String error = "statement error processing log - " + action + " " + scr.getFileNamePath() + " line: " + scr.getLineNumber();
            database.logger.logSevereEvent(error, e);
            if (fullReplay) {
                throw Error.error(e, 472, error);
            }
        }
        catch (OutOfMemoryError e) {
            String error = "out of memory processing log - " + databaseFile + " line: " + scr.getLineNumber();
            database.logger.logSevereEvent(error, e);
            throw Error.error(460, e);
        }
        catch (Throwable t) {
            HsqlException e = Error.error(t, 472, 25, new String[]{scr.getLineNumber() + " " + databaseFile, t.getMessage()});
            String error = "statement error processing log - " + action + scr.getFileNamePath() + " line: " + scr.getLineNumber();
            database.logger.logSevereEvent(error, e);
            if (fullReplay) {
                throw e;
            }
        }
        finally {
            if (scr != null) {
                scr.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

