/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    final DataSpaceManager spaceManager;
    final int scale;
    final int fileBlockSize;
    final int spaceID;
    private DoubleIntIndex spaceList;
    private DoubleIntIndex oldList;
    private DoubleLongIndex oldLargeList;
    private final int capacity;
    private long requestGetCount;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    boolean isInitialised;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;
    long currentBlockFloor = 0L;
    long currentBlockLimit = 0L;
    int fileBlockIndex = -1;

    public TableSpaceManagerBlocks(DataSpaceManager spaceManager, int spaceId, int fileBlockSize, int capacity, int fileScale) {
        this.spaceManager = spaceManager;
        this.spaceID = spaceId;
        this.fileBlockSize = fileBlockSize;
        this.capacity = capacity;
        this.scale = fileScale;
        this.spaceList = new DoubleIntIndex(capacity, true);
        this.spaceList.setValuesSearchTarget();
        this.oldList = new DoubleIntIndex(capacity, true);
    }

    @Override
    public boolean hasFileRoom(long blockSize) {
        return this.freshBlockLimit - this.freshBlockFreePos > blockSize;
    }

    @Override
    public void addFileBlock(long blockFreePos, long blockLimit) {
        int released = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (released > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, released);
        }
        this.initialiseFileBlock(null, blockFreePos, blockLimit);
    }

    @Override
    public void initialiseFileBlock(LongLookup spaceList, long blockFreePos, long blockLimit) {
        this.isInitialised = true;
        this.freshBlockFreePos = blockFreePos;
        this.freshBlockLimit = blockLimit;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (spaceList != null) {
            ((DoubleIntIndex)spaceList).copyTo(this.spaceList);
        }
    }

    private boolean getNewMainBlock(long rowSize) {
        if (!this.isInitialised) {
            this.isInitialised = true;
            this.spaceManager.initialiseTableSpace(this);
            if (this.freshBlockFreePos + rowSize <= this.freshBlockLimit) {
                return true;
            }
        }
        long blockCount = ((long)this.fileBlockSize + rowSize) / (long)this.fileBlockSize;
        long blockSize = blockCount * (long)this.fileBlockSize;
        long position = this.spaceManager.getFileBlocks(this.spaceID, (int)blockCount);
        if (position < 0L) {
            return false;
        }
        if (position != this.freshBlockLimit) {
            long released = this.freshBlockLimit - this.freshBlockFreePos;
            if (released > 0L) {
                this.release(this.freshBlockFreePos / (long)this.scale, (int)released);
            }
            this.freshBlockFreePos = position;
            this.freshBlockLimit = position;
        }
        this.freshBlockLimit += blockSize;
        this.currentBlockFloor = this.freshBlockFreePos / (long)this.fileBlockSize * (long)(this.fileBlockSize / this.scale);
        this.currentBlockLimit = this.freshBlockLimit / (long)this.scale;
        if (this.oldList.size() + this.spaceList.size() > this.oldList.capacity()) {
            this.resetOldList();
        }
        this.oldList.addUnsorted(this.spaceList);
        this.resetOldList();
        this.spaceList.clear();
        return true;
    }

    private long getNewBlock(long rowSize) {
        boolean result;
        if (this.freshBlockFreePos + rowSize > this.freshBlockLimit && !(result = this.getNewMainBlock(rowSize))) {
            throw Error.error(468);
        }
        long position = this.freshBlockFreePos;
        this.freshBlockFreePos += rowSize;
        return position / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long pos, int rowSize) {
        int rowUnits = rowSize / this.scale;
        this.isModified = true;
        ++this.releaseCount;
        if (pos + (long)rowUnits >= Integer.MAX_VALUE) {
            if (this.oldLargeList == null) {
                this.oldLargeList = new DoubleLongIndex(this.capacity);
            }
            this.oldLargeList.addUnsorted(pos, rowUnits);
            if (this.oldLargeList.size() == this.capacity) {
                this.resetOldList();
            }
            return;
        }
        if (pos >= this.currentBlockFloor && pos < this.currentBlockLimit) {
            this.spaceList.add(pos, (long)rowUnits);
            if (this.spaceList.size() == this.capacity) {
                this.resetList(false);
            }
        } else {
            this.oldList.addUnsorted(pos, (long)rowUnits);
            if (this.oldList.size() == this.capacity) {
                this.resetOldList();
            }
        }
    }

    @Override
    public synchronized long getFilePosition(int rowSize) {
        ++this.requestGetCount;
        if (this.capacity == 0) {
            return this.getNewBlock(rowSize);
        }
        int index = -1;
        int rowUnits = rowSize / this.scale;
        if (this.spaceList.size() > 0) {
            if (this.spaceList.getValue(0) >= rowUnits) {
                index = 0;
            } else {
                index = this.spaceList.findFirstGreaterEqualKeyIndex(rowUnits);
                if (index == -1) {
                    this.spaceList.compactLookupAsIntervals();
                    this.spaceList.setValuesSearchTarget();
                    index = this.spaceList.findFirstGreaterEqualKeyIndex(rowUnits);
                }
            }
        }
        if (index == -1) {
            return this.getNewBlock(rowSize);
        }
        ++this.requestCount;
        this.requestSize += (long)rowSize;
        int key = this.spaceList.getKey(index);
        int units = this.spaceList.getValue(index);
        int difference = units - rowUnits;
        this.spaceList.remove(index);
        if (difference > 0) {
            int pos = key + rowUnits;
            this.spaceList.add(pos, difference);
        }
        return key;
    }

    @Override
    public void reset() {
        this.fileBlockIndex = this.freshBlockFreePos == 0L ? -1 : (int)(this.freshBlockFreePos / (long)this.fileBlockSize);
        this.resetOldList();
        this.resetList(true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
        this.currentBlockFloor = 0L;
        this.currentBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        long total = this.freshBlockLimit - this.freshBlockFreePos + this.spaceList.getTotalValues() * (long)this.scale + this.oldList.getTotalValues() * (long)this.scale;
        return total;
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    public int getFileBlockIndex() {
        return this.fileBlockIndex;
    }

    private void resetList(boolean full) {
        this.spaceList.compactLookupAsIntervals();
        if (full) {
            this.spaceManager.freeTableSpace(this.spaceID, this.spaceList, this.freshBlockFreePos, this.freshBlockLimit);
            this.spaceList.clear();
            this.spaceList.setValuesSearchTarget();
        } else {
            if (this.spaceList.size() > this.capacity - 32) {
                int limit = this.capacity / 2;
                for (int i = 0; i < limit; ++i) {
                    int pos = this.spaceList.getKey(i);
                    int rowUnits = this.spaceList.getValue(i);
                    this.oldList.addUnsorted(pos, rowUnits);
                    if (this.oldList.size() != this.capacity) continue;
                    this.resetOldList();
                }
                this.spaceList.removeRange(0, limit);
                this.resetOldList();
            }
            this.spaceList.setValuesSearchTarget();
        }
    }

    private void resetOldList() {
        if (this.oldList.size() > 0) {
            this.oldList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldList, 0L, 0L);
            this.oldList.clear();
        }
        if (this.oldLargeList != null && this.oldLargeList.size() > 0) {
            this.oldLargeList.compactLookupAsIntervals();
            this.spaceManager.freeTableSpace(this.spaceID, this.oldLargeList, 0L, 0L);
            this.oldLargeList.clear();
        }
    }
}

