/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;

public class TextCache
extends DataFileCache {
    TextFileSettings textFileSettings;
    protected String header;
    protected Table table;
    private LongKeyHashMap uncommittedCache;
    HsqlByteArrayOutputStream buffer = new HsqlByteArrayOutputStream(128);

    TextCache(Table table, String name) {
        super(table.database, name);
        this.table = table;
        this.uncommittedCache = new LongKeyHashMap();
    }

    @Override
    protected void initParams(Database database, String settingsString, boolean defrag) {
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.textFileSettings = new TextFileSettings(database.getProperties(), settingsString);
        this.dataFileName = this.textFileSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.dataFileName = ((FileUtil)this.fa).canonicalOrAbsolutePath(this.dataFileName);
        this.maxCacheRows = this.textFileSettings.getMaxCacheRows();
        this.maxCacheBytes = this.textFileSettings.getMaxCacheBytes();
        this.maxDataFileSize = 274877906816L;
        this.cachedRowPadding = 1;
        this.dataFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        if (this.textFileSettings.isQuoted || this.textFileSettings.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.textFileSettings);
            this.rowOut = new RowOutputTextQuoted(this.textFileSettings);
        } else {
            this.rowIn = new RowInputText(this.textFileSettings);
            this.rowOut = new RowOutputText(this.textFileSettings);
        }
    }

    @Override
    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        try {
            int type = this.database.getType() == DatabaseType.DB_RES ? 2 : 5;
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, readonly, type);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > this.maxDataFileSize) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.spaceManager = new DataSpaceManagerSimple(this, readonly);
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new String[]{this.dataFileName, t.toString()});
        }
        this.cacheReadonly = readonly;
    }

    @Override
    public void release() {
        this.close();
    }

    @Override
    public void close() {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean empty = this.dataFile.length() <= (long)this.textFileSettings.bytesForLineEnd.length;
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (empty && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 43, new String[]{this.dataFileName, t.toString()});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.release();
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 44, new String[]{this.dataFileName, t.toString()});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CachedObject object) {
        this.writeLock.lock();
        try {
            long pos = object.getPos();
            CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
            if (row != null) {
                return;
            }
            this.cache.release(pos);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removePersistence(CachedObject row) {
        this.writeLock.lock();
        try {
            this.clearRowImage(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject row) {
        try {
            int length = row.getStorageSize();
            this.rowOut.reset();
            HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
            for (int count = length - this.textFileSettings.bytesForLineEnd.length; count > 0; count -= this.textFileSettings.bytesForSpace.length) {
                out.write(this.textFileSettings.bytesForSpace);
            }
            out.write(this.textFileSettings.bytesForLineEnd);
            this.dataFile.seek(row.getPos());
            this.dataFile.write(out.getBuffer(), 0, out.size());
        }
        catch (Throwable t) {
            throw Error.runtimeError(201, t.getMessage());
        }
    }

    @Override
    public void add(CachedObject object, boolean keep) {
        this.writeLock.lock();
        try {
            this.uncommittedCache.put(object.getPos(), object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        if (object == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            CachedObject existing = this.cache.get(object.getPos());
            if (existing != null) {
                CachedObject cachedObject = object;
                return cachedObject;
            }
            this.buffer.reset(object.getStorageSize());
            this.dataFile.seek(object.getPos());
            this.dataFile.read(this.buffer.getBuffer(), 0, object.getStorageSize());
            this.buffer.setSize(object.getStorageSize());
            String rowString = this.buffer.toString(this.textFileSettings.charEncoding);
            ((RowInputText)this.rowIn).setSource(rowString, object.getPos(), this.buffer.size());
            store.get(object, this.rowIn);
            this.cache.put(object);
            Row row = (Row)object;
            if (this.textFileSettings.isNullDef) {
                this.table.generateDefaultForNull(row.getData());
            }
            CachedObject cachedObject = object;
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(long i, PersistentStore store, boolean keep) {
        throw Error.runtimeError(201, "TextCache");
    }

    @Override
    protected void saveRows(CachedObject[] rows, int offset, int count) {
    }

    @Override
    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(row);
            this.uncommittedCache.remove(row.getPos());
            this.cache.put(row);
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("saveRow failed", e);
            throw Error.error(466, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeaderInitialise(String header) {
        this.header = header;
    }

    public void setHeader(String header) {
        if (this.textFileSettings.isIgnoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(header);
                this.header = header;
            }
            catch (HsqlException e) {
                throw new HsqlException(e, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String header) {
        try {
            byte[] buf = null;
            String firstLine = header + TextFileSettings.NL;
            try {
                buf = firstLine.getBytes(this.textFileSettings.charEncoding);
            }
            catch (UnsupportedEncodingException e) {
                buf = firstLine.getBytes();
            }
            this.dataFile.seek(0L);
            this.dataFile.write(buf, 0, buf.length);
            this.fileFreePosition = buf.length;
        }
        catch (Throwable t) {
            throw Error.error(484, t);
        }
    }

    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    public TextFileSettings getTextFileSettings() {
        return this.textFileSettings;
    }

    public boolean isIgnoreFirstLine() {
        return this.textFileSettings.isIgnoreFirst;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    public TextFileReader getTextFileReader() {
        return TextFileReader8.newTextFileReader(this.dataFile, this.textFileSettings, this.rowIn, this.cacheReadonly);
    }
}

