/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.persist.RowInsertSimple;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.types.Type;

public class TextFileOps {
    public static Result loadTextData(Session session, String fileSettings, Table table, int mode) {
        RandomAccessInterface dataFile;
        Database database = session.database;
        FileUtil fa = FileUtil.getFileUtil();
        TextFileSettings textFileSettings = new TextFileSettings(database.getProperties(), fileSettings);
        String dataFileName = textFileSettings.getFileName();
        if (dataFileName == null || dataFileName.length() == 0) {
            throw Error.error(301);
        }
        dataFileName = fa.canonicalOrAbsolutePath(dataFileName);
        boolean exists = FileUtil.getFileUtil().exists(dataFileName);
        if (!exists) {
            throw Error.error(null, 452, 42, new String[]{dataFileName, "file does not exist"});
        }
        try {
            dataFile = RAFile.newScaledRAFile(database, dataFileName, true, 5);
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new String[]{dataFileName, t.toString()});
        }
        RowInputInterface rowIn = textFileSettings.isQuoted || textFileSettings.isAllQuoted ? new RowInputTextQuoted(textFileSettings) : new RowInputText(textFileSettings);
        TextFileReader reader = TextFileReader8.newTextFileReader(dataFile, textFileSettings, rowIn, true);
        RowInsertInterface.ErrorLogger callback = mode == 2 ? new RowInsertSimple.InsertErrorHandler(database, dataFileName) : new RowInsertSimple.DefaultErrorHandler();
        RowInsertSimple rowInsert = new RowInsertSimple(session, callback, mode);
        PersistentStore store = table.getRowStore(session);
        Type[] types = table.getColumnTypes();
        boolean ignoreFirst = textFileSettings.isIgnoreFirst;
        try {
            while ((rowIn = reader.readObject()) != null) {
                if (ignoreFirst) {
                    ignoreFirst = false;
                    continue;
                }
                Object[] data = rowIn.readData(types);
                if (textFileSettings.isNullDef) {
                    table.generateDefaultForNull(data);
                }
                table.generateAndCheckData(session, data);
                if (mode == 4) continue;
                rowInsert.insert(table, store, data);
            }
            rowInsert.finishTable();
        }
        catch (Throwable t) {
            long linenumber = reader.getLineNumber();
            throw Error.error(t, 483, 0, new String[]{String.valueOf(linenumber), t.toString()});
        }
        finally {
            rowInsert.close();
            try {
                if (callback != null) {
                    callback.close();
                }
            }
            catch (Exception data) {}
            try {
                dataFile.close();
            }
            catch (Exception data) {}
        }
        return Result.newUpdateCountResult((int)reader.getLineNumber());
    }

    public static Result unloadTextData(Session session, String fileSettings, Table table) {
        RAFileSimple dataFile;
        Database database = session.database;
        FileUtil fa = FileUtil.getFileUtil();
        TextFileSettings textFileSettings = new TextFileSettings(database.getProperties(), fileSettings);
        String dataFileName = textFileSettings.getFileName();
        int lineCount = 0;
        if (dataFileName == null || dataFileName.length() == 0) {
            throw Error.error(301);
        }
        dataFileName = fa.canonicalOrAbsolutePath(dataFileName);
        boolean exists = FileUtil.getFileUtil().exists(dataFileName);
        if (exists) {
            throw Error.error(null, 487, 42, new String[]{dataFileName, "file exists"});
        }
        try {
            dataFile = new RAFileSimple(database.logger, dataFileName, "rw");
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new String[]{dataFileName});
        }
        RowOutputText rowOut = textFileSettings.isQuoted || textFileSettings.isAllQuoted ? new RowOutputTextQuoted(textFileSettings) : new RowOutputText(textFileSettings);
        PersistentStore store = table.getRowStore(session);
        Type[] types = table.getColumnTypes();
        RowIterator it = table.rowIteratorForScript(store);
        long filePosition = 0L;
        try {
            while (it.next()) {
                rowOut.reset();
                Row row = it.getCurrentRow();
                rowOut.writeData(row, types);
                rowOut.writeEnd();
                dataFile.seek(filePosition);
                dataFile.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.getOutputStream().size());
                filePosition += (long)rowOut.getOutputStream().size();
                ++lineCount;
            }
            dataFile.synch();
        }
        catch (Throwable t) {
            throw Error.error(t, 452, 42, new String[]{dataFileName});
        }
        finally {
            try {
                dataFile.close();
            }
            catch (Exception row) {}
        }
        return Result.newUpdateCountResult(lineCount);
    }
}

