/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.error.Error;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader16
extends TextFileReader8
implements TextFileReader {
    TextFileReader16(RandomAccessInterface dataFile, TextFileSettings textFileSettings, RowInputInterface rowIn, boolean isReadOnly) {
        this.dataFile = dataFile;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowIn;
        this.buffer = TextFileReader8.StringCreator.getStringCreator(Character.TYPE, textFileSettings.charEncoding);
        this.skipBOM();
    }

    private void skipBOM() {
        try {
            if (this.textFileSettings.isUTF16) {
                this.dataFile.seek(0L);
                if (this.dataFile.read() == 254 && this.dataFile.read() == 255) {
                    this.position = 2L;
                } else {
                    this.dataFile.seek(0L);
                    if (this.dataFile.read() == 255 && this.dataFile.read() == 254) {
                        this.position = 2L;
                        this.textFileSettings.setLittleEndianByteOrderMark();
                    }
                }
            }
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    int getByteSizeForChar() {
        return 2;
    }

    @Override
    int readChar() {
        try {
            int c1 = this.dataFile.read();
            if (c1 == -1) {
                return -1;
            }
            int c2 = this.dataFile.read();
            if (c2 == -1) {
                return -1;
            }
            if (this.textFileSettings.isLittleEndian) {
                int temp = c1;
                c1 = c2;
                c2 = temp;
            }
            return (char)((c1 << 8) + c2);
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    public String getHeaderLine() {
        return this.header;
    }

    @Override
    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }
}

