/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader16;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader8
implements TextFileReader {
    RandomAccessInterface dataFile;
    RowInputInterface rowIn;
    TextFileSettings textFileSettings;
    String header;
    boolean isReadOnly;
    StringCreator buffer;
    long position = 0L;

    TextFileReader8() {
    }

    TextFileReader8(RandomAccessInterface dataFile, TextFileSettings textFileSettings, RowInputInterface rowIn, boolean isReadOnly) {
        this.dataFile = dataFile;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowIn;
        this.isReadOnly = isReadOnly;
        this.buffer = StringCreator.getStringCreator(Byte.TYPE, textFileSettings.charEncoding);
        this.skipBOM();
    }

    static TextFileReader newTextFileReader(RandomAccessInterface dataFile, TextFileSettings textFileSettings, RowInputInterface rowIn, boolean isReadOnly) {
        if (textFileSettings.isUTF16) {
            return new TextFileReader16(dataFile, textFileSettings, rowIn, isReadOnly);
        }
        return new TextFileReader8(dataFile, textFileSettings, rowIn, isReadOnly);
    }

    private void skipBOM() {
        try {
            if (this.textFileSettings.isUTF8) {
                this.dataFile.seek(0L);
                if (this.dataFile.read() == 239 && this.dataFile.read() == 187 && this.dataFile.read() == 191) {
                    this.position = 3L;
                }
            }
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    public RowInputInterface readObject() {
        boolean hasQuote = false;
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        boolean quotedField = false;
        this.buffer.reset();
        this.position = this.findNextUsedLinePos();
        if (this.position == -1L) {
            return null;
        }
        try {
            this.dataFile.seek(this.position);
            long currentPos = 0L;
            long fieldPos = -1L;
            while (!complete) {
                int c = this.readChar();
                wasNormal = false;
                if (c == -1) {
                    if (this.buffer.size() == 0) {
                        return null;
                    }
                    complete = true;
                    if (wasCR || this.isReadOnly) break;
                    this.dataFile.write(this.textFileSettings.bytesForLineEnd, 0, this.textFileSettings.bytesForLineEnd.length);
                    for (int i = 0; i < this.textFileSettings.bytesForLineEnd.length; ++i) {
                        this.buffer.write(this.textFileSettings.bytesForLineEnd[i]);
                    }
                    break;
                }
                if (c == this.textFileSettings.singleSeparator) {
                    if (!hasQuote) {
                        fieldPos = currentPos;
                        quotedField = false;
                        hasQuote = false;
                    }
                } else if (c == this.textFileSettings.quoteChar) {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                    if (this.textFileSettings.isQuoted && (this.textFileSettings.singleSeparator == '\u0000' || currentPos == fieldPos + 1L)) {
                        quotedField = true;
                    }
                    if (quotedField) {
                        hasQuote = !hasQuote;
                    }
                } else {
                    switch (c) {
                        case 13: {
                            wasCR = !hasQuote;
                            break;
                        }
                        case 10: {
                            complete = !hasQuote;
                            break;
                        }
                        default: {
                            wasNormal = true;
                            complete = wasCR;
                            wasCR = false;
                        }
                    }
                }
                this.buffer.write(c);
                ++currentPos;
            }
            if (complete) {
                String rowString;
                if (wasNormal) {
                    this.buffer.setSize(this.buffer.size() - 1);
                }
                try {
                    rowString = this.buffer.getString();
                }
                catch (UnsupportedEncodingException e) {
                    throw Error.error(331, e);
                }
                ((RowInputText)this.rowIn).setSource(rowString, this.position, this.buffer.getByteSize());
                this.position += (long)this.rowIn.getSize();
                return this.rowIn;
            }
            return null;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    public void readHeaderLine() {
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        this.buffer.reset();
        try {
            this.dataFile.seek(this.position);
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
        while (!complete) {
            int c;
            wasNormal = false;
            try {
                c = this.readChar();
                if (c == -1) {
                    if (this.buffer.size() == 0) {
                        return;
                    }
                    complete = true;
                    if (this.isReadOnly) break;
                    this.dataFile.write(this.textFileSettings.bytesForLineEnd, 0, this.textFileSettings.bytesForLineEnd.length);
                    for (int i = 0; i < this.textFileSettings.bytesForLineEnd.length; ++i) {
                        this.buffer.write(this.textFileSettings.bytesForLineEnd[i]);
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw Error.error(483, e);
            }
            switch (c) {
                case 13: {
                    wasCR = true;
                    break;
                }
                case 10: {
                    complete = true;
                    break;
                }
                default: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                }
            }
            if (wasCR || complete) continue;
            this.buffer.write(c);
        }
        if (wasNormal) {
            this.buffer.setSize(this.buffer.size() - 1);
        }
        try {
            this.header = this.buffer.getString();
        }
        catch (UnsupportedEncodingException e) {
            throw Error.error(331, e);
        }
        this.position += (long)this.buffer.getByteSize();
    }

    private long findNextUsedLinePos() {
        try {
            long firstPos = this.position;
            long currentPos = this.position;
            boolean wasCR = false;
            this.dataFile.seek(this.position);
            block8: while (true) {
                int c = this.readChar();
                currentPos += (long)this.getByteSizeForChar();
                switch (c) {
                    case 13: {
                        wasCR = true;
                        continue block8;
                    }
                    case 10: {
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        firstPos = currentPos;
                        continue block8;
                    }
                    case 32: {
                        if (!wasCR) continue block8;
                        wasCR = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1L;
                    }
                }
                break;
            }
            if (wasCR) {
                wasCR = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return firstPos;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    int getByteSizeForChar() {
        return 1;
    }

    int readChar() {
        try {
            int c1 = this.dataFile.read();
            return c1;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    @Override
    public String getHeaderLine() {
        return this.header;
    }

    @Override
    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    static class StringCreatorChars
    extends StringCreator {
        private CharArrayWriter buffer = new CharArrayWriter(128);

        StringCreatorChars() {
        }

        @Override
        void reset() {
            this.buffer.reset();
        }

        @Override
        void write(int c) {
            this.buffer.write(c);
        }

        @Override
        int size() {
            return this.buffer.size();
        }

        @Override
        void setSize(int size) {
            this.buffer.setSize(size);
        }

        @Override
        String getString() {
            String string = new String(this.buffer.getBuffer(), 0, this.buffer.size());
            return string;
        }

        @Override
        int getByteSize() {
            return this.buffer.size() * 2;
        }
    }

    static class StringCreatorBytes
    extends StringCreator {
        private HsqlByteArrayOutputStream buffer = new HsqlByteArrayOutputStream(128);
        private String encoding;

        StringCreatorBytes(String encoding) {
            this.encoding = encoding;
        }

        @Override
        void reset() {
            this.buffer.reset();
        }

        @Override
        void write(int c) {
            this.buffer.write(c);
        }

        @Override
        int size() {
            return this.buffer.size();
        }

        @Override
        void setSize(int size) {
            this.buffer.setSize(size);
        }

        @Override
        String getString() throws UnsupportedEncodingException {
            return this.buffer.toString(this.encoding);
        }

        @Override
        int getByteSize() {
            return this.buffer.size();
        }
    }

    static abstract class StringCreator {
        StringCreator() {
        }

        static StringCreator getStringCreator(Class cl, String encoding) {
            if (Byte.TYPE.equals(cl)) {
                return new StringCreatorBytes(encoding);
            }
            if (Character.TYPE.equals(cl)) {
                return new StringCreatorChars();
            }
            throw Error.runtimeError(201, "StringCreator");
        }

        abstract void reset();

        abstract void write(int var1);

        abstract int size();

        abstract void setSize(int var1);

        abstract String getString() throws UnsupportedEncodingException;

        abstract int getByteSize();
    }
}

