/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap directRightsMap;
    HashMap fullRightsMap = new HashMap();
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName name, GranteeManager man) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = name;
        this.granteeManager = man;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE").append(' ').append("ROLE");
        sb.append(' ').append(this.granteeName.statementName);
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    public OrderedHashSet getDirectRolesWithPublic() {
        OrderedHashSet<Grantee> newSet = new OrderedHashSet<Grantee>();
        newSet.addAll(this.roles);
        newSet.add(this.granteeManager.publicRole);
        return newSet;
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet set = this.getGranteeAndAllRoles();
        set.remove(this);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet set = new OrderedHashSet();
        this.addGranteeAndRoles(set);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet<Grantee> set = new OrderedHashSet<Grantee>();
        this.addGranteeAndRoles(set);
        set.add(this.granteeManager.publicRole);
        return set;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName name, int action) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        if (right == null) {
            return false;
        }
        return right.canAccess(action);
    }

    public boolean isAccessible(SchemaObject object) {
        return this.isAccessible(object.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName name) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(name);
        }
        return false;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet set) {
        set.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee candidateRole = (Grantee)this.roles.get(i);
            if (set.contains(candidateRole)) continue;
            candidateRole.addGranteeAndRoles(set);
        }
        return set;
    }

    private boolean hasRoleDirect(Grantee role) {
        return this.roles.contains(role);
    }

    public boolean hasRole(Grantee role) {
        return this.getAllRoles().contains(role);
    }

    private void grantToAll(HsqlNameManager.HsqlName name, Right right, Grantee grantor, boolean withGrant) {
        int objectType = 3;
        if (right.isFullUsage) {
            right = Right.fullRights;
            objectType = 7;
        } else if (right.isFullExecute) {
            right = Right.fullRights;
            objectType = 24;
        }
        Iterator it = this.granteeManager.database.schemaManager.databaseObjectIterator(name.name, objectType);
        while (it.hasNext()) {
            SchemaObject object = (SchemaObject)it.next();
            this.grant(object.getName(), right, grantor, withGrant);
        }
    }

    void grant(HsqlNameManager.HsqlName name, Right right, Grantee grantor, boolean withGrant) {
        if (name.type == 2) {
            this.grantToAll(name, right, grantor, withGrant);
            return;
        }
        Right grantableRights = grantor.getAllGrantableRights(name);
        Right existingRight = null;
        if (right == Right.fullRights) {
            if (grantableRights.isEmpty()) {
                return;
            }
            right = grantableRights;
        } else if (!grantableRights.contains(right)) {
            throw Error.error(2000);
        }
        Iterator it = this.directRightsMap.getValuesIterator(name);
        while (it.hasNext()) {
            Right existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
            existingRight = existing;
            existingRight.add(right);
            break;
        }
        if (existingRight == null) {
            existingRight = right.duplicate();
            existingRight.grantor = grantor;
            existingRight.grantee = this;
            this.directRightsMap.put(name, existingRight);
        }
        if (withGrant) {
            if (existingRight.grantableRights == null) {
                existingRight.grantableRights = right.duplicate();
            } else {
                existingRight.grantableRights.add(right);
            }
        }
        if (!grantor.isSystem()) {
            grantor.grantedRightsMap.put(name, existingRight);
        }
        this.updateAllRights();
    }

    private void revokeFromAll(HsqlNameManager.HsqlName name, Right right, Grantee grantor, boolean grantOption) {
        int objectType = 3;
        if (right.isFullUsage) {
            right = Right.fullRights;
            objectType = 7;
        } else if (right.isFullExecute) {
            right = Right.fullRights;
            objectType = 24;
        }
        Iterator it = this.granteeManager.database.schemaManager.databaseObjectIterator(name.name, objectType);
        while (it.hasNext()) {
            SchemaObject object = (SchemaObject)it.next();
            this.revoke(object, right, grantor, grantOption);
        }
    }

    void revoke(SchemaObject object, Right right, Grantee grantor, boolean grantOption) {
        HsqlNameManager.HsqlName name = object.getName();
        if (name.type == 2) {
            this.grantToAll(name, right, grantor, grantOption);
            return;
        }
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        Iterator it = this.directRightsMap.getValuesIterator(name);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
        }
        if (existing == null) {
            return;
        }
        if (existing.grantableRights != null) {
            existing.grantableRights.remove(object, right);
        }
        if (grantOption) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
            this.updateAllRights();
            return;
        }
        existing.remove(object, right);
        if (existing.isEmpty()) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName name) {
        this.directRightsMap.remove(name);
        this.grantedRightsMap.remove(name);
        this.fullRightsMap.remove(name);
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName tableName, HsqlNameManager.HsqlName columnName) {
        Iterator it = this.directRightsMap.getValuesIterator(tableName);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
        }
        if (existing == null) {
            return;
        }
        existing.addNewColumn(columnName);
        this.updateAllRights();
    }

    void updateRightsForNewColumn(HsqlNameManager.HsqlName tableName) {
        Iterator it = this.grantedRightsMap.getValuesIterator(tableName);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
        }
        if (existing == null) {
            return;
        }
        this.updateAllRights();
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(SchemaObject object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return table.getColumnNameSet();
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            return right == null ? Right.emptySet : right.getColumnsForAllRights(table);
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject object) {
        Iterator rights;
        if (object.getOwner() == this) {
            OrderedHashSet<Right> set = new OrderedHashSet<Right>();
            set.add(this.ownerRights);
            return set;
        }
        HsqlNameManager.HsqlName name = object.getName();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        if ((rights = this.directRightsMap.getValuesIterator(name)).hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject object) {
        Iterator rights;
        HsqlNameManager.HsqlName name = object.getName();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        if ((rights = this.grantedRightsMap.getValuesIterator(name)).hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public Right checkSelect(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canSelect(table, checkList)) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkInsert(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canInsert(table, checkList)) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkUpdate(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canUpdate(table, checkList)) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkReferences(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canReference(table, checkList)) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkTrigger(SchemaObject object, boolean[] checkList) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canReference(table, checkList)) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkDelete(SchemaObject object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            if (this.isFullyAccessibleByRole(table.getName())) {
                return Right.fullRights;
            }
            Right right = (Right)this.fullRightsMap.get(table.getName());
            if (right != null && right.canDelete()) {
                return right;
            }
        }
        throw Error.error(5501, object.getName().name);
    }

    public Right checkAccess(SchemaObject object) {
        Right right;
        if (this.isFullyAccessibleByRole(object.getName())) {
            return Right.fullRights;
        }
        HsqlNameManager.HsqlName name = object.getName();
        if (object instanceof Routine) {
            name = ((Routine)object).getSpecificName();
        }
        if ((right = (Right)this.fullRightsMap.get(name)) != null && !right.isEmpty()) {
            return right;
        }
        throw Error.error(5501, object.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(HsqlNameManager.HsqlName schemaName) {
        if (!this.hasSchemaUpdateOrGrantRights(schemaName)) {
            throw Error.error(5501, schemaName.name);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(HsqlNameManager.HsqlName schemaName) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee schemaOwner = this.granteeManager.database.schemaManager.toSchemaOwner(schemaName.name);
        if (schemaOwner == this) {
            return true;
        }
        return this.hasRole(schemaOwner);
    }

    public boolean isGrantable(SchemaObject object, Right right) {
        if (this.isFullyAccessibleByRole(object.getName())) {
            return true;
        }
        Right grantableRights = this.getAllGrantableRights(object.getName());
        return grantableRights.contains(right);
    }

    public boolean isGrantable(Grantee role) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName name) {
        Grantee owner;
        if (this.isAdmin) {
            return true;
        }
        if (name.type == 2) {
            owner = name.owner;
        } else {
            if (name.schema == null) {
                return false;
            }
            owner = name.schema.owner;
        }
        if (owner == this) {
            return true;
        }
        return this.hasRole(owner);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean canPerformScriptOps() {
        return this.isAdmin || this.hasRole(this.granteeManager.scriptOpsRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public OrderedHashSet visibleGrantees() {
        OrderedHashSet<Grantee> grantees = new OrderedHashSet<Grantee>();
        GranteeManager gm = this.granteeManager;
        if (this.isAdmin()) {
            grantees.addAll(gm.getGrantees());
        } else {
            grantees.add(this);
            Iterator it = this.getAllRoles().iterator();
            while (it.hasNext()) {
                grantees.add((Grantee)it.next());
            }
        }
        return grantees;
    }

    public boolean hasNonSelectTableRight(SchemaObject table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.canAccessNonSelect();
    }

    public boolean hasColumnRights(SchemaObject table, int[] columnMap) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.canAccess((Table)table, columnMap);
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee role) {
        boolean hasNested = false;
        if (role != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee currentRole = (Grantee)this.roles.get(i);
                hasNested |= currentRole.updateNestedRoles(role);
            }
        }
        if (hasNested) {
            this.updateAllRights();
        }
        return hasNested || role == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee currentRole = (Grantee)this.roles.get(i);
            this.addToFullRights(currentRole.fullRightsMap);
            this.isAdmin |= currentRole.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Right add = (Right)map.get(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            if (existing == null) {
                existing = add.duplicate();
                this.fullRightsMap.put(key, existing);
            } else {
                existing.add(add);
            }
            if (add.grantableRights == null) continue;
            if (existing.grantableRights == null) {
                existing.grantableRights = add.grantableRights.duplicate();
                continue;
            }
            existing.grantableRights.add(add.grantableRights);
        }
    }

    private void addToFullRights(MultiValueHashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Iterator values = map.getValuesIterator(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            while (values.hasNext()) {
                Right add = (Right)values.next();
                if (existing == null) {
                    existing = add.duplicate();
                    this.fullRightsMap.put(key, existing);
                } else {
                    existing.add(add);
                }
                if (add.grantableRights == null) continue;
                if (existing.grantableRights == null) {
                    existing.grantableRights = add.grantableRights.duplicate();
                    continue;
                }
                existing.grantableRights.add(add.grantableRights);
            }
        }
    }

    Right getAllGrantableRights(HsqlNameManager.HsqlName name) {
        if (this.isAdmin) {
            return name.schema.owner.ownerRights;
        }
        if (name.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(name.schema.owner)) {
            return name.schema.owner.ownerRights;
        }
        OrderedHashSet set = this.getAllRoles();
        for (int i = 0; i < set.size(); ++i) {
            Grantee role = (Grantee)set.get(i);
            if (name.schema.owner != role) continue;
            return role.ownerRights;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    private MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    void grant(Grantee role) {
        this.roles.add(role);
    }

    void revoke(Grantee role) {
        if (!this.hasRoleDirect(role)) {
            throw Error.error(2253, role.getName().getNameString());
        }
        this.roles.remove(role);
    }

    private String roleMapToString(OrderedHashSet roles) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < roles.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            Grantee role = (Grantee)roles.get(i);
            sb.append(role.getName().getStatementName());
        }
        return sb.toString();
    }

    HsqlArrayList getRightsSQL() {
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        String roleString = this.roleMapToString(this.roles);
        if (!roleString.isEmpty()) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("GRANT").append(' ').append(roleString);
            sb.append(' ').append("TO").append(' ');
            sb.append(this.getName().getStatementName());
            list.add(sb.toString());
        }
        MultiValueHashMap rightsMap = this.getRights();
        Iterator dbObjects = rightsMap.keySet().iterator();
        while (dbObjects.hasNext()) {
            Object nameObject = dbObjects.next();
            Iterator rights = rightsMap.getValuesIterator(nameObject);
            while (rights.hasNext()) {
                Right right = (Right)rights.next();
                StringBuilder sb = new StringBuilder(128);
                HsqlNameManager.HsqlName hsqlname = (HsqlNameManager.HsqlName)nameObject;
                switch (hsqlname.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(hsqlname.name, hsqlname.schema.name);
                        if (table == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append(right.getTableRightsSQL(table));
                        sb.append(' ').append("ON").append(' ');
                        sb.append("TABLE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence sequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 7);
                        if (sequence == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("SEQUENCE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type domain = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 13);
                        if (domain == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("DOMAIN").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 13);
                        if (type == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("TYPE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject routine = this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, hsqlname.type);
                        if (routine == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("EXECUTE").append(' ');
                        sb.append("ON").append(' ');
                        sb.append("SPECIFIC").append(' ');
                        if (routine.getType() == 17) {
                            sb.append("PROCEDURE");
                        } else {
                            sb.append("FUNCTION");
                        }
                        sb.append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                }
                if (sb.length() == 0) continue;
                sb.append(' ').append("TO").append(' ');
                sb.append(this.getName().getStatementName());
                list.add(sb.toString());
            }
        }
        return list;
    }
}

