/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;

public class GranteeManager {
    static User systemAuthorisation;
    private OrderedHashMap map = new OrderedHashMap();
    private OrderedHashMap roleMap = new OrderedHashMap();
    Database database;
    private MessageDigest digester;
    private String digestAlgo;
    Grantee publicRole;
    Grantee dbaRole;
    Grantee schemaRole;
    Grantee changeAuthRole;
    Grantee scriptOpsRole;
    static final IntValueHashMap rightsStringLookup;

    public GranteeManager(Database database) {
        this.database = database;
        this.addRole(this.database.nameManager.newHsqlName("PUBLIC", false, 11));
        this.publicRole = this.getRole("PUBLIC");
        this.publicRole.isPublic = true;
        this.addRole(this.database.nameManager.newHsqlName("DBA", false, 11));
        this.dbaRole = this.getRole("DBA");
        this.dbaRole.setAdminDirect();
        this.addRole(this.database.nameManager.newHsqlName("CREATE_SCHEMA", false, 11));
        this.schemaRole = this.getRole("CREATE_SCHEMA");
        this.addRole(this.database.nameManager.newHsqlName("CHANGE_AUTHORIZATION", false, 11));
        this.changeAuthRole = this.getRole("CHANGE_AUTHORIZATION");
        this.addRole(this.database.nameManager.newHsqlName("SCRIPT_OPS", false, 11));
        this.scriptOpsRole = this.getRole("SCRIPT_OPS");
    }

    public Grantee getDBARole() {
        return this.dbaRole;
    }

    public static Grantee getSystemRole() {
        return systemAuthorisation;
    }

    public void grant(Session session, OrderedHashSet granteeList, SchemaObject dbObject, Right right, Grantee grantor, boolean withGrantOption) {
        if (dbObject instanceof RoutineSchema) {
            SchemaObject[] routines = ((RoutineSchema)dbObject).getSpecificRoutines();
            this.grant(session, granteeList, routines, right, grantor, withGrantOption);
            return;
        }
        HsqlNameManager.HsqlName name = dbObject.getName();
        if (dbObject instanceof Routine) {
            name = ((Routine)dbObject).getSpecificName();
        }
        if (!grantor.isAccessible(dbObject)) {
            throw Error.error(2000, grantor.getName().getNameString());
        }
        if (!grantor.isGrantable(dbObject, right)) {
            session.addWarning(Error.error(1007, grantor.getName().getNameString()));
            return;
        }
        if (grantor.isAdmin()) {
            grantor = dbObject.getOwner();
        }
        this.checkGranteeList(granteeList);
        for (int i = 0; i < granteeList.size(); ++i) {
            Grantee grantee = this.get((String)granteeList.get(i));
            if (!grantee.isRole && right.hasFilter()) {
                throw Error.error(2200, grantee.getName().name);
            }
            grantee.grant(name, right, grantor, withGrantOption);
            if (!grantee.isRole) continue;
            this.updateAllRights(grantee);
        }
    }

    public void grant(Session session, OrderedHashSet granteeList, SchemaObject[] routines, Right right, Grantee grantor, boolean withGrantOption) {
        boolean granted = false;
        for (int i = 0; i < routines.length; ++i) {
            if (!grantor.isGrantable(routines[i], right)) continue;
            this.grant(session, granteeList, routines[i], right, grantor, withGrantOption);
            granted = true;
        }
        if (!granted) {
            throw Error.error(2000, grantor.getName().getNameString());
        }
    }

    public void checkGranteeList(OrderedHashSet granteeList) {
        for (int i = 0; i < granteeList.size(); ++i) {
            String name = (String)granteeList.get(i);
            Grantee grantee = this.get(name);
            if (grantee == null) {
                throw Error.error(4001, name);
            }
            if (GranteeManager.isImmutable(name)) {
                throw Error.error(4002, name);
            }
            if (!(grantee instanceof User) || !((User)grantee).isExternalOnly) continue;
            throw Error.error(4000, name);
        }
    }

    public void grant(String granteeName, String roleName, Grantee grantor) {
        Grantee grantee = this.get(granteeName);
        if (grantee == null) {
            throw Error.error(4001, granteeName);
        }
        if (GranteeManager.isImmutable(granteeName)) {
            throw Error.error(4002, granteeName);
        }
        Grantee role = this.getRole(roleName);
        if (role == null) {
            throw Error.error(2200, roleName);
        }
        if (role == grantee) {
            throw Error.error(2251, granteeName);
        }
        if (role.hasRole(grantee)) {
            throw Error.error(2251, roleName);
        }
        if (!grantor.isGrantable(role)) {
            throw Error.error(2000, grantor.getName().getNameString());
        }
        grantee.grant(role);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    public void checkRoleList(String granteeName, OrderedHashSet roleList, Grantee grantor, boolean grant) {
        Grantee grantee = this.get(granteeName);
        for (int i = 0; i < roleList.size(); ++i) {
            String roleName = (String)roleList.get(i);
            Grantee role = this.getRole(roleName);
            if (role == null) {
                throw Error.error(2200, roleName);
            }
            if (roleName.equals("_SYSTEM") || roleName.equals("PUBLIC")) {
                throw Error.error(4002, roleName);
            }
            if (grant ? grantee.getDirectRoles().contains(role) : !grantee.getDirectRoles().contains(role)) {
                // empty if block
            }
            if (grantor.isAdmin()) continue;
            throw Error.error(2000, grantor.getName().getNameString());
        }
    }

    public void grantSystemToPublic(SchemaObject object, Right right) {
        this.publicRole.grant(object.getName(), right, systemAuthorisation, true);
    }

    public void revoke(String granteeName, String roleName, Grantee grantor) {
        if (!grantor.isAdmin()) {
            throw Error.error(5507);
        }
        Grantee grantee = this.get(granteeName);
        if (grantee == null) {
            throw Error.error(4000, granteeName);
        }
        Grantee role = (Grantee)this.roleMap.get(roleName);
        grantee.revoke(role);
        grantee.updateAllRights();
        if (grantee.isRole) {
            this.updateAllRights(grantee);
        }
    }

    public void revoke(OrderedHashSet granteeList, SchemaObject dbObject, Right rights, Grantee grantor, boolean grantOption, boolean cascade) {
        Grantee g;
        String granteeName;
        int i;
        if (dbObject instanceof RoutineSchema) {
            SchemaObject[] routines = ((RoutineSchema)dbObject).getSpecificRoutines();
            this.revoke(granteeList, routines, rights, grantor, grantOption, cascade);
            return;
        }
        HsqlNameManager.HsqlName name = dbObject.getName();
        if (dbObject instanceof Routine) {
            name = ((Routine)dbObject).getSpecificName();
        }
        if (!grantor.isFullyAccessibleByRole(name)) {
            throw Error.error(5501, dbObject.getName().name);
        }
        if (grantor.isAdmin()) {
            grantor = dbObject.getOwner();
        }
        for (i = 0; i < granteeList.size(); ++i) {
            granteeName = (String)granteeList.get(i);
            g = this.get(granteeName);
            if (g == null) {
                throw Error.error(4001, granteeName);
            }
            if (!GranteeManager.isImmutable(granteeName)) continue;
            throw Error.error(4002, granteeName);
        }
        for (i = 0; i < granteeList.size(); ++i) {
            granteeName = (String)granteeList.get(i);
            g = this.get(granteeName);
            g.revoke(dbObject, rights, grantor, grantOption);
            g.updateAllRights();
            if (!g.isRole) continue;
            this.updateAllRights(g);
        }
    }

    public void revoke(OrderedHashSet granteeList, SchemaObject[] routines, Right rights, Grantee grantor, boolean grantOption, boolean cascade) {
        for (int i = 0; i < routines.length; ++i) {
            this.revoke(granteeList, routines[i], rights, grantor, grantOption, cascade);
        }
    }

    public void updateAddColumn(HsqlNameManager.HsqlName table, HsqlNameManager.HsqlName column) {
        Grantee grantee;
        Iterator it = this.getRoles().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            grantee.updateRightsForNewColumn(table, column);
        }
        it = this.getGrantees().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            grantee.updateRightsForNewColumn(table, column);
        }
        this.updateAddColumn(table);
    }

    private void updateAddColumn(HsqlNameManager.HsqlName table) {
        Grantee grantee;
        Iterator it = this.getRoles().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            grantee.updateRightsForNewColumn(table);
        }
        it = this.getGrantees().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            grantee.updateRightsForNewColumn(table);
        }
    }

    void removeEmptyRole(Grantee role) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee grantee = (Grantee)this.map.get(i);
            grantee.roles.remove(role);
        }
    }

    public void removeDbObject(HsqlNameManager.HsqlName name) {
        for (int i = 0; i < this.map.size(); ++i) {
            Grantee g = (Grantee)this.map.get(i);
            g.revokeDbObject(name);
        }
    }

    public void removeDbObjects(OrderedHashSet nameSet) {
        Iterator it = nameSet.iterator();
        while (it.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            for (int i = 0; i < this.map.size(); ++i) {
                Grantee g = (Grantee)this.map.get(i);
                g.revokeDbObject(name);
            }
        }
    }

    void updateAllRights(Grantee role) {
        Grantee grantee;
        int i;
        for (i = 0; i < this.map.size(); ++i) {
            grantee = (Grantee)this.map.get(i);
            if (!grantee.isRole) continue;
            grantee.updateNestedRoles(role);
        }
        for (i = 0; i < this.map.size(); ++i) {
            grantee = (Grantee)this.map.get(i);
            if (grantee.isRole) continue;
            grantee.updateAllRights();
        }
    }

    public boolean removeGrantee(String name) {
        if (GranteeManager.isReserved(name)) {
            return false;
        }
        Grantee g = (Grantee)this.map.remove(name);
        if (g == null) {
            return false;
        }
        g.clearPrivileges();
        this.updateAllRights(g);
        if (g.isRole) {
            this.roleMap.remove(name);
            this.removeEmptyRole(g);
        }
        return true;
    }

    public Grantee addRole(HsqlNameManager.HsqlName name) {
        if (this.map.containsKey(name.name)) {
            throw Error.error(4003, name.name);
        }
        if ("_SYSTEM".equals(name.name)) {
            throw Error.error(4002, name.name);
        }
        if (SqlInvariants.isLobsSchemaName(name.name) || SqlInvariants.isSystemSchemaName(name.name)) {
            throw Error.error(4002, name.name);
        }
        Grantee g = new Grantee(name, this);
        g.isRole = true;
        this.map.put(name.name, g);
        this.roleMap.add(name.name, g);
        return g;
    }

    public User addUser(HsqlNameManager.HsqlName name) {
        if (this.map.containsKey(name.name)) {
            throw Error.error(4003, name.name);
        }
        if ("_SYSTEM".equals(name.name)) {
            throw Error.error(4002, name.name);
        }
        if (SqlInvariants.isLobsSchemaName(name.name) || SqlInvariants.isSystemSchemaName(name.name)) {
            throw Error.error(4002, name.name);
        }
        User g = new User(name, this);
        this.map.put(name.name, g);
        return g;
    }

    public void removeNewUser(HsqlNameManager.HsqlName name) {
        this.map.remove(name.name);
    }

    boolean isGrantee(String name) {
        return this.map.containsKey(name);
    }

    public static int getCheckSingleRight(String token) {
        int r = GranteeManager.getRight(token);
        if (r != 0) {
            return r;
        }
        throw Error.error(5581, token);
    }

    public static int getRight(String token) {
        return rightsStringLookup.get((Object)token, 0);
    }

    public Grantee get(String name) {
        return (Grantee)this.map.get(name);
    }

    public Collection getGrantees() {
        return this.map.values();
    }

    public static boolean validRightString(String rightString) {
        return GranteeManager.getRight(rightString) != 0;
    }

    public static boolean isImmutable(String name) {
        return name.equals("_SYSTEM") || name.equals("DBA") || name.equals("CREATE_SCHEMA") || name.equals("CHANGE_AUTHORIZATION") || name.equals("SCRIPT_OPS");
    }

    public static boolean isReserved(String name) {
        return name.equals("_SYSTEM") || name.equals("DBA") || name.equals("CREATE_SCHEMA") || name.equals("CHANGE_AUTHORIZATION") || name.equals("SCRIPT_OPS") || name.equals("PUBLIC");
    }

    public void dropRole(String name) {
        if (!this.isRole(name)) {
            throw Error.error(2200, name);
        }
        if (GranteeManager.isReserved(name)) {
            throw Error.error(5507);
        }
        this.removeGrantee(name);
    }

    public Set getRoleNames() {
        return this.roleMap.keySet();
    }

    public Collection getRoles() {
        return this.roleMap.values();
    }

    public Grantee getRole(String name) {
        Grantee g = (Grantee)this.roleMap.get(name);
        if (g == null) {
            throw Error.error(2200, name);
        }
        return g;
    }

    public boolean isRole(String name) {
        return this.roleMap.containsKey(name);
    }

    public String[] getSQL() {
        Grantee grantee;
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        Iterator it = this.getRoles().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            if (GranteeManager.isReserved(grantee.getName().getNameString())) continue;
            list.add(grantee.getSQL());
        }
        it = this.getGrantees().iterator();
        while (it.hasNext()) {
            grantee = (Grantee)it.next();
            if (!(grantee instanceof User) || ((User)grantee).isExternalOnly) continue;
            list.add(grantee.getSQL());
            if (!((User)grantee).isLocalOnly) continue;
            list.add(((User)grantee).getLocalUserSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getRightsSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator grantees = this.getGrantees().iterator();
        while (grantees.hasNext()) {
            Grantee grantee = (Grantee)grantees.next();
            String name = grantee.getName().getNameString();
            if (GranteeManager.isImmutable(name) || grantee instanceof User && ((User)grantee).isExternalOnly) continue;
            HsqlArrayList subList = grantee.getRightsSQL();
            list.addAll((Collection)subList);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void setDigestAlgo(String algo) {
        this.digestAlgo = algo;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    synchronized MessageDigest getDigester() {
        if (this.digester == null) {
            try {
                this.digester = MessageDigest.getInstance(this.digestAlgo);
            }
            catch (NoSuchAlgorithmException e) {
                throw Error.error(458, e);
            }
        }
        return this.digester;
    }

    String digest(String string) throws RuntimeException {
        byte[] data = string.getBytes(JavaSystem.CS_ISO_8859_1);
        data = this.getDigester().digest(data);
        return StringConverter.byteArrayToHexString(data);
    }

    static {
        HsqlNameManager.HsqlName name = HsqlNameManager.newSystemObjectName("_SYSTEM", 11);
        systemAuthorisation = new User(name, null);
        GranteeManager.systemAuthorisation.isSystem = true;
        systemAuthorisation.setAdminDirect();
        systemAuthorisation.setInitialSchema(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SESSION_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SYSTEM_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.LOBS_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        SqlInvariants.SQLJ_SCHEMA_HSQLNAME.owner = systemAuthorisation;
        rightsStringLookup = new IntValueHashMap(7);
        rightsStringLookup.put("ALL", 63);
        rightsStringLookup.put("SELECT", 1);
        rightsStringLookup.put("UPDATE", 8);
        rightsStringLookup.put("DELETE", 2);
        rightsStringLookup.put("INSERT", 4);
        rightsStringLookup.put("EXECUTE", 32);
        rightsStringLookup.put("USAGE", 16);
        rightsStringLookup.put("REFERENCES", 64);
        rightsStringLookup.put("TRIGGER", 128);
    }
}

