/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public final class Right {
    boolean isFull;
    boolean isFullSelect;
    boolean isFullInsert;
    boolean isFullUpdate;
    boolean isFullDelete;
    boolean isFullReferences;
    boolean isFullTrigger;
    boolean isFullExecute;
    boolean isFullUsage;
    OrderedHashSet selectColumnSet;
    OrderedHashSet insertColumnSet;
    OrderedHashSet updateColumnSet;
    OrderedHashSet referencesColumnSet;
    OrderedHashSet triggerColumnSet;
    Expression selectFilter;
    Expression insertFilter;
    Expression deleteFilter;
    Expression updateFilter;
    String selectFilterSQL;
    String insertFilterSQL;
    String deleteFilterSQL;
    String updateFilterSQL;
    Right grantableRights;
    Grantee grantor;
    Grantee grantee;
    public static final OrderedHashSet emptySet = new OrderedHashSet();
    public static final Right fullRights = new Right(true);
    public static final Right noRights = new Right();
    public static final String[] tablePrivilegeNames;
    public static final int[] tablePrivilegeTypes;

    public Right() {
        this.isFull = false;
    }

    public Right(boolean full) {
        this.isFull = full;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public Grantee getGrantor() {
        return this.grantor;
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public Right getGrantableRights() {
        return this.grantableRights == null ? noRights : this.grantableRights;
    }

    Right duplicate() {
        Right right = new Right();
        right.add(this);
        right.selectFilter = this.selectFilter;
        right.selectFilterSQL = this.selectFilterSQL;
        right.deleteFilter = this.deleteFilter;
        right.deleteFilterSQL = this.deleteFilterSQL;
        right.insertFilter = this.insertFilter;
        right.insertFilterSQL = this.insertFilterSQL;
        right.updateFilter = this.updateFilter;
        right.updateFilterSQL = this.updateFilterSQL;
        return right;
    }

    public void setFilterExpression(Expression filter, String sql) {
        if (this.canAccess(1)) {
            this.selectFilter = filter;
            this.selectFilterSQL = sql;
        }
        if (this.canAccess(2)) {
            this.deleteFilter = filter;
            this.deleteFilterSQL = sql;
        }
        if (this.canAccess(4)) {
            this.insertFilter = filter;
            this.insertFilterSQL = sql;
        }
        if (this.canAccess(8)) {
            this.updateFilter = filter;
            this.updateFilterSQL = sql;
        }
    }

    public void setFilterExpression(int rightType, Expression filter, String sql) {
        switch (rightType) {
            case 1: {
                this.selectFilter = filter;
                this.selectFilterSQL = sql;
                break;
            }
            case 2: {
                this.deleteFilter = filter;
                this.deleteFilterSQL = sql;
                break;
            }
            case 4: {
                this.insertFilter = filter;
                this.insertFilterSQL = sql;
                break;
            }
            case 8: {
                this.updateFilter = filter;
                this.updateFilterSQL = sql;
                break;
            }
        }
    }

    void add(Right right) {
        if (this.isFull) {
            return;
        }
        if (right.isFull) {
            this.clear();
            this.isFull = true;
            return;
        }
        this.isFullSelect |= right.isFullSelect;
        this.isFullInsert |= right.isFullInsert;
        this.isFullUpdate |= right.isFullUpdate;
        this.isFullReferences |= right.isFullReferences;
        this.isFullDelete |= right.isFullDelete;
        if (this.isFullSelect) {
            this.selectColumnSet = null;
        } else {
            if (right.selectColumnSet != null) {
                if (this.selectColumnSet == null) {
                    this.selectColumnSet = new OrderedHashSet();
                }
                this.selectColumnSet.addAll(right.selectColumnSet);
            }
            if (right.selectFilter != null) {
                this.selectFilter = right.selectFilter;
                this.selectFilterSQL = right.selectFilterSQL;
            }
        }
        if (this.isFullInsert) {
            this.insertColumnSet = null;
        } else if (right.insertColumnSet != null) {
            if (this.insertColumnSet == null) {
                this.insertColumnSet = new OrderedHashSet();
            }
            this.insertColumnSet.addAll(right.insertColumnSet);
        }
        if (this.isFullUpdate) {
            this.updateColumnSet = null;
        } else if (right.updateColumnSet != null) {
            if (this.updateColumnSet == null) {
                this.updateColumnSet = new OrderedHashSet();
            }
            this.updateColumnSet.addAll(right.updateColumnSet);
        }
        if (this.isFullReferences) {
            this.referencesColumnSet = null;
        } else if (right.referencesColumnSet != null) {
            if (this.referencesColumnSet == null) {
                this.referencesColumnSet = new OrderedHashSet();
            }
            this.referencesColumnSet.addAll(right.referencesColumnSet);
        }
        if (this.isFullTrigger) {
            this.triggerColumnSet = null;
        } else if (right.triggerColumnSet != null) {
            if (this.triggerColumnSet == null) {
                this.triggerColumnSet = new OrderedHashSet();
            }
            this.triggerColumnSet.addAll(right.triggerColumnSet);
        }
    }

    void remove(SchemaObject object, Right right) {
        if (right.isFull) {
            this.clear();
            return;
        }
        if (this.isFull) {
            this.isFull = false;
            this.isFullDelete = true;
            this.isFullReferences = true;
            this.isFullUpdate = true;
            this.isFullInsert = true;
            this.isFullSelect = true;
        }
        if (right.isFullDelete) {
            this.isFullDelete = false;
        }
        if (this.isFullSelect || this.selectColumnSet != null) {
            if (right.isFullSelect) {
                this.isFullSelect = false;
                this.selectColumnSet = null;
            } else if (right.selectColumnSet != null) {
                if (this.isFullSelect) {
                    this.isFullSelect = false;
                    this.selectColumnSet = ((Table)object).getColumnNameSet();
                }
                this.selectColumnSet.removeAll(right.selectColumnSet);
                if (this.selectColumnSet.isEmpty()) {
                    this.selectColumnSet = null;
                }
            }
        }
        if (this.isFullInsert || this.insertColumnSet != null) {
            if (right.isFullInsert) {
                this.isFullInsert = false;
                this.insertColumnSet = null;
            } else if (right.insertColumnSet != null) {
                if (this.isFullInsert) {
                    this.isFullInsert = false;
                    this.insertColumnSet = ((Table)object).getColumnNameSet();
                }
                this.insertColumnSet.removeAll(right.insertColumnSet);
                if (this.insertColumnSet.isEmpty()) {
                    this.insertColumnSet = null;
                }
            }
        }
        if (this.isFullUpdate || this.updateColumnSet != null) {
            if (right.isFullUpdate) {
                this.isFullUpdate = false;
                this.updateColumnSet = null;
            } else if (right.updateColumnSet != null) {
                if (this.isFullUpdate) {
                    this.isFullUpdate = false;
                    this.updateColumnSet = ((Table)object).getColumnNameSet();
                }
                this.updateColumnSet.removeAll(right.updateColumnSet);
                if (this.updateColumnSet.isEmpty()) {
                    this.updateColumnSet = null;
                }
            }
        }
        if (this.isFullReferences || this.referencesColumnSet != null) {
            if (right.isFullReferences) {
                this.isFullReferences = false;
                this.referencesColumnSet = null;
            } else if (right.referencesColumnSet != null) {
                if (this.isFullReferences) {
                    this.isFullReferences = false;
                    this.referencesColumnSet = ((Table)object).getColumnNameSet();
                }
                this.referencesColumnSet.removeAll(right.referencesColumnSet);
                if (this.referencesColumnSet.isEmpty()) {
                    this.referencesColumnSet = null;
                }
            }
        }
        if (this.isFullTrigger || this.triggerColumnSet != null) {
            if (right.isFullTrigger) {
                this.isFullTrigger = false;
                this.triggerColumnSet = null;
            } else if (right.triggerColumnSet != null) {
                if (this.isFullTrigger) {
                    this.isFullTrigger = false;
                    this.triggerColumnSet = ((Table)object).getColumnNameSet();
                }
                this.triggerColumnSet.removeAll(right.triggerColumnSet);
                if (this.triggerColumnSet.isEmpty()) {
                    this.triggerColumnSet = null;
                }
            }
        }
    }

    void clear() {
        this.isFullDelete = false;
        this.isFullReferences = false;
        this.isFullUpdate = false;
        this.isFullInsert = false;
        this.isFullSelect = false;
        this.isFull = false;
        this.triggerColumnSet = null;
        this.referencesColumnSet = null;
        this.updateColumnSet = null;
        this.insertColumnSet = null;
        this.selectColumnSet = null;
    }

    boolean isEmpty() {
        if (this.isFull || this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences || this.isFullDelete) {
            return false;
        }
        if (this.selectColumnSet != null && !this.selectColumnSet.isEmpty()) {
            return false;
        }
        if (this.insertColumnSet != null && !this.insertColumnSet.isEmpty()) {
            return false;
        }
        if (this.updateColumnSet != null && !this.updateColumnSet.isEmpty()) {
            return false;
        }
        if (this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty()) {
            return false;
        }
        return this.triggerColumnSet == null || this.triggerColumnSet.isEmpty();
    }

    OrderedHashSet getColumnsForAllRights(Table table) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullReferences) {
            return table.getColumnNameSet();
        }
        OrderedHashSet set = new OrderedHashSet();
        if (this.selectColumnSet != null) {
            set.addAll(this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            set.addAll(this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            set.addAll(this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            set.addAll(this.referencesColumnSet);
        }
        return set;
    }

    boolean contains(Right right) {
        if (this.isFull) {
            return true;
        }
        if (right.isFull) {
            return false;
        }
        if (!Right.containsRights(this.isFullSelect, this.selectColumnSet, right.selectColumnSet, right.isFullSelect)) {
            return false;
        }
        if (!Right.containsRights(this.isFullInsert, this.insertColumnSet, right.insertColumnSet, right.isFullInsert)) {
            return false;
        }
        if (!Right.containsRights(this.isFullUpdate, this.updateColumnSet, right.updateColumnSet, right.isFullUpdate)) {
            return false;
        }
        if (!Right.containsRights(this.isFullReferences, this.referencesColumnSet, right.referencesColumnSet, right.isFullReferences)) {
            return false;
        }
        if (!Right.containsRights(this.isFullTrigger, this.triggerColumnSet, right.triggerColumnSet, right.isFullTrigger)) {
            return false;
        }
        return this.isFullDelete || !right.isFullDelete;
    }

    void removeDroppedColumns(OrderedHashSet columnSet, Table table) {
        for (int i = 0; i < columnSet.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)columnSet.get(i);
            if (table.findColumn(name.name) < 0) continue;
            columnSet.remove(i);
            --i;
        }
    }

    public OrderedHashSet getColumnsForPrivilege(Table table, int type) {
        if (this.isFull) {
            return table.getColumnNameSet();
        }
        switch (type) {
            case 1: {
                return this.isFullSelect ? table.getColumnNameSet() : (this.selectColumnSet == null ? emptySet : this.selectColumnSet);
            }
            case 4: {
                return this.isFullInsert ? table.getColumnNameSet() : (this.insertColumnSet == null ? emptySet : this.insertColumnSet);
            }
            case 8: {
                return this.isFullUpdate ? table.getColumnNameSet() : (this.updateColumnSet == null ? emptySet : this.updateColumnSet);
            }
            case 64: {
                return this.isFullReferences ? table.getColumnNameSet() : (this.referencesColumnSet == null ? emptySet : this.referencesColumnSet);
            }
            case 128: {
                return this.isFullTrigger ? table.getColumnNameSet() : (this.triggerColumnSet == null ? emptySet : this.triggerColumnSet);
            }
        }
        return emptySet;
    }

    static boolean containsAllColumns(OrderedHashSet columnSet, Table table, boolean[] columnCheckList) {
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            if (columnSet == null) {
                return false;
            }
            if (columnSet.contains(table.getColumn(i).getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean containsRights(boolean isFull, OrderedHashSet columnSet, OrderedHashSet otherColumnSet, boolean otherIsFull) {
        if (isFull) {
            return true;
        }
        if (otherIsFull) {
            return false;
        }
        return otherColumnSet == null || columnSet != null && columnSet.containsAll(otherColumnSet);
    }

    boolean canSelect(Table table, boolean[] columnCheckList) {
        if (this.isFull || this.isFullSelect) {
            return true;
        }
        return Right.containsAllColumns(this.selectColumnSet, table, columnCheckList);
    }

    boolean canInsert(Table table, boolean[] columnCheckList) {
        if (this.isFull || this.isFullInsert) {
            return true;
        }
        return Right.containsAllColumns(this.insertColumnSet, table, columnCheckList);
    }

    boolean canUpdate(Table table, boolean[] columnCheckList) {
        if (this.isFull || this.isFullUpdate) {
            return true;
        }
        return Right.containsAllColumns(this.updateColumnSet, table, columnCheckList);
    }

    boolean canReference(Table table, boolean[] columnCheckList) {
        if (this.isFull || this.isFullReferences) {
            return true;
        }
        return Right.containsAllColumns(this.referencesColumnSet, table, columnCheckList);
    }

    boolean canTrigger(Table table, boolean[] columnCheckList) {
        if (this.isFull || this.isFullTrigger) {
            return true;
        }
        return Right.containsAllColumns(this.triggerColumnSet, table, columnCheckList);
    }

    boolean canDelete() {
        return this.isFull || this.isFullDelete;
    }

    boolean canAccessNonSelect() {
        if (this.isFull) {
            return true;
        }
        if (this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean result = false;
        result |= this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
        result |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        result |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        return result |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
    }

    public boolean canAccess(int action) {
        if (this.isFull) {
            return true;
        }
        switch (action) {
            case 2: {
                return this.isFullDelete;
            }
            case 1: {
                if (this.isFullSelect) {
                    return true;
                }
                return this.selectColumnSet != null && !this.selectColumnSet.isEmpty();
            }
            case 4: {
                if (this.isFullInsert) {
                    return true;
                }
                return this.insertColumnSet != null && !this.insertColumnSet.isEmpty();
            }
            case 8: {
                if (this.isFullUpdate) {
                    return true;
                }
                return this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
            }
            case 64: {
                if (this.isFullReferences) {
                    return true;
                }
                return this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
            }
            case 128: {
                if (this.isFullTrigger) {
                    return true;
                }
                return this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty();
            }
            case 32: {
                return this.isFull;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    boolean canAccess(Table table, int[] columnMap) {
        if (this.isFull) {
            return true;
        }
        if (this.isFullSelect || this.isFullInsert || this.isFullUpdate || this.isFullDelete || this.isFullReferences || this.isFullTrigger) {
            return true;
        }
        boolean result = false;
        result |= this.selectColumnSet != null && this.insertColumnSet.isEmpty();
        result |= this.insertColumnSet != null && this.insertColumnSet.isEmpty();
        result |= this.updateColumnSet != null && !this.updateColumnSet.isEmpty();
        result |= this.referencesColumnSet != null && !this.referencesColumnSet.isEmpty();
        if (!(result |= this.triggerColumnSet != null && !this.triggerColumnSet.isEmpty())) {
            return false;
        }
        HashSet set = new HashSet();
        set.addAll(this.selectColumnSet);
        set.addAll(this.insertColumnSet);
        set.addAll(this.updateColumnSet);
        set.addAll(this.referencesColumnSet);
        set.addAll(this.triggerColumnSet);
        for (int i = 0; i < columnMap.length; ++i) {
            if (set.contains(table.getColumn(i).getName())) continue;
            return false;
        }
        return result;
    }

    public Expression getFilterExpression(int action) {
        switch (action) {
            case 1: {
                return this.selectFilter;
            }
            case 2: {
                return this.deleteFilter;
            }
            case 4: {
                return this.insertFilter;
            }
            case 8: {
                return this.updateFilter;
            }
        }
        throw Error.runtimeError(201, "Right");
    }

    public Expression[] getFiltersArray() {
        return new Expression[]{this.selectFilter, this.deleteFilter, this.insertFilter, this.updateFilter};
    }

    boolean hasFilter() {
        return this.selectFilter != null || this.deleteFilter != null || this.insertFilter != null || this.updateFilter != null;
    }

    String getTableRightsSQL(Table table) {
        StringBuilder sb = new StringBuilder();
        if (this.isFull) {
            return "ALL";
        }
        if (this.isFullSelect) {
            sb.append("SELECT");
            Right.appendFilterSQL(this.selectFilterSQL, sb);
            sb.append(',');
        } else if (this.selectColumnSet != null) {
            sb.append("SELECT");
            Right.appendColumnList(table, this.selectColumnSet, sb);
            Right.appendFilterSQL(this.selectFilterSQL, sb);
            sb.append(',');
        }
        if (this.isFullInsert) {
            sb.append("INSERT");
            Right.appendFilterSQL(this.insertFilterSQL, sb);
            sb.append(',');
        } else if (this.insertColumnSet != null) {
            sb.append("INSERT");
            Right.appendColumnList(table, this.insertColumnSet, sb);
            Right.appendFilterSQL(this.insertFilterSQL, sb);
            sb.append(',');
        }
        if (this.isFullUpdate) {
            sb.append("UPDATE");
            Right.appendFilterSQL(this.updateFilterSQL, sb);
            sb.append(',');
        } else if (this.updateColumnSet != null) {
            sb.append("UPDATE");
            Right.appendColumnList(table, this.updateColumnSet, sb);
            Right.appendFilterSQL(this.updateFilterSQL, sb);
            sb.append(',');
        }
        if (this.isFullDelete) {
            sb.append("DELETE");
            Right.appendFilterSQL(this.deleteFilterSQL, sb);
            sb.append(',');
        }
        if (this.isFullReferences) {
            sb.append("REFERENCES");
            sb.append(',');
        } else if (this.referencesColumnSet != null) {
            sb.append("REFERENCES");
            sb.append(',');
        }
        if (this.isFullTrigger) {
            sb.append("TRIGGER");
            sb.append(',');
        } else if (this.triggerColumnSet != null) {
            sb.append("TRIGGER");
            sb.append(',');
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    static void appendFilterSQL(String sql, StringBuilder sb) {
        if (sql == null) {
            return;
        }
        sb.append(' ');
        sb.append(sql);
    }

    private static void appendColumnList(Table t, OrderedHashSet set, StringBuilder buf) {
        int i;
        int count = 0;
        boolean[] colCheckList = t.getNewColumnCheckList();
        for (i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            int colIndex = t.findColumn(name.name);
            if (colIndex == -1) continue;
            colCheckList[colIndex] = true;
            ++count;
        }
        if (count == 0) {
            throw Error.runtimeError(201, "Right");
        }
        buf.append('(');
        int colCount = 0;
        for (i = 0; i < colCheckList.length; ++i) {
            if (!colCheckList[i]) continue;
            buf.append(t.getColumn((int)i).getName().statementName);
            if (++colCount >= count) continue;
            buf.append(',');
        }
        buf.append(')');
    }

    void addNewColumn(HsqlNameManager.HsqlName name) {
        if (this.selectColumnSet != null) {
            this.selectColumnSet.add(name);
        }
        if (this.insertColumnSet != null) {
            this.insertColumnSet.add(name);
        }
        if (this.updateColumnSet != null) {
            this.updateColumnSet.add(name);
        }
        if (this.referencesColumnSet != null) {
            this.referencesColumnSet.add(name);
        }
        if (this.triggerColumnSet != null) {
            this.triggerColumnSet.add(name);
        }
    }

    public void setColumns(Table table) {
        if (this.selectColumnSet != null) {
            Right.setColumns(table, this.selectColumnSet);
        }
        if (this.insertColumnSet != null) {
            Right.setColumns(table, this.insertColumnSet);
        }
        if (this.updateColumnSet != null) {
            Right.setColumns(table, this.updateColumnSet);
        }
        if (this.referencesColumnSet != null) {
            Right.setColumns(table, this.referencesColumnSet);
        }
        if (this.triggerColumnSet != null) {
            Right.setColumns(table, this.triggerColumnSet);
        }
    }

    private static void setColumns(Table t, OrderedHashSet set) {
        int i;
        int count = 0;
        boolean[] colCheckList = t.getNewColumnCheckList();
        for (i = 0; i < set.size(); ++i) {
            String name = (String)set.get(i);
            int colIndex = t.findColumn(name);
            if (colIndex == -1) {
                throw Error.error(5501, name);
            }
            colCheckList[colIndex] = true;
            ++count;
        }
        if (count == 0) {
            throw Error.error(5501);
        }
        set.clear();
        for (i = 0; i < colCheckList.length; ++i) {
            if (!colCheckList[i]) continue;
            set.add(t.getColumn(i).getName());
        }
    }

    public void set(int type, OrderedHashSet set) {
        switch (type) {
            case 1: {
                if (set == null) {
                    this.isFullSelect = true;
                }
                this.selectColumnSet = set;
                break;
            }
            case 2: {
                if (set != null) break;
                this.isFullDelete = true;
                break;
            }
            case 4: {
                if (set == null) {
                    this.isFullInsert = true;
                }
                this.insertColumnSet = set;
                break;
            }
            case 8: {
                if (set == null) {
                    this.isFullUpdate = true;
                }
                this.updateColumnSet = set;
                break;
            }
            case 64: {
                if (set == null) {
                    this.isFullReferences = true;
                }
                this.referencesColumnSet = set;
                break;
            }
            case 128: {
                if (set == null) {
                    this.isFullTrigger = true;
                }
                this.triggerColumnSet = set;
                break;
            }
            case 32: {
                this.isFullExecute = true;
                break;
            }
            case 16: {
                this.isFullUsage = true;
                break;
            }
        }
    }

    static {
        Right.fullRights.grantor = GranteeManager.systemAuthorisation;
        tablePrivilegeNames = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE", "REFERENCES", "TRIGGER"};
        tablePrivilegeTypes = new int[]{1, 4, 8, 2, 64, 128};
    }
}

