/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    public boolean isLocalOnly;
    public boolean isExternalOnly;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName name, GranteeManager manager) {
        super(name, manager);
        if (manager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE").append(' ').append("USER");
        sb.append(' ').append(this.granteeName.statementName).append(' ');
        sb.append("PASSWORD").append(' ').append("DIGEST");
        sb.append(' ').append('\'').append(this.password).append('\'');
        return sb.toString();
    }

    public String getPasswordDigest() {
        return this.password;
    }

    public void setPassword(String password, boolean isDigest) {
        if (!isDigest) {
            password = this.granteeManager.digest(password);
        }
        this.password = password;
    }

    public void checkPassword(String value) {
        String digest = this.granteeManager.digest(value);
        if (!digest.equals(this.password)) {
            throw Error.error(4000, this.granteeName.statementName);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName schema = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getName().getNameString());
        if (schema == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return schema;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName schema) {
        this.initialSchema = schema;
    }

    public String getInitialSchemaSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getName().getStatementName()).append(' ');
        sb.append("SET").append(' ');
        sb.append("INITIAL").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.initialSchema.getStatementName());
        return sb.toString();
    }

    public String getLocalUserSQL() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getName().getStatementName()).append(' ');
        sb.append("SET").append(' ').append("LOCAL");
        sb.append(' ').append("TRUE");
        return sb.toString();
    }

    public String getSetUserPasswordDigestSQL(String password, boolean isDigest) {
        if (!isDigest) {
            password = this.granteeManager.digest(password);
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getName().getStatementName()).append(' ');
        sb.append("SET").append(' ');
        sb.append("PASSWORD").append(' ').append("DIGEST");
        sb.append(' ').append('\'').append(password).append('\'');
        return sb.toString();
    }

    public static String getSetCurrentPasswordDigestSQL(GranteeManager manager, String password, boolean isDigest) {
        if (!isDigest) {
            password = manager.digest(password);
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("SET").append(' ');
        sb.append("PASSWORD").append(' ').append("DIGEST");
        sb.append(' ').append('\'').append(password).append('\'');
        return sb.toString();
    }

    public String getConnectUserSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("SET").append(' ');
        sb.append("SESSION").append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(StringConverter.toQuotedString(this.getName().getNameString(), '\'', true));
        return sb.toString();
    }
}

