/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.error.Error;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;

public class RowInputTextQuoted
extends RowInputText {
    private static final int NORMAL_FIELD = 0;
    private static final int NEED_END_QUOTE = 1;
    private static final int FOUND_QUOTE = 2;
    private final char quoteChar;
    int charLength = 0;

    public RowInputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
        this.quoteChar = textFileSettings.quoteChar;
    }

    @Override
    public void setSource(String text, long pos, int byteSize) {
        super.setSource(text, pos, byteSize);
        this.charLength = text.length();
        for (int i = this.charLength - 1; i > -1 && (text.charAt(i) == '\r' || text.charAt(i) == '\n'); --i) {
            --this.charLength;
        }
    }

    @Override
    protected String getField(String sep, int sepLen, boolean isEnd) {
        String s = null;
        if (this.next >= this.charLength || this.text.charAt(this.next) != this.quoteChar) {
            return super.getField(sep, sepLen, isEnd);
        }
        try {
            ++this.field;
            StringBuilder sb = new StringBuilder();
            boolean done = false;
            int state = 0;
            int end = -1;
            if (!isEnd) {
                end = this.text.indexOf(sep, this.next);
            }
            while (this.next < this.charLength) {
                switch (state) {
                    default: {
                        if (this.next == end) {
                            this.next += sepLen;
                            done = true;
                            break;
                        }
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            state = 1;
                            break;
                        }
                        sb.append(this.text.charAt(this.next));
                        break;
                    }
                    case 1: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            state = 2;
                            break;
                        }
                        sb.append(this.text.charAt(this.next));
                        break;
                    }
                    case 2: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            sb.append(this.text.charAt(this.next));
                            state = 1;
                            break;
                        }
                        if (!isEnd) {
                            end = this.text.indexOf(sep, this.next);
                            if (end < 0) {
                                end = this.charLength;
                            }
                            sb.append(this.text, this.next, end);
                            this.next = end + sepLen;
                            done = true;
                            break;
                        }
                        this.next += sepLen - 1;
                        state = 0;
                    }
                }
                if (done) break;
                ++this.next;
            }
            s = sb.toString();
        }
        catch (Exception e) {
            String message = String.valueOf(this.field);
            throw Error.error(e, 41, message);
        }
        return s;
    }
}

