/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected TextFileSettings textFileSettings;

    public RowOutputText(TextFileSettings textFileSettings) {
        this.initTextDatabaseRowOutput(textFileSettings);
    }

    private void initTextDatabaseRowOutput(TextFileSettings textFileSettings) {
        this.textFileSettings = textFileSettings;
        this.fieldSep = textFileSettings.fs;
        this.varSep = textFileSettings.vs;
        this.longvarSep = textFileSettings.lvs;
        if (this.fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            this.fieldSep = this.fieldSep.substring(0, this.fieldSep.length() - 1);
        }
        if (this.varSep.endsWith("\n")) {
            this.varSepEnd = true;
            this.varSep = this.varSep.substring(0, this.varSep.length() - 1);
        }
        if (this.longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            this.longvarSep = this.longvarSep.substring(0, this.longvarSep.length() - 1);
        }
    }

    @Override
    public long scaleFilePosition(long pos) {
        return pos;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public void setMode(int mode) {
    }

    @Override
    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextFileSettings.NL);
    }

    @Override
    public void writeSize(int size) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    @Override
    public void writeType(int type) {
    }

    @Override
    public void writeString(String s) {
        if ((s = this.checkConvertString(s, this.fieldSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String s) {
        if ((s = this.checkConvertString(s, this.varSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String s) {
        if ((s = this.checkConvertString(s, this.longvarSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String s, String sep) {
        if (s.indexOf(10) != -1 || s.indexOf(13) != -1) {
            throw new IllegalArgumentException(Error.getMessage(485));
        }
        if (s.contains(sep)) {
            return null;
        }
        return s;
    }

    private byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.textFileSettings.charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw Error.error(484, e);
        }
        return bytes;
    }

    protected void writeByteArray(byte[] b) {
        if (this.textFileSettings.isUTF16) {
            byte[] buffer = new byte[b.length * 2];
            StringConverter.writeHexBytes(buffer, 0, b);
            String s = new String(buffer);
            this.writeBytes(s);
        } else {
            this.ensureRoom(b.length * 2);
            StringConverter.writeHexBytes(this.getBuffer(), this.count, b);
            this.count += b.length * 2;
        }
    }

    @Override
    public void writeShort(int i) {
        this.writeInt(i);
    }

    @Override
    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    @Override
    public void writeLong(long i) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public void writeBytes(byte[] b) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeBytes(String s) {
        if (this.textFileSettings.isUTF16) {
            try {
                if (s.length() <= 0) return;
                byte[] bytes = s.getBytes(this.textFileSettings.charEncoding);
                super.write(bytes);
                return;
            }
            catch (UnsupportedEncodingException e) {
                throw Error.error(484, e);
            }
        } else {
            super.writeBytes(s);
        }
    }

    @Override
    protected void writeFieldType(Type type) {
        this.writeBytes(this.nextSep);
        switch (type.typeCode) {
            case 12: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    @Override
    protected void writeNull(Type type) {
        this.writeFieldType(type);
    }

    @Override
    protected void writeChar(String s, Type t) {
        switch (t.typeCode) {
            case 1: {
                this.writeString(s);
                break;
            }
            case 12: {
                this.writeVarString(s);
                break;
            }
            default: {
                this.writeLongVarString(s);
            }
        }
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeReal(Double o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.writeString(o.toString());
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    @Override
    protected void writeOther(JavaObjectData o) {
        byte[] ba = o.getBytes();
        this.writeByteArray(ba);
    }

    @Override
    protected void writeBit(BinaryData o) {
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeString(s);
    }

    @Override
    protected void writeUUID(BinaryData o) {
        String s = StringConverter.toStringUUID(o.getBytes());
        this.writeString(s);
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    @Override
    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception e) {
            this.reset();
        }
        int rowsize = this.size();
        this.reset();
        return rowsize;
    }

    @Override
    public int getStorageSize(int size) {
        return size;
    }

    @Override
    public void reset() {
        super.reset();
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }
}

