/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputTextLog
extends RowOutputBase {
    private static byte[] BYTES_NULL = "NULL".getBytes(JavaSystem.CS_ISO_8859_1);
    private static byte[] BYTES_TRUE = "TRUE".getBytes(JavaSystem.CS_ISO_8859_1);
    private static byte[] BYTES_FALSE = "FALSE".getBytes(JavaSystem.CS_ISO_8859_1);
    private static byte[] BYTES_AND = " AND ".getBytes(JavaSystem.CS_ISO_8859_1);
    private static byte[] BYTES_IS = " IS ".getBytes(JavaSystem.CS_ISO_8859_1);
    private static byte[] BYTES_ARRAY = " ARRAY[".getBytes(JavaSystem.CS_ISO_8859_1);
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;
    private boolean noSeparators;

    @Override
    public void setMode(int mode) {
        this.logMode = mode;
    }

    @Override
    protected void writeFieldPrefix() {
        if (!this.noSeparators && this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    @Override
    protected void writeChar(String s, Type t) {
        this.write(39);
        StringConverter.stringToUnicodeBytes(this, s, true);
        this.write(39);
    }

    @Override
    protected void writeReal(Double o) {
        this.writeBytes(Type.SQL_DOUBLE.convertToSQLString(o));
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    public long scaleFilePosition(long position) {
        return position;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public void writeEnd() {
    }

    @Override
    protected void writeBit(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 8L + 2L));
        this.write(39);
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeBytes(s);
        this.write(39);
    }

    @Override
    protected void writeUUID(BinaryData o) {
        this.ensureRoom(40);
        this.write(39);
        this.count += StringConverter.writeUUIDHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.write(39);
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.ensureRoom((int)(o.length(null) * 2L + 2L));
        this.write(39);
        this.count += StringConverter.writeHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.write(39);
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeBytes(Long.toString(o.getId()));
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeBytes(Long.toString(o.getId()));
    }

    @Override
    protected void writeArray(Object[] o, Type type) {
        type = type.collectionBaseType();
        this.noSeparators = true;
        this.write(BYTES_ARRAY);
        for (int i = 0; i < o.length; ++i) {
            if (i > 0) {
                this.write(44);
            }
            this.writeData(o[i], type);
        }
        this.write(93);
        this.noSeparators = false;
    }

    @Override
    public void writeType(int type) {
    }

    @Override
    public void writeSize(int size) {
    }

    @Override
    public int getSize(Row row) {
        return 0;
    }

    @Override
    public int getStorageSize(int size) {
        return size;
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeBytes(o.toString());
    }

    @Override
    protected void writeNull(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(BYTES_IS);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
        this.write(BYTES_NULL);
    }

    @Override
    protected void writeOther(JavaObjectData o) {
        this.ensureRoom(o.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, o.getBytes());
        this.count += o.getBytesLength() * 2;
        this.write(39);
    }

    @Override
    public void writeString(String value) {
        StringConverter.stringToUnicodeBytes(this, value, false);
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.write(o != false ? BYTES_TRUE : BYTES_FALSE);
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeBytes(type.convertToSQLString(o));
    }

    @Override
    protected void writeFieldType(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(61);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
    }

    @Override
    public void writeLong(long value) {
        this.writeBytes(Long.toString(value));
    }

    @Override
    public void writeBytes(byte[] b) {
        super.write(b);
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(o));
        this.write(39);
    }

    @Override
    public void writeShort(int i) {
        this.writeBytes(Integer.toString(i));
    }

    @Override
    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
    }

    @Override
    public void reset() {
        super.reset();
        this.isWritten = false;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputTextLog");
    }
}

