/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowOutputText;

public class RowOutputTextQuoted
extends RowOutputText {
    public RowOutputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
    }

    @Override
    protected String checkConvertString(String s, String sep) {
        if (this.textFileSettings.isAllQuoted || s.length() == 0 || s.indexOf(this.textFileSettings.quoteChar) != -1 || sep.length() > 0 && s.contains(sep) || RowOutputTextQuoted.hasUnprintable(s)) {
            s = StringConverter.toQuotedString(s, this.textFileSettings.quoteChar, true);
        }
        return s;
    }

    private static boolean hasUnprintable(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isISOControl(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

