/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import org.hsqldb.Database;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;

public abstract class ScriptReaderBase {
    Database database;
    String fileNamePath;
    long lineCount;
    RowInsertInterface inserter;
    int statementType;
    int sessionNumber;
    boolean sessionChanged;
    Object[] rowData;
    long sequenceValue;
    String rawStatement;
    String statement;
    Table currentTable;
    PersistentStore currentStore;
    NumberSequence currentSequence;
    String currentSchema;
    RowInsertInterface.ErrorLogger errorLogger;

    ScriptReaderBase(Database db, String fileName) {
        this.database = db;
        this.fileNamePath = fileName;
    }

    public void setInserter(RowInsertInterface inserter) {
        this.inserter = inserter;
    }

    public abstract void readAll(Session var1);

    protected abstract void readDDL(Session var1);

    protected abstract void readExistingData(Session var1);

    public abstract boolean readLoggedStatement(Session var1);

    public String getFileNamePath() {
        return this.fileNamePath;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Object[] getData() {
        return this.rowData;
    }

    public String getLoggedStatement() {
        return this.statement;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public long getLineNumber() {
        return this.lineCount;
    }

    public abstract void close();
}

