/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.RowInsertSimple;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    InputStream inputStream;
    InputStream bufferedStream;
    GZIPInputStream gzipStream;
    RowInputTextLog rowIn;
    boolean isInsert;

    ScriptReaderText(Database db, String fileName) {
        super(db, fileName);
    }

    public ScriptReaderText(Database db, String fileName, boolean compressed) throws IOException {
        super(db, fileName);
        InputStream tempStream;
        this.inputStream = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        this.bufferedStream = new BufferedInputStream(this.inputStream);
        if (compressed) {
            this.gzipStream = new GZIPInputStream(this.bufferedStream);
            tempStream = this.gzipStream;
        } else {
            tempStream = this.bufferedStream;
        }
        this.dataStreamIn = new LineReader(tempStream, JavaSystem.CS_ISO_8859_1);
        this.rowIn = new RowInputTextLog();
    }

    @Override
    public void readAll(Session session) {
        int insertErrorMode;
        if (this.database.recoveryMode == 0) {
            this.errorLogger = new RowInsertSimple.DefaultErrorHandler();
            insertErrorMode = 3;
        } else {
            this.errorLogger = new RowInsertSimple.InsertErrorHandler(this.database, this.fileNamePath);
            insertErrorMode = 2;
        }
        this.readDDL(session);
        this.inserter = new RowInsertSimple(session, this.errorLogger, insertErrorMode);
        this.readExistingData(session);
    }

    @Override
    protected void readDDL(Session session) {
        while (true) {
            Statement cs = null;
            Result result = null;
            try {
                boolean hasRow = this.readLoggedStatement(session);
                if (!hasRow) break;
                if (this.rowIn.getStatementType() == 3) {
                    this.isInsert = true;
                    break;
                }
                cs = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(cs, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e);
            }
            if (!result.isError() || cs != null && (cs.getType() == 53 || cs.getType() == 69 && result.getMainString().contains("org.hsqldb.Library"))) continue;
            HsqlException e = this.getError(result.getException(), this.lineCount);
            this.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExistingData(Session session) {
        block15: {
            String tablename = null;
            block9: while (true) {
                while (true) {
                    HsqlException e;
                    try {
                        boolean hasRow = false;
                        if (this.isInsert) {
                            this.isInsert = false;
                            hasRow = true;
                        } else {
                            hasRow = this.readLoggedStatement(session);
                        }
                        if (!hasRow) {
                            this.inserter.finishTable();
                            break block15;
                        }
                        switch (this.statementType) {
                            case 6: {
                                session.setSchema(this.currentSchema);
                                tablename = null;
                                continue block9;
                            }
                            case 3: {
                                if (!this.rowIn.getTableName().equals(tablename)) {
                                    this.inserter.finishTable();
                                    tablename = this.rowIn.getTableName();
                                    String schema = session.getSchemaName(this.currentSchema);
                                    this.currentTable = this.database.schemaManager.getUserTable(tablename, schema);
                                    this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                                }
                                this.inserter.insert(this.currentTable, this.currentStore, this.rowData);
                                continue block9;
                            }
                        }
                        e = Error.error(458, this.statement);
                        throw e;
                    }
                    catch (Throwable t) {
                        e = this.getError(t, this.lineCount);
                        this.handleError(e);
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                this.inserter.close();
            }
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw Error.error(e, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int endid = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
            this.statement = this.statement.substring(endid + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(session, this.statement);
        this.statementType = this.rowIn.getStatementType();
        switch (this.statementType) {
            case 1: 
            case 4: {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            case 6: {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
        }
        String name = this.rowIn.getTableName();
        String schema = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(name, schema);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        this.rowData = this.rowIn.readData(colTypes);
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gzipStream != null) {
                this.gzipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.errorLogger != null) {
                this.errorLogger.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    HsqlException getError(Throwable t, long lineCount) {
        HsqlException e;
        if (t instanceof HsqlException && (e = (HsqlException)t).getErrorCode() == -461) {
            return e;
        }
        return Error.error(t, 461, 25, new String[]{String.valueOf(lineCount), t.toString()});
    }

    private void handleError(HsqlException e) {
        this.database.logger.logSevereEvent(e.getMessage(), e);
        if (this.database.recoveryMode == 0) {
            throw e;
        }
        this.errorLogger.writeLogStatement(this.lineCount, this.rawStatement);
    }
}

