/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isCompressed;
    boolean isCrypt;
    boolean isUserScript;
    boolean includeCachedData;
    boolean includeIndexRoots;
    boolean includeTableInit;
    long byteCount;
    long lineCount;
    volatile boolean needsSync;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        this.initBuffers();
        this.database = db;
        this.includeCachedData = includeCachedData;
        this.includeIndexRoots = !includeCachedData;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        this.outDescriptor = descriptor;
    }

    ScriptWriterBase(Database db, String file, boolean includeCachedData, boolean isNewFile, boolean isUserScript) {
        this.initBuffers();
        boolean exists = false;
        exists = isUserScript ? FileUtil.getFileUtil().exists(file) : db.logger.getFileAccess().isStreamElement(file);
        if (exists && isNewFile) {
            throw Error.error(452, file + " already exists");
        }
        this.database = db;
        this.isUserScript = isUserScript;
        this.includeCachedData = includeCachedData;
        this.includeIndexRoots = !includeCachedData;
        this.outFile = file;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void setIncludeIndexRoots(boolean include) {
        this.includeIndexRoots = include;
    }

    public void setIncludeCachedData(boolean include) {
        this.includeCachedData = include;
    }

    public void setIncludeTableInit(boolean include) {
        this.includeTableInit = include;
    }

    protected abstract void initBuffers();

    public void sync() {
        if (this.isClosed) {
            return;
        }
        if (this.needsSync) {
            this.forceSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSync() {
        if (this.isClosed) {
            return;
        }
        this.needsSync = false;
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException e) {
                this.database.logger.logWarningEvent("ScriptWriter synch error: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.finishStream();
                this.forceSync();
                this.fileStreamOut.close();
                this.outDescriptor = null;
                this.isClosed = true;
            }
        }
        catch (IOException e) {
            throw Error.error(452, e);
        }
        this.byteCount = 0L;
        this.lineCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        this.writeDDL();
        this.writeExistingData(true);
    }

    protected void openFile() {
        try {
            FileUtil fa = this.isUserScript ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElementAppend(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = fos;
            this.fileStreamOut = new BufferedOutputStream(fos, 16384);
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new String[]{e.toString(), this.outFile});
        }
    }

    protected void finishStream() {
    }

    public void writeDDL() {
        try {
            Result ddlPart = this.database.getScript(this.includeIndexRoots);
            this.writeSingleColumnResult(ddlPart);
        }
        catch (HsqlException e) {
            this.close();
            throw e;
        }
    }

    public void writeExistingData(boolean lobSchema) {
        this.currentSession.loggedSchema = null;
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            if (!lobSchema && "SYSTEM_LOBS".equals(schema)) continue;
            Iterator tables = this.database.schemaManager.databaseObjectIterator(schema, 3);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                boolean script = false;
                switch (t.getTableType()) {
                    case 4: {
                        script = true;
                        break;
                    }
                    case 5: {
                        script = this.includeCachedData;
                        break;
                    }
                    case 7: {
                        boolean bl = script = this.includeCachedData && !t.isDataReadOnly();
                    }
                }
                if (!script) continue;
                this.writeTableData(t);
            }
        }
        this.writeDataTerm();
    }

    public void writeVersioningData(TimestampData from) {
        this.currentSession.loggedSchema = null;
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            Iterator tables = this.database.schemaManager.databaseObjectIterator(schema, 3);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                if (!t.isSystemVersioned() || !t.hasPrimaryKey()) continue;
                this.writeTableVersionData(t, from);
            }
        }
        this.writeDataTerm();
    }

    public void writeTableData(Table t) {
        this.schemaToLog = t.getName().schema;
        try {
            this.writeTableInit(t);
            RowIterator it = t.rowIteratorForScript(t.getRowStore(this.currentSession));
            while (it.next()) {
                Row row = it.getCurrentRow();
                this.writeRow(this.currentSession, row, t);
            }
            this.writeTableTerm(t);
        }
        catch (HsqlException e) {
            this.close();
            throw e;
        }
    }

    public void writeTableVersionData(Table t, TimestampData from) {
        int startCol = t.getSystemPeriodStartIndex();
        int endCol = t.getSystemPeriodEndIndex();
        this.schemaToLog = t.getName().schema;
        try {
            this.writeTableInit(t);
            RowIterator it = t.rowIteratorForScript(t.getRowStore(this.currentSession));
            while (it.next()) {
                Row row = it.getCurrentRow();
                TimestampData start = (TimestampData)row.getField(startCol);
                TimestampData end = (TimestampData)row.getField(endCol);
                if (start.getSeconds() < from.getSeconds() && (end.getSeconds() < from.getSeconds() || end.getSeconds() >= DateTimeType.epochLimitSeconds)) continue;
                this.writeRow(this.currentSession, row, t);
            }
            this.writeTableTerm(t);
        }
        catch (HsqlException e) {
            this.close();
            throw e;
        }
    }

    public void writeTableInit(Table t) {
    }

    public void writeTableTerm(Table t) {
    }

    protected void writeSingleColumnResult(Result r) {
        RowSetNavigator nav = r.initialiseNavigator();
        while (nav.next()) {
            Object[] data = nav.getCurrent();
            this.writeLogStatement(this.currentSession, (String)data[0]);
        }
    }

    public abstract void writeRow(Session var1, Row var2, Table var3);

    protected abstract void writeDataTerm();

    protected abstract void writeSessionIdAndSchema(Session var1);

    public abstract void writeLogStatement(Session var1, String var2);

    public abstract void writeOtherStatement(Session var1, String var2);

    public abstract void writeInsertStatement(Session var1, Row var2, Table var3);

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3);

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2);

    public abstract void writeCommitStatement(Session var1);

    @Override
    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int delay) {
        this.writeDelay = delay;
    }

    public void start() {
        if (this.writeDelay > 0) {
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

