/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.Crypto;
import org.hsqldb.scriptio.ScriptWriterText;

public class ScriptWriterEncode
extends ScriptWriterText {
    Crypto crypto;
    HsqlByteArrayOutputStream byteOut;
    OutputStream cryptOut;

    public ScriptWriterEncode(Database db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCached, Crypto crypto) {
        super(db, outputStream, descriptor, includeCached);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new String[]{e.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database db, String file, boolean includeCached, Crypto crypto) {
        super(db, file, includeCached, true, false);
        try {
            this.cryptOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.cryptOut);
            this.isCrypt = true;
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new String[]{e.toString(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database db, String file, Crypto crypto) {
        super(db, file, false, false, false);
        this.crypto = crypto;
        this.byteOut = new HsqlByteArrayOutputStream();
        this.isCrypt = true;
    }

    @Override
    protected void openFile() {
        try {
            FileUtil fa = this.isUserScript ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElementAppend(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = fos;
            this.fileStreamOut = new BufferedOutputStream(fos, 16384);
        }
        catch (IOException e) {
            throw Error.error(e, 452, 26, new String[]{e.toString(), this.outFile});
        }
    }

    @Override
    protected void finishStream() {
        try {
            if (this.fileStreamOut instanceof GZIPOutputStream) {
                ((GZIPOutputStream)this.fileStreamOut).finish();
            }
        }
        catch (IOException io) {
            throw Error.error(452, io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeRowOutToFile() {
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                if (this.byteOut == null) {
                    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
                    this.byteCount += (long)this.rowOut.size();
                    ++this.lineCount;
                    return;
                }
                int count = this.crypto.getEncodedSize(this.rowOut.size());
                this.byteOut.ensureRoom(count + 4);
                count = this.crypto.encode(this.rowOut.getBuffer(), 0, this.rowOut.size(), this.byteOut.getBuffer(), 4);
                this.byteOut.setPosition(0);
                this.byteOut.writeInt(count);
                this.fileStreamOut.write(this.byteOut.getBuffer(), 0, count + 4);
                this.byteCount += (long)this.rowOut.size();
                ++this.lineCount;
            }
            catch (IOException io) {
                throw Error.error(452, io);
            }
        }
    }
}

