/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.rowio.RowOutputTextLog;
import org.hsqldb.scriptio.ScriptWriterBase;

public class ScriptWriterText
extends ScriptWriterBase {
    static byte[] BYTES_COMMIT = "COMMIT".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_INSERT_INTO = "INSERT INTO ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_VALUES = " VALUES(".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_TERM = ")".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_DELETE_FROM = "DELETE FROM ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_WHERE = " WHERE ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_C_ID_INIT = "/*C".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_C_ID_TERM = "*/".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_SCHEMA = "SET SCHEMA ".getBytes(JavaSystem.CS_ISO_8859_1);
    static byte[] BYTES_LINE_SEP = System.getProperty("line.separator", "\n").getBytes(JavaSystem.CS_ISO_8859_1);
    RowOutputInterface rowOut;

    public ScriptWriterText(Database db, OutputStream outputStream, FileAccess.FileSync descriptor, boolean includeCachedData) {
        super(db, outputStream, descriptor, includeCachedData);
    }

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean newFile, boolean isUserScript) {
        super(db, file, includeCachedData, newFile, isUserScript);
    }

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean compressed) {
        super(db, file, includeCachedData, true, false);
        if (compressed) {
            this.isCompressed = true;
            try {
                this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
            }
            catch (IOException e) {
                throw Error.error(e, 452, 26, new String[]{e.toString(), this.outFile});
            }
        }
    }

    @Override
    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    @Override
    protected void writeDataTerm() {
    }

    @Override
    protected void writeSessionIdAndSchema(Session session) {
        if (session == null) {
            return;
        }
        if (session != this.currentSession) {
            this.rowOut.reset();
            this.rowOut.writeBytes(BYTES_C_ID_INIT);
            this.rowOut.writeLong(session.getId());
            this.rowOut.writeBytes(BYTES_C_ID_TERM);
            this.currentSession = session;
            this.writeRowOutToFile();
        }
        if (this.schemaToLog != session.loggedSchema) {
            this.rowOut.reset();
            this.writeSchemaStatement(this.schemaToLog);
            session.loggedSchema = this.schemaToLog;
            this.writeRowOutToFile();
        }
    }

    private void writeSchemaStatement(HsqlNameManager.HsqlName schema) {
        this.rowOut.writeBytes(BYTES_SCHEMA);
        this.rowOut.writeString(schema.statementName);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
    }

    @Override
    public void writeLogStatement(Session session, String s) {
        if (session != null) {
            this.schemaToLog = session.currentSchema;
            this.writeSessionIdAndSchema(session);
        }
        this.rowOut.reset();
        this.rowOut.writeString(s);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeRow(Session session, Row row, Table table) {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.rowOut.writeBytes(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.writeBytes(BYTES_VALUES);
        this.rowOut.writeData(row, table.getColumnTypes());
        this.rowOut.writeBytes(BYTES_TERM);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeTableInit(Table t) {
        if (t.isEmpty(this.currentSession)) {
            return;
        }
        if (!this.includeTableInit && this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        this.rowOut.reset();
        this.writeSchemaStatement(t.getName().schema);
        this.writeRowOutToFile();
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    @Override
    public void writeOtherStatement(Session session, String s) {
        this.writeLogStatement(session, s);
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    public void writeInsertStatement(Session session, Row row, Table table) {
        this.schemaToLog = table.getName().schema;
        this.writeRow(session, row, table);
    }

    @Override
    public void writeDeleteStatement(Session session, Table table, Object[] data) {
        this.schemaToLog = table.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.rowOut.writeBytes(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.writeBytes(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), data, table.columnList, table.getPrimaryKey());
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
    }

    @Override
    public void writeSequenceStatement(Session session, NumberSequence seq) {
        this.schemaToLog = seq.getName().schema;
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.writeBytes(BYTES_SEQUENCE);
        this.rowOut.writeString(seq.getSchemaName().statementName);
        this.rowOut.writeByte(46);
        this.rowOut.writeString(seq.getName().statementName);
        this.rowOut.writeBytes(BYTES_SEQUENCE_MID);
        this.rowOut.writeLong(seq.peek());
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
    }

    @Override
    public void writeCommitStatement(Session session) {
        this.writeSessionIdAndSchema(session);
        this.rowOut.reset();
        this.rowOut.writeBytes(BYTES_COMMIT);
        this.rowOut.writeBytes(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.needsSync = true;
        if (this.writeDelay == 0) {
            this.sync();
        }
    }

    @Override
    protected void finishStream() {
        try {
            if (this.isCompressed) {
                ((GZIPOutputStream)this.fileStreamOut).finish();
            }
        }
        catch (IOException io) {
            throw Error.error(452, this.outFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRowOutToFile() {
        if (this.fileStreamOut == null) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
                this.byteCount += (long)this.rowOut.size();
                ++this.lineCount;
            }
            catch (IOException io) {
                throw Error.error(452, this.outFile);
            }
        }
    }

    static {
        if (BYTES_LINE_SEP[0] != 10 && BYTES_LINE_SEP[0] != 13) {
            BYTES_LINE_SEP = new byte[]{10};
        }
    }
}

