/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.server.HsqlSocketFactory;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    Object socketFactory;
    Object serverSocketFactory;
    final Object socket_factory_mutex = new Object();
    final Object server_socket_factory_mutex = new Object();

    HsqlSocketFactorySecure() {
    }

    @Override
    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket s = (SSLSocket)socket;
        s.addHandshakeCompletedListener(this);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws Exception {
        SSLServerSocket ss = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(port);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + ss + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", ss.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", ss.getEnabledCipherSuites());
        }
        return ss;
    }

    @Override
    public ServerSocket createServerSocket(int port, String address) throws Exception {
        InetAddress addr = InetAddress.getByName(address);
        SSLServerSocket ss = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(port, 128, addr);
        if (Error.TRACESYSTEMOUT) {
            Error.printSystemOut("[" + this + "]: createServerSocket()");
            Error.printSystemOut("capabilities for " + ss + ":");
            Error.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", ss.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", ss.getEnabledCipherSuites());
        }
        return ss;
    }

    private static void dump(String title, String[] as) {
        Error.printSystemOut(title);
        Error.printSystemOut("----------------------------");
        for (int i = 0; i < as.length; ++i) {
            Error.printSystemOut(String.valueOf(as[i]));
        }
        Error.printSystemOut("----------------------------");
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port) throws Exception {
        if (socket == null) {
            return this.createSocket(host, port);
        }
        SSLSocket sslSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(socket, host, port, true);
        sslSocket.addHandshakeCompletedListener(this);
        sslSocket.startHandshake();
        this.verify(host, sslSocket.getSession());
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws Exception {
        SSLSocket socket = (SSLSocket)this.getSocketFactoryImpl().createSocket(host, port);
        socket.addHandshakeCompletedListener(this);
        socket.startHandshake();
        this.verify(host, socket.getSession());
        return socket;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLServerSocketFactory getServerSocketFactoryImpl() {
        Object factory;
        Object object = this.server_socket_factory_mutex;
        synchronized (object) {
            factory = this.serverSocketFactory;
            if (factory == null) {
                this.serverSocketFactory = factory = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLSocketFactory getSocketFactoryImpl() {
        Object factory;
        Object object = this.socket_factory_mutex;
        synchronized (object) {
            factory = this.socketFactory;
            if (factory == null) {
                this.socketFactory = factory = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)factory;
    }

    void verify(String host, SSLSession session) throws Exception {
        String CN;
        Certificate[] chain = session.getPeerCertificates();
        if (chain == null || chain.length == 0) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        if (!(chain[0] instanceof X509Certificate)) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        X509Certificate certificate = (X509Certificate)chain[0];
        X500Principal principal = certificate.getSubjectX500Principal();
        String DN = String.valueOf(principal);
        int start = DN.indexOf("CN=");
        if (start < 0) {
            throw new UnknownHostException(Error.getMessage(63));
        }
        int end = DN.indexOf(44, start += 3);
        if ((CN = DN.substring(start, end > -1 ? end : DN.length())).length() < 1) {
            throw new UnknownHostException(Error.getMessage(64));
        }
        if (!CN.equalsIgnoreCase(host)) {
            throw new UnknownHostException(Error.getMessage(65, 0, new String[]{CN, host}));
        }
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent evt) {
        if (Error.TRACESYSTEMOUT) {
            SSLSocket socket = evt.getSocket();
            SSLSession session = evt.getSession();
            Error.printSystemOut("SSL handshake completed:");
            Error.printSystemOut("------------------------------------------------");
            Error.printSystemOut("socket:      : " + socket);
            Error.printSystemOut("cipher suite : " + session.getCipherSuite());
            String sessionId = StringConverter.byteArrayToHexString(session.getId());
            Error.printSystemOut("session id   : " + sessionId);
            Error.printSystemOut("------------------------------------------------");
        }
    }
}

