/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.net.InetAddress;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConstants;
import org.hsqldb.server.ServerProperties;

public final class ServerConfiguration
implements ServerConstants {
    private ServerConfiguration() {
    }

    public static int getDefaultPort(int protocol, boolean isTls) {
        switch (protocol) {
            case 1: {
                return isTls ? 554 : 9001;
            }
            case 0: {
                return isTls ? 443 : 80;
            }
            case 2: {
                return isTls ? -1 : 9101;
            }
        }
        return -1;
    }

    public static ServerProperties getPropertiesFromFile(int protocol, String path, String extension) {
        boolean result;
        if (StringUtil.isEmpty(path)) {
            return null;
        }
        ServerProperties p = new ServerProperties(protocol, path, extension);
        try {
            result = p.load();
        }
        catch (Exception e) {
            return null;
        }
        return result ? p : null;
    }

    public static String[] listLocalInetAddressNames() {
        InetAddress[] addrs;
        InetAddress addr;
        HashSet<String> set = new HashSet<String>();
        try {
            int i;
            addr = InetAddress.getLocalHost();
            addrs = InetAddress.getAllByName(addr.getHostAddress());
            for (i = 0; i < addrs.length; ++i) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
            }
            addrs = InetAddress.getAllByName(addr.getHostName());
            for (i = 0; i < addrs.length; ++i) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            int i;
            addr = InetAddress.getByName(null);
            addrs = InetAddress.getAllByName(addr.getHostAddress());
            for (i = 0; i < addrs.length; ++i) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
            }
            addrs = InetAddress.getAllByName(addr.getHostName());
            for (i = 0; i < addrs.length; ++i) {
                set.add(addrs[i].getHostAddress());
                set.add(addrs[i].getHostName());
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            set.add(InetAddress.getByName("loopback").getHostAddress());
            set.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception i) {
            // empty catch block
        }
        String[] array = new String[set.size()];
        set.toArray(array);
        return array;
    }

    public static ServerProperties newDefaultProperties(int protocol) {
        ServerProperties p = new ServerProperties(protocol);
        p.setProperty("server.restart_on_shutdown", false);
        p.setProperty("server.address", "0.0.0.0");
        p.setProperty("server.no_system_exit", true);
        p.setProperty("server.maxdatabases", 10);
        p.setProperty("server.silent", true);
        p.setProperty("server.tls", false);
        p.setProperty("server.trace", false);
        p.setProperty("server.default_page", "index.html");
        p.setProperty("server.root", ".");
        return p;
    }

    public static void translateAddressProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        String address = p.getProperty("server.address");
        if (StringUtil.isEmpty(address)) {
            p.setProperty("server.address", "0.0.0.0");
        }
    }

    public static void translateDefaultDatabaseProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        if (!p.isPropertyTrue("server.remote_open")) {
            if (p.getProperty("server.database.0") == null) {
                String defaultdb = p.getProperty("server.database");
                if (defaultdb == null) {
                    defaultdb = "test";
                } else {
                    p.removeProperty("server.database");
                }
                p.setProperty("server.database.0", defaultdb);
                p.setProperty("server.dbname.0", "");
            }
            if (p.getProperty("server.dbname.0") == null) {
                p.setProperty("server.dbname.0", "");
            }
        }
    }

    public static void translateDefaultNoSystemExitProperty(HsqlProperties p) {
        if (p == null) {
            return;
        }
        p.setPropertyIfNotExists("server.no_system_exit", "false");
    }
}

