/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocket;
import org.hsqldb.ClientConnection;
import org.hsqldb.ColumnBase;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.CleanExit;
import org.hsqldb.server.InResultProcessor;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.OdbcUtil;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.server.Server;
import org.hsqldb.server.StatementPortal;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    int dbID;
    int dbIndex;
    private volatile Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private DataOutputStream dataOutput;
    private long mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputInterface rowOut;
    RowInputBinary rowIn;
    Thread runnerThread;
    InResultProcessor processor;
    private static AtomicLong mCurrentThread = new AtomicLong(0L);
    protected static String TEXTBANNER_PART1 = null;
    protected static String TEXTBANNER_PART2 = null;
    private CleanExit cleanExit = new CleanExit();
    private OdbcPacketOutputStream outPacket = null;
    public static long MAX_WAIT_FOR_CLIENT_DATA;
    public static long CLIENT_DATA_POLLING_PERIOD;
    private Map sessionOdbcPsMap = new HashMap();
    private Map sessionOdbcPortalMap = new HashMap();
    private int streamProtocol = 0;
    static final int UNDEFINED_STREAM_PROTOCOL = 0;
    static final int HSQL_STREAM_PROTOCOL = 1;
    static final int ODBC_STREAM_PROTOCOL = 2;
    int odbcCommMode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        RowOutputBinary rowOutTemp = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(rowOutTemp);
        this.rowOut = rowOutTemp;
        this.socket = socket;
        this.server = server;
        this.mThread = mCurrentThread.getAndIncrement();
        Object object = server.serverConnSetSync;
        synchronized (object) {
            server.serverConnSet.add(this);
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (Thread.currentThread().equals(this.runnerThread)) {
            Result resultOut = Result.updateZeroResult;
            try {
                resultOut.write(this.session, this.dataOutput, this.rowOut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        Object object = this;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        object = this.server.serverConnSetSync;
        synchronized (object) {
            this.server.serverConnSet.remove(this);
        }
        try {
            this.runnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            int firstInt = this.handshake();
            switch (this.streamProtocol) {
                case 1: {
                    byte msgType = this.dataInput.readByte();
                    this.processor.receiveConnection(msgType);
                    break;
                }
                case 2: {
                    this.processor.receiveConnection(firstInt);
                    break;
                }
                default: {
                    this.keepAlive = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(String.valueOf(this.mThread));
            sb.append(":Failed to connect client.");
            if (this.user != null) {
                sb.append("  User '").append(this.user).append("'.");
            }
            sb.append("  Stack trace follows.");
            this.server.printWithThread(sb.toString());
            this.server.printStackTrace(e);
        }
    }

    private void receiveResult(int resultMode) throws CleanExit, IOException {
        boolean terminate = false;
        Result resultIn = Result.newResult(this.session, resultMode, this.dataInput, this.rowIn);
        resultIn.readLobResults(this.session, this.dataInput);
        this.server.printRequest(this.mThread, resultIn);
        Result resultOut = null;
        switch (resultIn.getType()) {
            case 31: {
                resultOut = this.setDatabase(resultIn);
                break;
            }
            case 5: {
                resultOut = this.cancelStatement(resultIn);
                terminate = true;
                break;
            }
            case 32: {
                resultOut = Result.updateZeroResult;
                terminate = true;
                break;
            }
            case 10: {
                this.session.resetSession();
                resultOut = Result.updateZeroResult;
                break;
            }
            case 21: {
                resultOut = Result.newErrorResult(Error.error(1252));
                break;
            }
            default: {
                resultOut = this.session.execute(resultIn);
            }
        }
        resultOut.write(this.session, this.dataOutput, this.rowOut);
        this.rowOut.reset(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        if (terminate) {
            throw this.cleanExit;
        }
    }

    private void receiveOdbcPacket(char inC) throws IOException, CleanExit {
        boolean sendReadyForQuery = false;
        String interposedStatement = null;
        OdbcPacketInputStream inPacket = null;
        try {
            inPacket = OdbcPacketInputStream.newOdbcPacketInputStream(inC, this.dataInput);
            this.server.printWithThread("Got op (" + inPacket.packetType + ')');
            this.server.printWithThread("Got packet length of " + inPacket.available() + " + type byte + 4 size header");
            if (inPacket.available() >= 1000000000) {
                throw new IOException("Insane packet length: " + inPacket.available() + " + type byte + 4 size header");
            }
        }
        catch (SocketException se) {
            this.server.printWithThread("Ungraceful client exit: " + se);
            throw this.cleanExit;
        }
        catch (IOException ioe) {
            this.server.printWithThread("Fatal ODBC protocol failure: " + ioe);
            try {
                OdbcUtil.alertClient(1, ioe.toString(), "08P01", this.dataOutput);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.cleanExit;
        }
        switch (this.odbcCommMode) {
            case 2: {
                if (inPacket.packetType != 'S') {
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Ignoring a '" + inPacket.packetType + "'");
                    }
                    return;
                }
                this.odbcCommMode = 1;
                this.server.printWithThread("EXTENDED comm session being recovered");
                break;
            }
            case 0: {
                switch (inPacket.packetType) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'H': 
                    case 'P': 
                    case 'S': {
                        this.odbcCommMode = 1;
                        this.server.printWithThread("Switching mode from SIMPLE to EXTENDED");
                    }
                }
                break;
            }
            case 1: {
                switch (inPacket.packetType) {
                    case 'Q': {
                        this.odbcCommMode = 0;
                        this.server.printWithThread("Switching mode from EXTENDED to SIMPLE");
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ODBC comm mode value: " + this.odbcCommMode);
            }
        }
        this.outPacket.reset();
        try {
            block17 : switch (inPacket.packetType) {
                case 'Q': {
                    int lastSemi;
                    String sql = inPacket.readString();
                    if (sql.startsWith("BEGIN;") || sql.equals("BEGIN")) {
                        sql = sql.equals("BEGIN") ? null : sql.substring("BEGIN;".length());
                        this.server.printWithThread("ODBC Trans started.  Session AutoCommit -> F");
                        try {
                            this.session.setAutoCommit(false);
                        }
                        catch (HsqlException he) {
                            throw new RecoverableOdbcFailure("Failed to change transaction state: " + he.getMessage(), he.getSQLState());
                        }
                        this.outPacket.write("BEGIN");
                        this.outPacket.xmit('C', this.dataOutput);
                        if (sql == null) {
                            sendReadyForQuery = true;
                            break;
                        }
                    }
                    if (sql.startsWith("SAVEPOINT ") && sql.indexOf(59) > 0) {
                        int firstSemi = sql.indexOf(59);
                        this.server.printWithThread("Interposing BEFORE primary statement: " + sql.substring(0, firstSemi));
                        this.odbcExecDirect(sql.substring(0, firstSemi));
                        sql = sql.substring(firstSemi + 1);
                    }
                    if ((lastSemi = sql.lastIndexOf(59)) > 0) {
                        String suffix = sql.substring(lastSemi + 1);
                        if (suffix.startsWith("RELEASE ")) {
                            interposedStatement = suffix;
                            sql = sql.substring(0, lastSemi);
                        }
                        if (suffix.startsWith("show transaction_isolation")) {
                            interposedStatement = null;
                            sql = "values session_isolation_level()";
                        }
                    }
                    String normalized = sql.trim().toLowerCase();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received query (" + sql + ')');
                    }
                    if (normalized.startsWith("select current_schema()")) {
                        normalized = sql = "values current_schema()";
                    }
                    if (normalized.startsWith("show ")) {
                        normalized = sql = "values " + sql.substring("show ".length());
                    }
                    if (normalized.startsWith("values n.nspname,")) {
                        this.server.printWithThread("Swallowing 'select n.nspname,...'");
                        this.outPacket.writeShort(1);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(201);
                        this.outPacket.writeShort(1);
                        this.outPacket.writeInt(23);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        sendReadyForQuery = true;
                        break;
                    }
                    if (normalized.startsWith("select oid, typbasetype from")) {
                        this.server.printWithThread("Simulating 'select oid, typbasetype...'");
                        this.outPacket.writeShort(2);
                        this.outPacket.write("oid");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(102);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.write("typbasetype");
                        this.outPacket.writeInt(101);
                        this.outPacket.writeShort(103);
                        this.outPacket.writeInt(26);
                        this.outPacket.writeShort(4);
                        this.outPacket.writeInt(-1);
                        this.outPacket.writeShort(0);
                        this.outPacket.xmit('T', this.dataOutput);
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        sendReadyForQuery = true;
                        break;
                    }
                    if (normalized.startsWith("select ") || normalized.startsWith("values ")) {
                        this.server.printWithThread("Performing a real non-prepared SELECT...");
                        Result r = Result.newExecuteDirectRequest();
                        r.setPrepareOrExecuteProperties(sql, 0, 0, 2, 0, 0, 2, null, null);
                        this.server.printWithThread(sql);
                        Result rOut = this.session.execute(r);
                        switch (rOut.getType()) {
                            case 3: {
                                break;
                            }
                            case 2: {
                                throw new RecoverableOdbcFailure(rOut);
                            }
                            default: {
                                throw new RecoverableOdbcFailure("Output Result from Query execution is of unexpected type: " + rOut.getType());
                            }
                        }
                        RowSetNavigator navigator = rOut.getNavigator();
                        ResultMetaData md = rOut.metaData;
                        if (md == null) {
                            throw new RecoverableOdbcFailure("Failed to get metadata for query results");
                        }
                        int columnCount = md.getColumnCount();
                        String[] colLabels = md.getGeneratedColumnNames();
                        Type[] colTypes = md.columnTypes;
                        PgType[] pgTypes = new PgType[columnCount];
                        for (int i = 0; i < pgTypes.length; ++i) {
                            pgTypes[i] = PgType.getPgType(colTypes[i]);
                        }
                        ColumnBase[] colDefs = md.columns;
                        this.outPacket.writeShort(columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            if (colLabels[i] != null) {
                                this.outPacket.write(colLabels[i]);
                            } else {
                                this.outPacket.write(colDefs[i].getNameString());
                            }
                            this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(i, md));
                            this.outPacket.writeShort(OdbcUtil.getIdForColumn(i, md));
                            this.outPacket.writeInt(pgTypes[i].getOid());
                            this.outPacket.writeShort(pgTypes[i].getTypeWidth());
                            this.outPacket.writeInt(pgTypes[i].getLPConstraint());
                            this.outPacket.writeShort(0);
                        }
                        this.outPacket.xmit('T', this.dataOutput);
                        int rowNum = 0;
                        while (navigator.next()) {
                            ++rowNum;
                            Object[] rowData = navigator.getCurrent();
                            if (rowData == null) {
                                throw new RecoverableOdbcFailure("Null row?");
                            }
                            if (rowData.length < columnCount) {
                                throw new RecoverableOdbcFailure("Data element mismatch. " + columnCount + " metadata cols, yet " + rowData.length + " data elements for row " + rowNum);
                            }
                            this.outPacket.writeShort(columnCount);
                            for (int i = 0; i < columnCount; ++i) {
                                if (rowData[i] == null) {
                                    this.outPacket.writeInt(-1);
                                    continue;
                                }
                                String dataString = pgTypes[i].valueString(rowData[i]);
                                this.outPacket.writeSized(dataString);
                                if (!this.server.isTrace()) continue;
                                this.server.printWithThread("R" + rowNum + "C" + (i + 1) + " => (" + rowData[i].getClass().getName() + ") [" + dataString + ']');
                            }
                            this.outPacket.xmit('D', this.dataOutput);
                        }
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        sendReadyForQuery = true;
                        break;
                    }
                    if (normalized.startsWith("deallocate \"") && normalized.charAt(normalized.length() - 1) == '\"') {
                        StatementPortal portal;
                        String tmpStr = sql.trim().substring("deallocate \"".length()).trim();
                        String handle = tmpStr.substring(0, tmpStr.length() - 1);
                        OdbcPreparedStatement odbcPs = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(handle);
                        if (odbcPs != null) {
                            odbcPs.close();
                        }
                        if ((portal = (StatementPortal)this.sessionOdbcPortalMap.get(handle)) != null) {
                            portal.close();
                        }
                        if (odbcPs == null && portal == null) {
                            this.server.printWithThread("Ignoring bad 'DEALLOCATE' cmd");
                        }
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Deallocated PS/Portal '" + handle + "'");
                        }
                        this.outPacket.write("DEALLOCATE");
                        this.outPacket.xmit('C', this.dataOutput);
                        sendReadyForQuery = true;
                        break;
                    }
                    if (normalized.startsWith("set client_encoding to ")) {
                        this.server.printWithThread("Stubbing EXECDIR for: " + sql);
                        this.outPacket.write("SET");
                        this.outPacket.xmit('C', this.dataOutput);
                        sendReadyForQuery = true;
                        break;
                    }
                    this.server.printWithThread("Performing a real EXECDIRECT...");
                    this.odbcExecDirect(sql);
                    sendReadyForQuery = true;
                    break;
                }
                case 'X': {
                    if (this.sessionOdbcPsMap.size() > (this.sessionOdbcPsMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPsMap.size() + " PS objects open");
                    }
                    if (this.sessionOdbcPortalMap.size() > (this.sessionOdbcPortalMap.containsKey("") ? 1 : 0)) {
                        this.server.printWithThread("Client left " + this.sessionOdbcPortalMap.size() + " Portal objects open");
                    }
                    OdbcUtil.validateInputPacketSize(inPacket);
                    throw this.cleanExit;
                }
                case 'H': {
                    break;
                }
                case 'S': {
                    if (this.session.isAutoCommit()) {
                        try {
                            this.server.printWithThread("Silly implicit commit by Sync");
                            this.session.commit(true);
                        }
                        catch (HsqlException he) {
                            this.server.printWithThread("Implicit commit failed: " + he);
                            OdbcUtil.alertClient(2, "Implicit commit failed", he.getSQLState(), this.dataOutput);
                        }
                    }
                    sendReadyForQuery = true;
                    break;
                }
                case 'P': {
                    String psHandle = inPacket.readString();
                    String query = OdbcUtil.revertMungledPreparedQuery(inPacket.readString());
                    int paramCount = inPacket.readUnsignedShort();
                    for (int i = 0; i < paramCount; ++i) {
                        if (inPacket.readInt() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Parameter-type OID specifiers not supported yet", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Prepare request for query (" + query + ") with handle '" + psHandle + "'");
                    }
                    if (psHandle.length() > 0 && this.sessionOdbcPsMap.containsKey(psHandle)) {
                        throw new RecoverableOdbcFailure(null, "PS handle '" + psHandle + "' already in use.  You must close it before recreating", "08P01");
                    }
                    new OdbcPreparedStatement(psHandle, query, this.sessionOdbcPsMap, this.session);
                    this.outPacket.xmit('1', this.dataOutput);
                    break;
                }
                case 'D': {
                    int i;
                    ResultMetaData md;
                    Type[] paramTypes;
                    char c = inPacket.readByteChar();
                    String handle = inPacket.readString();
                    OdbcPreparedStatement odbcPs = null;
                    StatementPortal portal = null;
                    if (c == 'S') {
                        odbcPs = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(handle);
                    } else if (c == 'P') {
                        portal = (StatementPortal)this.sessionOdbcPortalMap.get(handle);
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Describe request for " + c + " of  handle '" + handle + "'");
                    }
                    if (odbcPs == null && portal == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for " + c + " handle: " + handle, "08P01");
                    }
                    Result ackResult = odbcPs == null ? portal.ackResult : odbcPs.ackResult;
                    ResultMetaData pmd = ackResult.parameterMetaData;
                    int paramCount = pmd.getColumnCount();
                    if (paramCount != (paramTypes = pmd.getParameterTypes()).length) {
                        throw new RecoverableOdbcFailure("Parameter count mismatch.  Count of " + paramCount + " reported, but there are " + paramTypes.length + " param md objects");
                    }
                    if (c == 'S') {
                        this.outPacket.writeShort(paramCount);
                        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
                            this.outPacket.writeInt(PgType.getPgType(paramTypes[i2]).getOid());
                        }
                        this.outPacket.xmit('t', this.dataOutput);
                    }
                    if ((md = ackResult.metaData).getColumnCount() < 1) {
                        if (this.server.isTrace()) {
                            this.server.printWithThread("Non-rowset query so returning NoData packet");
                        }
                        this.outPacket.xmit('n', this.dataOutput);
                        break;
                    }
                    String[] colNames = md.getGeneratedColumnNames();
                    if (md.getColumnCount() != colNames.length) {
                        throw new RecoverableOdbcFailure("Couldn't get all column names: " + md.getColumnCount() + " cols. but only got " + colNames.length + " col. names");
                    }
                    Type[] colTypes = md.columnTypes;
                    PgType[] pgTypes = new PgType[colNames.length];
                    ColumnBase[] colDefs = md.columns;
                    for (i = 0; i < pgTypes.length; ++i) {
                        pgTypes[i] = PgType.getPgType(colTypes[i]);
                    }
                    if (colNames.length != colDefs.length) {
                        throw new RecoverableOdbcFailure("Col data mismatch.  " + colDefs.length + " col instances but " + colNames.length + " col names");
                    }
                    this.outPacket.writeShort(colNames.length);
                    for (i = 0; i < colNames.length; ++i) {
                        this.outPacket.write(colNames[i]);
                        this.outPacket.writeInt(OdbcUtil.getTableOidForColumn(i, md));
                        this.outPacket.writeShort(OdbcUtil.getIdForColumn(i, md));
                        this.outPacket.writeInt(pgTypes[i].getOid());
                        this.outPacket.writeShort(pgTypes[i].getTypeWidth());
                        this.outPacket.writeInt(pgTypes[i].getLPConstraint());
                        this.outPacket.writeShort(0);
                    }
                    this.outPacket.xmit('T', this.dataOutput);
                    break;
                }
                case 'B': {
                    OdbcPreparedStatement odbcPs;
                    String portalHandle = inPacket.readString();
                    String psHandle = inPacket.readString();
                    int paramFormatCount = inPacket.readUnsignedShort();
                    boolean[] paramBinary = new boolean[paramFormatCount];
                    for (int i = 0; i < paramFormatCount; ++i) {
                        boolean bl = paramBinary[i] = inPacket.readUnsignedShort() != 0;
                        if (!this.server.isTrace() || !paramBinary[i]) continue;
                        this.server.printWithThread("Binary param #" + i);
                    }
                    int paramCount = inPacket.readUnsignedShort();
                    Object[] paramVals = new Object[paramCount];
                    for (int i = 0; i < paramVals.length; ++i) {
                        paramVals[i] = i < paramBinary.length && paramBinary[i] ? inPacket.readSizedBinaryData() : inPacket.readSizedString();
                    }
                    int outFormatCount = inPacket.readUnsignedShort();
                    for (int i = 0; i < outFormatCount; ++i) {
                        if (inPacket.readUnsignedShort() == 0) continue;
                        throw new RecoverableOdbcFailure(null, "Binary output values not supported", "0A000");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Bind request to make Portal from (" + psHandle + ")' with handle '" + portalHandle + "'");
                    }
                    if ((odbcPs = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(psHandle)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for PS handle: " + psHandle, "08P01");
                    }
                    if (portalHandle.length() > 0 && this.sessionOdbcPortalMap.containsKey(portalHandle)) {
                        throw new RecoverableOdbcFailure(null, "Portal handle '" + portalHandle + "' already in use.  You must close it before recreating", "08P01");
                    }
                    ResultMetaData pmd = odbcPs.ackResult.parameterMetaData;
                    if (paramCount != pmd.getColumnCount()) {
                        throw new RecoverableOdbcFailure(null, "Client didn't specify all " + pmd.getColumnCount() + " parameters (" + paramCount + ')', "08P01");
                    }
                    new StatementPortal(portalHandle, odbcPs, paramVals, this.sessionOdbcPortalMap);
                    this.outPacket.xmit('2', this.dataOutput);
                    break;
                }
                case 'E': {
                    StatementPortal portal;
                    String portalHandle = inPacket.readString();
                    int fetchRows = inPacket.readInt();
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Received Exec request for " + fetchRows + " rows from portal handle '" + portalHandle + "'");
                    }
                    if ((portal = (StatementPortal)this.sessionOdbcPortalMap.get(portalHandle)) == null) {
                        throw new RecoverableOdbcFailure(null, "No object present for Portal handle: " + portalHandle, "08P01");
                    }
                    portal.bindResult.setPreparedExecuteProperties(portal.parameters, fetchRows, 0, 0, 0);
                    Result rOut = this.session.execute(portal.bindResult);
                    switch (rOut.getType()) {
                        case 1: {
                            this.outPacket.write(OdbcUtil.echoBackReplyString(portal.lcQuery, rOut.getUpdateCount()));
                            this.outPacket.xmit('C', this.dataOutput);
                            if (!portal.lcQuery.equals("commit") && !portal.lcQuery.startsWith("commit ") && !portal.lcQuery.equals("rollback") && !portal.lcQuery.startsWith("rollback ")) break block17;
                            try {
                                this.session.setAutoCommit(true);
                                break block17;
                            }
                            catch (HsqlException he) {
                                throw new RecoverableOdbcFailure("Failed to change transaction state: " + he.getMessage(), he.getSQLState());
                            }
                        }
                        case 3: {
                            break;
                        }
                        case 2: {
                            throw new RecoverableOdbcFailure(rOut);
                        }
                        default: {
                            throw new RecoverableOdbcFailure("Output Result from Portal execution is of unexpected type: " + rOut.getType());
                        }
                    }
                    RowSetNavigator navigator = rOut.getNavigator();
                    int rowNum = 0;
                    int colCount = portal.ackResult.metaData.getColumnCount();
                    while (navigator.next()) {
                        int i;
                        ++rowNum;
                        Object[] rowData = navigator.getCurrent();
                        if (rowData == null) {
                            throw new RecoverableOdbcFailure("Null row?");
                        }
                        if (rowData.length < colCount) {
                            throw new RecoverableOdbcFailure("Data element mismatch. " + colCount + " metadata cols, yet " + rowData.length + " data elements for row " + rowNum);
                        }
                        this.outPacket.writeShort(colCount);
                        Type[] colTypes = portal.ackResult.metaData.columnTypes;
                        PgType[] pgTypes = new PgType[colCount];
                        for (i = 0; i < pgTypes.length; ++i) {
                            pgTypes[i] = PgType.getPgType(colTypes[i]);
                        }
                        for (i = 0; i < colCount; ++i) {
                            if (rowData[i] == null) {
                                this.outPacket.writeInt(-1);
                                continue;
                            }
                            String dataString = pgTypes[i].valueString(rowData[i]);
                            this.outPacket.writeSized(dataString);
                            if (!this.server.isTrace()) continue;
                            this.server.printWithThread("R" + rowNum + "C" + (i + 1) + " => (" + rowData[i].getClass().getName() + ") [" + dataString + ']');
                        }
                        this.outPacket.xmit('D', this.dataOutput);
                    }
                    if (navigator.getSize() == 0 || navigator.afterLast()) {
                        this.outPacket.write("SELECT");
                        this.outPacket.xmit('C', this.dataOutput);
                        break;
                    }
                    this.outPacket.xmit('s', this.dataOutput);
                    break;
                }
                case 'C': {
                    char c = inPacket.readByteChar();
                    String handle = inPacket.readString();
                    OdbcPreparedStatement odbcPs = null;
                    StatementPortal portal = null;
                    if (c == 'S') {
                        odbcPs = (OdbcPreparedStatement)this.sessionOdbcPsMap.get(handle);
                        if (odbcPs != null) {
                            odbcPs.close();
                        }
                    } else if (c == 'P') {
                        portal = (StatementPortal)this.sessionOdbcPortalMap.get(handle);
                        if (portal != null) {
                            portal.close();
                        }
                    } else {
                        throw new RecoverableOdbcFailure(null, "Description packet request type invalid: " + c, "08P01");
                    }
                    if (this.server.isTrace()) {
                        this.server.printWithThread("Closed " + c + " '" + handle + "'? " + (odbcPs != null || portal != null));
                    }
                    this.outPacket.xmit('3', this.dataOutput);
                    break;
                }
                default: {
                    throw new RecoverableOdbcFailure(null, "Unsupported operation type (" + inPacket.packetType + ')', "0A000");
                }
            }
            OdbcUtil.validateInputPacketSize(inPacket);
            if (interposedStatement != null) {
                this.server.printWithThread("Interposing AFTER primary statement: " + interposedStatement);
                this.odbcExecDirect(interposedStatement);
            }
            if (sendReadyForQuery) {
                this.outPacket.reset();
                this.outPacket.writeByte(this.session.isAutoCommit() ? 73 : 84);
                this.outPacket.xmit('Z', this.dataOutput);
            }
        }
        catch (RecoverableOdbcFailure rf) {
            Result errorResult = rf.getErrorResult();
            if (errorResult == null) {
                String stateCode = rf.getSqlStateCode();
                String svrMsg = rf.toString();
                String cliMsg = rf.getClientMessage();
                if (this.server.isTrace()) {
                    this.server.printWithThread(svrMsg);
                }
                if (cliMsg != null) {
                    OdbcUtil.alertClient(2, cliMsg, stateCode, this.dataOutput);
                }
            } else {
                if (this.server.isTrace()) {
                    this.server.printWithThread("Result object error: " + errorResult.getMainString());
                }
                OdbcUtil.alertClient(2, errorResult.getMainString(), errorResult.getSubString(), this.dataOutput);
            }
            switch (this.odbcCommMode) {
                case 0: {
                    this.outPacket.reset();
                    this.outPacket.writeByte(69);
                    this.outPacket.xmit('Z', this.dataOutput);
                    break;
                }
                case 1: {
                    this.odbcCommMode = 2;
                    this.server.printWithThread("Reverting to EXT_RECOVER mode");
                }
            }
        }
    }

    @Override
    public void run() {
        block8: {
            this.init();
            if (this.session != null) {
                try {
                    while (this.keepAlive) {
                        byte msgType = this.dataInput.readByte();
                        this.processor.receiveResult((char)msgType);
                    }
                }
                catch (CleanExit ce) {
                    this.keepAlive = false;
                }
                catch (IOException e) {
                    this.server.printWithThread(this.mThread + ":disconnected " + this.user);
                }
                catch (HsqlException e) {
                    if (this.keepAlive) {
                        this.server.printStackTrace(e);
                    }
                }
                catch (Throwable e) {
                    if (!this.keepAlive) break block8;
                    this.server.printStackTrace(e);
                }
            }
        }
        this.close();
    }

    private Result setDatabase(Result resultIn) {
        try {
            String databaseName = resultIn.getDatabaseName();
            this.dbIndex = this.server.getDBIndex(databaseName);
            this.dbID = this.server.dbID[this.dbIndex];
            this.user = resultIn.getMainString();
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + databaseName + ')');
            }
            this.session = DatabaseManager.newSession(this.dbID, this.user, resultIn.getSubString(), resultIn.getZoneString());
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Connected user '" + this.user + "'");
            }
            return Result.newConnectionAcknowledgeResponse(this.session);
        }
        catch (HsqlException e) {
            this.session = null;
            return Result.newErrorResult(e);
        }
        catch (Throwable e) {
            this.session = null;
            return Result.newErrorResult(e);
        }
    }

    private Result cancelStatement(Result resultIn) {
        try {
            this.dbID = resultIn.getDatabaseId();
            long sessionId = resultIn.getSessionId();
            this.session = DatabaseManager.getSession(this.dbID, sessionId);
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to cancel statement  to DB (" + this.dbID + ')');
            }
            return this.session.cancel(resultIn);
        }
        catch (HsqlException e) {}
        finally {
            this.session = null;
            return Result.updateZeroResult;
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }

    public int handshake() throws IOException {
        long clientDataDeadline = new Date().getTime() + MAX_WAIT_FOR_CLIENT_DATA;
        if (!(this.socket instanceof SSLSocket)) {
            do {
                try {
                    Thread.sleep(CLIENT_DATA_POLLING_PERIOD);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.dataInput.available() < 5 && new Date().getTime() < clientDataDeadline);
            if (this.dataInput.available() < 1) {
                this.dataOutput.write((TEXTBANNER_PART1 + "2.3.4.0" + TEXTBANNER_PART2 + '\n').getBytes());
                this.dataOutput.flush();
                throw Error.error(404);
            }
        }
        int firstInt = this.dataInput.readInt();
        switch (firstInt >> 24) {
            case 80: {
                this.server.print("Rejected attempt from client using hsql HTTP protocol");
                return 0;
            }
            case 0: {
                this.streamProtocol = 2;
                this.processor = new OdbcInResultProcessor();
                break;
            }
            default: {
                this.streamProtocol = 1;
                this.processor = new HsqlInResultProcessor();
                if (firstInt == -2030400) break;
                if (firstInt == -1900000) {
                    firstInt = -2000000;
                }
                String verString = ClientConnection.toNetCompVersionString(firstInt);
                throw Error.error(null, 403, 0, new String[]{"2.7.1", verString});
            }
        }
        return firstInt;
    }

    private void odbcConnect(int firstInt) throws IOException {
        int major = this.dataInput.readUnsignedShort();
        int minor = this.dataInput.readUnsignedShort();
        if (major == 1 && minor == 7) {
            this.server.print("A pre-version 2.0 client attempted to connect.  We rejected them.");
            return;
        }
        if (major == 1234 && minor == 5679) {
            this.dataOutput.writeByte(78);
            this.odbcConnect(this.dataInput.readInt());
            return;
        }
        if (major == 1234 && minor == 5678) {
            if (firstInt != 16) {
                this.server.print("ODBC cancellation request sent wrong packet length: " + firstInt);
            }
            this.server.print("Got an ODBC cancellation request for thread ID " + this.dataInput.readInt() + ", but we don't support OOB cancellation yet.  Ignoring this request and closing the connection.");
            return;
        }
        this.server.printWithThread("ODBC client connected.  ODBC Protocol Compatibility Version " + major + '.' + minor);
        OdbcPacketInputStream inPacket = OdbcPacketInputStream.newOdbcPacketInputStream('\u0000', (InputStream)this.dataInput, firstInt - 8);
        Map stringPairs = inPacket.readStringPairs();
        if (this.server.isTrace()) {
            this.server.print("String Pairs from ODBC client: " + stringPairs);
        }
        try {
            try {
                OdbcUtil.validateInputPacketSize(inPacket);
            }
            catch (RecoverableOdbcFailure rf) {
                throw new ClientFailure(rf.toString(), rf.getClientMessage());
            }
            inPacket.close();
            if (!stringPairs.containsKey("database")) {
                throw new ClientFailure("Client did not identify database", "Target database not identified");
            }
            if (!stringPairs.containsKey("user")) {
                throw new ClientFailure("Client did not identify user", "Target account not identified");
            }
            String databaseName = (String)stringPairs.get("database");
            this.user = (String)stringPairs.get("user");
            if (databaseName.equals("/")) {
                databaseName = "";
            }
            this.dataOutput.writeByte(82);
            this.dataOutput.writeInt(8);
            this.dataOutput.writeInt(3);
            this.dataOutput.flush();
            char c = '\u0000';
            try {
                c = (char)this.dataInput.readByte();
            }
            catch (EOFException eofe) {
                this.server.printWithThread("Looks like we got a goofy psql no-auth attempt.  Will probably retry properly very shortly");
                return;
            }
            if (c != 'p') {
                throw new ClientFailure("Expected password prefix 'p', but got '" + c + "'", "Password value not prefixed with 'p'");
            }
            int len = this.dataInput.readInt() - 5;
            if (len < 0) {
                throw new ClientFailure("Client submitted invalid password length " + len, "Invalid password length " + len);
            }
            String password = ServerConnection.readNullTermdUTF(len, this.dataInput);
            this.dbIndex = this.server.getDBIndex(databaseName);
            this.dbID = this.server.dbID[this.dbIndex];
            if (!this.server.isSilent()) {
                this.server.printWithThread(this.mThread + ":Trying to connect user '" + this.user + "' to DB (" + databaseName + ')');
            }
            try {
                this.session = DatabaseManager.newSession(this.dbID, this.user, password, DateTimeType.systemTimeZone.getID());
            }
            catch (Exception e) {
                throw new ClientFailure("User name or password denied: " + e, "Login attempt rejected");
            }
        }
        catch (ClientFailure cf) {
            this.server.print(cf.toString());
            OdbcUtil.alertClient(1, cf.getClientMessage(), "08006", this.dataOutput);
            return;
        }
        this.outPacket = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        this.outPacket.writeInt(0);
        this.outPacket.xmit('R', this.dataOutput);
        for (int i = 0; i < OdbcUtil.hardcodedParams.length; ++i) {
            OdbcUtil.writeParam(OdbcUtil.hardcodedParams[i][0], OdbcUtil.hardcodedParams[i][1], this.dataOutput);
        }
        this.outPacket.writeByte(73);
        this.outPacket.xmit('Z', this.dataOutput);
        OdbcUtil.alertClient(7, "MHello\nYou have connected to HyperSQL ODBC Server", this.dataOutput);
        this.dataOutput.flush();
    }

    private static String readNullTermdUTF(int reqLength, InputStream istream) throws IOException {
        byte[] ba = new byte[reqLength + 3];
        ba[0] = (byte)(reqLength >>> 8);
        ba[1] = (byte)reqLength;
        for (int bytesRead = 0; bytesRead < reqLength + 1; bytesRead += istream.read(ba, 2 + bytesRead, reqLength + 1 - bytesRead)) {
        }
        if (ba[ba.length - 1] != 0) {
            throw new IOException("String not null-terminated");
        }
        for (int i = 2; i < ba.length - 1; ++i) {
            if (ba[i] != 0) continue;
            throw new RuntimeException("Null internal to String at offset " + (i - 2));
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(ba));
        String s = dis.readUTF();
        dis.close();
        return s;
    }

    private void odbcExecDirect(String inStatement) throws RecoverableOdbcFailure, IOException {
        String statement = inStatement;
        String norm = statement.trim().toLowerCase();
        if (norm.startsWith("release ") && !norm.startsWith("release savepoint")) {
            this.server.printWithThread("Transmogrifying 'RELEASE ...' to 'RELEASE SAVEPOINT...");
            statement = statement.trim().substring(0, "release ".length()) + "SAVEPOINT " + statement.trim().substring("release ".length());
        }
        Result r = Result.newExecuteDirectRequest();
        r.setPrepareOrExecuteProperties(statement, 0, 0, 1, 0, 0, 2, null, null);
        this.server.printWithThread(statement);
        Result rOut = this.session.execute(r);
        switch (rOut.getType()) {
            case 1: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(rOut);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from execution is of unexpected type: " + rOut.getType());
            }
        }
        this.outPacket.reset();
        this.outPacket.write(OdbcUtil.echoBackReplyString(norm, rOut.getUpdateCount()));
        this.outPacket.xmit('C', this.dataOutput);
        if (norm.equals("commit") || norm.startsWith("commit ") || norm.equals("rollback") || norm.startsWith("rollback ")) {
            try {
                this.session.setAutoCommit(true);
            }
            catch (HsqlException he) {
                throw new RecoverableOdbcFailure("Failed to change transaction state: " + he.getMessage(), he.getSQLState());
            }
        }
    }

    static {
        int serverBundleHandle = ResourceBundleHandler.getBundleHandle("org_hsqldb_server_Server_messages", null);
        if (serverBundleHandle < 0) {
            throw new RuntimeException("MISSING Resource Bundle.  See source code");
        }
        TEXTBANNER_PART1 = ResourceBundleHandler.getString(serverBundleHandle, "textbanner.part1");
        TEXTBANNER_PART2 = ResourceBundleHandler.getString(serverBundleHandle, "textbanner.part2");
        if (TEXTBANNER_PART1 == null || TEXTBANNER_PART2 == null) {
            throw new RuntimeException("MISSING Resource Bundle msg definition.  See source code");
        }
        MAX_WAIT_FOR_CLIENT_DATA = 1000L;
        CLIENT_DATA_POLLING_PERIOD = 100L;
    }

    class HsqlInResultProcessor
    implements InResultProcessor {
        HsqlInResultProcessor() {
        }

        @Override
        public void receiveConnection(int type) throws CleanExit, IOException {
            this.receiveResult(type);
        }

        @Override
        public void receiveResult(int type) throws CleanExit, IOException {
            ServerConnection.this.receiveResult(type);
        }
    }

    class OdbcInResultProcessor
    implements InResultProcessor {
        OdbcInResultProcessor() {
        }

        @Override
        public void receiveConnection(int type) throws IOException {
            ServerConnection.this.odbcConnect(type);
        }

        @Override
        public void receiveResult(int type) throws CleanExit, IOException {
            ServerConnection.this.receiveOdbcPacket((char)type);
        }
    }

    private static class ClientFailure
    extends Exception {
        private String clientMessage = null;

        public ClientFailure(String ourMessage, String clientMessage) {
            super(ourMessage);
            this.clientMessage = clientMessage;
        }

        public String getClientMessage() {
            return this.clientMessage;
        }
    }
}

