/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlProperties;

public class ServerProperties
extends HsqlProperties {
    static final int SERVER_PROPERTY = 0;
    static final int SERVER_MULTI_PROPERTY = 1;
    static final int SYSTEM_PROPERTY = 2;
    static final String sc_key_prefix = "server";
    static final String sc_key_address = "server.address";
    static final String sc_key_autorestart_server = "server.restart_on_shutdown";
    static final String sc_key_database = "server.database";
    static final String sc_key_dbname = "server.dbname";
    static final String sc_key_no_system_exit = "server.no_system_exit";
    static final String sc_key_port = "server.port";
    static final String sc_key_http_port = "server.port";
    static final String sc_key_silent = "server.silent";
    static final String sc_key_tls = "server.tls";
    static final String sc_key_trace = "server.trace";
    static final String sc_key_web_default_page = "server.default_page";
    static final String sc_key_web_root = "server.root";
    static final String sc_key_max_connections = "server.maxconnections";
    static final String sc_key_remote_open_db = "server.remote_open";
    static final String sc_key_max_databases = "server.maxdatabases";
    static final String sc_key_acl = "server.acl";
    static final String sc_key_daemon = "server.daemon";
    static final String sc_key_props = "server.props";
    static final String sc_key_system = "system";
    static final String sc_default_web_mime = "text/html";
    static final String sc_default_web_page = "index.html";
    static final String sc_default_web_root = ".";
    static final HashMap<String, HsqlProperties.PropertyMeta> serverMeta = new HashMap();
    static final OrderedHashSet prefixes = new OrderedHashSet();
    final int protocol;
    protected boolean initialised = false;
    IntKeyHashMap idToAliasMap = new IntKeyHashMap();
    IntKeyHashMap idToPathMap = new IntKeyHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProperties(int protocol, File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            this.stringProps.load(fis);
        }
        this.protocol = protocol;
    }

    ServerProperties(int protocol) {
        this.protocol = protocol;
    }

    ServerProperties(int protocol, String path, String extension) {
        super(path, extension);
        this.protocol = protocol;
    }

    @Override
    public void validate() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String error;
            String key = (String)en.nextElement();
            HsqlProperties.PropertyMeta meta = serverMeta.get(key);
            if (meta == null) {
                meta = this.getPrefixedMetadata(key);
            }
            if (meta == null) {
                error = "unsupported property: " + key;
                super.addError(0, error);
                continue;
            }
            error = null;
            if (meta.propType == 2) {
                error = this.validateSystemProperty(key, meta);
            } else if (meta.propType == 1) {
                error = this.validateMultiProperty(key, meta);
            } else {
                String value = this.getProperty(key);
                if (value == null) {
                    if (meta.propDefaultValue == null) {
                        error = "missing value for property: " + key;
                    } else {
                        this.setProperty(key, meta.propDefaultValue.toString());
                    }
                } else {
                    error = HsqlProperties.validateProperty(key, value, meta);
                }
            }
            if (error == null) continue;
            super.addError(0, error);
        }
        Iterator it = this.idToAliasMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToPathMap.containsKey(number)) continue;
            this.addError(0, "no path for database id: " + number);
        }
        it = this.idToPathMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToAliasMap.containsKey(number)) continue;
            this.addError(0, "no alias for database id: " + number);
        }
        this.initialised = true;
    }

    HsqlProperties.PropertyMeta getPrefixedMetadata(String key) {
        for (int i = 0; i < prefixes.size(); ++i) {
            String prefix = (String)prefixes.get(i);
            if (!key.startsWith(prefix)) continue;
            return serverMeta.get(prefix);
        }
        return null;
    }

    String validateMultiProperty(String key, HsqlProperties.PropertyMeta meta) {
        String path;
        String alias;
        String existing;
        int dbNumber;
        String prefix = meta.propName;
        if (meta.propName.equals(sc_key_database) && sc_key_database.equals(key)) {
            key = key + ".0";
        }
        try {
            dbNumber = Integer.parseInt(key.substring(prefix.length() + 1));
        }
        catch (NumberFormatException e1) {
            return "malformed database enumerator: " + key;
        }
        if (meta.propName.equals(sc_key_dbname) ? (existing = this.idToAliasMap.put(dbNumber, alias = this.stringProps.getProperty(key).toLowerCase())) != null : meta.propName.equals(sc_key_database) && (existing = this.idToPathMap.put(dbNumber, path = this.stringProps.getProperty(key))) != null) {
            return "duplicate database enumerator: " + key;
        }
        return null;
    }

    String validateSystemProperty(String key, HsqlProperties.PropertyMeta meta) {
        String prefix = meta.propName;
        String specificKey = key.substring(prefix.length() + 1);
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return "value required for property: " + key;
        }
        System.setProperty(specificKey, value);
        return null;
    }

    static {
        serverMeta.put(sc_key_database, ServerProperties.newMeta(sc_key_database, 1, null));
        serverMeta.put(sc_key_dbname, ServerProperties.newMeta(sc_key_dbname, 1, null));
        serverMeta.put(sc_key_system, ServerProperties.newMeta(sc_key_system, 2, null));
        serverMeta.put(sc_key_silent, ServerProperties.newMeta(sc_key_silent, 0, false));
        serverMeta.put(sc_key_trace, ServerProperties.newMeta(sc_key_trace, 0, false));
        serverMeta.put(sc_key_tls, ServerProperties.newMeta(sc_key_tls, 0, false));
        serverMeta.put(sc_key_acl, ServerProperties.newMeta(sc_key_acl, 0, null));
        serverMeta.put(sc_key_autorestart_server, ServerProperties.newMeta(sc_key_autorestart_server, 0, false));
        serverMeta.put(sc_key_remote_open_db, ServerProperties.newMeta(sc_key_remote_open_db, 0, false));
        serverMeta.put(sc_key_no_system_exit, ServerProperties.newMeta(sc_key_no_system_exit, 0, false));
        serverMeta.put(sc_key_daemon, ServerProperties.newMeta(sc_key_daemon, 0, false));
        serverMeta.put(sc_key_address, ServerProperties.newMeta(sc_key_address, 0, null));
        serverMeta.put("server.port", ServerProperties.newMeta("server.port", 0, 9001, 0, 65535));
        serverMeta.put("server.port", ServerProperties.newMeta("server.port", 0, 80, 0, 65535));
        serverMeta.put(sc_key_max_connections, ServerProperties.newMeta(sc_key_max_connections, 0, 100, 1, 10000));
        serverMeta.put(sc_key_max_databases, ServerProperties.newMeta(sc_key_max_databases, 0, 10, 1, 1000));
        prefixes.add(sc_key_database);
        prefixes.add(sc_key_dbname);
        prefixes.add(sc_key_system);
    }
}

